/*
Kasumi: Dictionary management tool for Anthy
Copyright (C) 2004 Takashi Nakamoto

This file is part of Kasumi

Kasumi is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Please send bug-reports, opinions and patches, if any, to me by E-Mail.
My E-mail address is following: bluedwarf@openoffice.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gtk/gtk.h>
#include <getopt.h> /* for getopt_long() */
#include <stdlib.h>
#include <locale.h> /* for LC_ALL definition */
#include "intl.h"
#include "topwindow.h"
#include "io.h"
#include "anthy_dic.h"

int main(int argc, char *argv[])
{
  int c;
  char *contents;
  char *home;
  enum {TOP,ADD} mode = TOP;

  /* i18n configuration for gettext*/
  setlocale(LC_ALL, "");
  bindtextdomain(PACKAGE, LOCALEDIR);
  bind_textdomain_codeset(PACKAGE, "UTF-8");
  textdomain(PACKAGE);
  
  gtk_init(&argc, &argv);

  while(1){
    int this_option_optind = optind ? optind : 1;
    int option_index = 0;
    static struct option long_options[] = {
      {"help", no_argument, NULL, 'h'},
      {"version", no_argument, NULL, 'v'},
      {"add", no_argument, NULL, 'a'}
    };
    
    c = getopt_long(argc, argv, "hv", long_options, &option_index);
    if(c == -1) break;

    switch(c){
    case 'h':
      g_print("Show help!\n");
      break;
    case 'v':
      g_print("kasumi %s\n", VERSION);
      g_print("Copyright (C) 2004 Takashi Nakamoto.\n");
      g_print("This program comes with NO WARRANTY, to the extent permitted" \
              "by law. \nYou may redistribute it under the terms of the GNU " \
              "General Public License; \nsee the file named COPYING for " \
              "details.\n");
      exit(0);
      break;
    case 'a':
      mode = ADD;
      break;
    case '?':
      g_print("Argument error.\n");
      exit(0);
      break;
    }
  }

  if(optind < argc){
    g_print("non-option ARGV-elements: ");
    while (optind < argc)
      g_print("%s ", argv[optind++]);
    g_print("\n");
  }

  /* obtain anthy dictionary file name */
  home = getenv("HOME");
  if(home != NULL){
    dic_filename = strcat(home,"/.anthy/private-dic.src");
    free(home);
  }else{
    g_printf("Cannot find $HOME environment variable.\n");
  }

  create_wordlist();

  contents = read_data_from_dic();
  analyze_anthy_dic(contents);
  free(contents);
  
  if(mode == TOP){
    create_top_window();

    gtk_main();
  }else if(mode == ADD){
    create_add_window();

    gtk_main();
  }

  return 0;
}
