/*
Kasumi: Dictionary management tool for Anthy
Copyright (C) 2004 Takashi Nakamoto

This file is part of Kasumi

Kasumi is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Please send bug-reports, opinions and patches, if any, to me by E-Mail.
My E-mail address is following: bluedwarf@openoffice.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gtk/gtk.h>
#include "intl.h"
#include "wordlist.h"

GtkWidget *create_wordlist(){
  GtkCellRenderer *renderer;

  wordview = gtk_tree_view_new();

  renderer = gtk_cell_renderer_text_new();
  gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(wordview),-1,
                                              _("Word"),renderer,
                                              "text",COL_WORD,
                                              NULL);

  gtk_tree_view_column_new();
  renderer = gtk_cell_renderer_text_new();
  gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(wordview),-1,
                                              _("Yomi"),renderer,
                                              "text",COL_YOMI,
                                              NULL);

  gtk_tree_view_column_new();  
  renderer = gtk_cell_renderer_text_new();
  gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(wordview),-1,
                                              _("Frequency"),renderer,
                                              "text",COL_FREQ,
                                              NULL);

  gtk_tree_view_column_new();  
  renderer = gtk_cell_renderer_text_new();
  gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(wordview),-1,
                                              _("Part of Speech"),renderer,
                                              "text",COL_PART,
                                              NULL);

  wordlist = gtk_list_store_new(NUM_COLS,G_TYPE_STRING,G_TYPE_STRING,
                                G_TYPE_UINT,G_TYPE_STRING);
  gtk_tree_view_set_model(GTK_TREE_VIEW(wordview),GTK_TREE_MODEL(wordlist));

  /* destroy model automatically with view */  
  g_object_unref(GTK_TREE_MODEL(wordlist));

  return wordview;
}
