unit BrowserView;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	Buttons, OleCtrls, SHDocVw, ExtCtrls, Katjusha, ComCtrls, ActnList, Menus, StrUtils,
	StdCtrls, Math, MSHTML, Variants, ShellApi, EmbeddedWB, ImgList, ToolWin;

type
	TBrowserViewFrame = class(TFrame)
    TopPanel: TPanel;
		IdPopupMenu: TPopupMenu;
		ActionList: TActionList;
    IdAttention: TAction;
    ID1: TMenuItem;
    IdAborn: TAction;
    IdInvisibleAborn: TAction;
    ID2: TMenuItem;
    ID3: TMenuItem;
		MainPopupMenu: TPopupMenu;
    MainAborn: TAction;
    MainInvisibleAborn: TAction;
    MainContentsAborn: TAction;
    MainContentsInvisibleAborn: TAction;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    ToolPopupMenu: TPopupMenu;
    ToolAbornConvert: TAction;
    N5: TMenuItem;
    TitleLabel: TLabel;
    Browser: TEmbeddedWB;
    N6: TMenuItem;
    CharSizeMenuItem: TMenuItem;
    N8: TMenuItem;
    N9: TMenuItem;
    N10: TMenuItem;
    N11: TMenuItem;
    N12: TMenuItem;
    ToolBar: TToolBar;
    ToolButton: TToolButton;
    ImageList1: TImageList;
    SaveButton: TToolButton;
    CloseButton: TToolButton;
    ToolSaveHtml: TAction;
    HTML1: TMenuItem;
    SaveDialog: TSaveDialog;
    ToolDoubleGetDelete: TAction;
    N7: TMenuItem;
    HintTimer: TTimer;
    procedure BrowserBeforeNavigate2(Sender: TObject;
			const pDisp: IDispatch; var URL, Flags, TargetFrameName, PostData,
			Headers: OleVariant; var Cancel: WordBool);
    procedure IdAttentionExecute(Sender: TObject);
    procedure TopPanelResize(Sender: TObject);
    procedure MainContentsInvisibleAbornExecute(Sender: TObject);
    procedure IdInvisibleAbornExecute(Sender: TObject);
    procedure IdAbornExecute(Sender: TObject);
    procedure MainContentsAbornExecute(Sender: TObject);
    procedure ToolAbornConvertExecute(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure ToolPopupMenuPopup(Sender: TObject);
    procedure ToolSaveHtmlExecute(Sender: TObject);
    procedure BrowserNewWindow2(Sender: TObject; var ppDisp: IDispatch;
      var Cancel: WordBool);
    procedure MainAbornExecute(Sender: TObject);
    procedure MainInvisibleAbornExecute(Sender: TObject);
		procedure ToolDoubleGetDeleteExecute(Sender: TObject);
    procedure BrowserStatusTextChange(Sender: TObject;
      const Text: WideString);
    procedure HintTimerTimer(Sender: TObject);
	private
		{ Private 錾 }
		DatList: T2chThreadDat;
		NoticeId: string;
		NoticeIndex: Integer;
		FThreadIdx: T2chThreadIndex;
		FModified: Boolean;
		FPopupHint: THintWindow;
		FHintThreadData: TParse2chURLData;
    FTopIndex: Integer;
		procedure SetThreadIdx(const Value: T2chThreadIndex);
		procedure LoadThread(ThreadIdx: T2chThreadIndex);
		procedure DatListToHtml(SetScroll: Boolean = False; AScrollTop: Integer = -1);
		procedure SetModified(const Value: Boolean);
		procedure DoIdAborn(const IdStr: string; const Invisible: Boolean);
		procedure DoContentsAborn(Index: Integer; Invisible: Boolean);
		procedure CharSizeMenuItemClick(Sender: TObject);
		procedure ShowHint(const Text: string);
		procedure AppDeactivate(Sender: TObject);
		function ScrollToAnchor(num: integer; isTop: boolean): boolean;
	public
		{ Public 錾 }
		constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
		property ThreadIdx: T2chThreadIndex read FThreadIdx write SetThreadIdx;
		property Modified: Boolean read FModified write SetModified;
		property TopIndex: Integer write FTopIndex;
	end;

implementation

{$R *.dfm}

uses ActiveX, AWKFunc, HtmlSaveDialog, FavMain, FavUtils;

{ TBrowserViewFrame }

constructor TBrowserViewFrame.Create(AOwner: TComponent);
var
	I: Integer;
begin
	inherited;

	DatList := T2chThreadDat.Create;
	FThreadIdx := T2chThreadIndex.Create;
	FPopupHint := THintWindow.Create(Self);
	FPopupHint.Color := clInfoBk;
	Application.OnDeactivate := AppDeactivate;
	FTopIndex := -1;
	
	{ TCYj[nhݒ }
	for I := 0 to CharSizeMenuItem.Count - 1 do
		CharSizeMenuItem.Items[I].OnClick := CharSizeMenuItemClick;

	{ 󔒃y[W\ }
{	Browser.AssignDocument;}
end;

procedure TBrowserViewFrame.LoadThread(ThreadIdx: T2chThreadIndex);
begin
	DatList.LoadFromFile(TKatjusha.GetKatjushaBaseDir + ChangeFileExt('log\' + ThreadIdx.LogPath, '.dat'));
	if FTopIndex > 0
		then DatListToHtml(True, FTopIndex - 1)
		else DatListToHtml;
	FTopIndex := -1;
end;

procedure TBrowserViewFrame.BrowserBeforeNavigate2(Sender: TObject;
	const pDisp: IDispatch; var URL, Flags, TargetFrameName, PostData,
	Headers: OleVariant; var Cancel: WordBool);
begin
	Cancel := True;
	if AnsiStartsStr('idmenu:', URL) then
	begin
		NoticeId := Copy(URL, 8, 8);
		IdPopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y)
	end else if AnsiStartsStr('menu:', URL) then
	begin
		NoticeIndex := StrToInt(Copy(URL, 6, 4)) - 1;
		MainPopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y)
	end else if AnsiStartsStr('http://', URL) then
	begin
		ShellExecute(Application.MainForm.Handle, 'open', PChar(string(URL)), nil, nil, SW_SHOW);
	end	else
		Cancel := False;
end;

procedure TBrowserViewFrame.SetThreadIdx(const Value: T2chThreadIndex);
begin
	if (FThreadIdx.LogPath <> Value.LogPath) or FModified then
	begin
		TitleLabel.Caption := 'Xbhǂݍݒłc';
		LoadThread(Value);
		Modified := False;
	end else if FTopIndex > 0 then
	begin
		ScrollToAnchor(FTopIndex - 1, True);
		FTopIndex := -1;
	end;

	FThreadIdx.Assign(Value);
	TitleLabel.Caption := Format('[%s] ', [FThreadIdx.BoardName]) + FThreadIdx.ThreadName + Format('(%d)', [FThreadIdx.ResCount]);
end;

destructor TBrowserViewFrame.Destroy;
begin
	DatList.Free;
	FThreadIdx.Free;
{	FPopupHint.Free;}
	Application.OnDeactivate := nil;
  inherited;
end;

procedure TBrowserViewFrame.DatListToHtml(SetScroll: Boolean; AScrollTop: Integer);
const
	RES_HTML = 'Res.htm';
	HEADER_HTML = 'Header.htm';
var
	ResText, Text, MailName, Number, DateStr, IdStr: string;
	List: TStringList;
	I, P: Integer;
	DatArray: array [0 .. 4] of string;
	Doc: IHTMLDocument2;
	ScrollTop: Integer;
{ GetTopRes }
(* ̃[`͉ *)
  function GetTopRes: integer;
  var
    anchors: OleVariant;
    top, i, len: integer;
    function search(base, size: integer): integer;
    var
      off: integer;
    begin
      if size <= 1 then
      begin
        result := base;
        exit;
      end;
      off := size div 2;
      if top < anchors.item(base + off).offsetTop then
        result := search(base, off)
      else
        result := search(base + off, size - off);
    end;
  begin
    result := 0;
    try
      top := olevariant(IHTMLDocument2(browser.Document)).body.scrollTop;
      anchors := OleVariant(browser.Document as IHTMLDocument2).anchors;
      len := anchors.length;
      i := search(0, len) -1;
      if i < 0 then i := 0;
      while i < len do
      begin
        result := i;
        if (top <= anchors.item(i).offsetTop) then
          break;
        inc(i);
      end;
    except
    end;
	end;
begin
	List := TStringList.Create;

	try
		ScrollTop := 0;
		if AScrollTop < 0 then
		begin
			if SetScroll then
			begin
				Doc := Browser.Document as IHTMLDocument2;
				ScrollTop := GetTopRes;
			end;
		end else
		begin
			ScrollTop := AScrollTop;
		end;

		Browser.AssignDocument;

		List.LoadFromFile(TKatjusha.GetKatjushaBaseDir + RES_HTML);
		ResText := List.Text;
		List.LoadFromFile(TKatjusha.GetKatjushaBaseDir + HEADER_HTML);

		for I := 0 to DatList.Count - 1 do
		begin
			DatList.Split(I, DatArray);
			if DatArray[2] = 'ځ`' then
			begin
				{ AJ[͂Ƃ肠o͂ }
				Text := Format('<a name="a%d"></a>', [I + 1]);
				List.Add(Text);
				Continue;
			end;

			Number := Format('<A HREF="menu:%d">%d</A>', [I + 1, I + 1]);
			DateStr := DatArray[2];

			P := Pos('ID:', DateStr);
			if P > 0 then
			begin
				IdStr := Copy(DateStr, P + 3, 8);
				DateStr := StringReplace(DateStr, IdStr, '<A HREF="idmenu:' + IdStr + '">' + IdStr + '</A>', []);
			end;

			if DatArray[1] <> '' then
				MailName := '<A HREF="mailto:' + DatArray[1] + '">' + DatArray[0] + '</A>'
			else
				MailName := DatArray[0];

			Text := StringReplace(ResText, '&PLAINNUMBER', IntToStr(I + 1), [rfReplaceAll]);
			Text := StringReplace(Text, '&NUMBER', Number, []);
			Text := StringReplace(Text, '&MAILNAME', MailName, []);
			Text := StringReplace(Text, '&MAIL', DatArray[1], []);
			Text := StringReplace(Text, '&NAME', DatArray[0], []);
			Text := StringReplace(Text, '&DATE', DateStr, []);
			Text := StringReplace(Text, '&MESSAGE', DatArray[3], []);
			Text := Format('<a name="a%d"></a>', [I + 1]) + Text;
			
			List.Add(Text);

			if (I mod 100) = 0 then
			begin
				OleVariant(Browser.Document as IHTMLDocument2).write(List.Text);
				Application.ProcessMessages;
				List.Clear;
			end;
		end;

{		Browser.LoadFromStrings(List);}
		if List.Count > 0 then
		begin
			OleVariant(Browser.Document as IHTMLDocument2).write(List.Text);
			Application.ProcessMessages;
		end;

		if SetScroll then
		begin
			Doc := Browser.Document as IHTMLDocument2;
			while Doc.anchors.length < DatList.Count do
				Application.ProcessMessages;
			ScrollToAnchor(ScrollTop, True);
		end;
	finally
		List.Free;
	end;
end;

procedure TBrowserViewFrame.IdAttentionExecute(Sender: TObject);
var
	DateStr: string;
	P, I: Integer;
begin
	for I := 0 to DatList.Count - 1 do
	begin
		DateStr := DatList.Dates[I];
		if DateStr = 'ځ`' then Continue;

		P := Pos('ID:', DateStr);
		if (not ((P > 0) and (Copy(DateStr, P + 3, 8) = NoticeId))) then
			DatList.Aborn(I, True);
	end;

	Modified := True;
	DatListToHtml(True);
end;

procedure TBrowserViewFrame.TopPanelResize(Sender: TObject);
begin
	ToolBar.Left := TopPanel.ClientWidth - ToolBar.Width - 8;
end;

procedure TBrowserViewFrame.MainContentsInvisibleAbornExecute(
  Sender: TObject);
begin
	DoContentsAborn(NoticeIndex, True);
	if Modified then DatListToHtml(True);
end;

procedure TBrowserViewFrame.SetModified(const Value: Boolean);
begin
	FModified := Value;
	SaveButton.Enabled := Value;
end;

procedure TBrowserViewFrame.IdInvisibleAbornExecute(Sender: TObject);
begin
	DoIdAborn(NoticeId, True);
	if Modified then DatListToHtml(True);
end;

procedure TBrowserViewFrame.IdAbornExecute(Sender: TObject);
begin
	DoIdAborn(NoticeId, False);
	if Modified then DatListToHtml(True);
end;

procedure TBrowserViewFrame.DoIdAborn(const IdStr: string; const Invisible: Boolean);
var
	Count: Integer;
begin
	Count := DatList.IdAborn(IdStr, Invisible);
	if Count > 0 then
		Modified := True;
end;

procedure TBrowserViewFrame.DoContentsAborn(Index: Integer;
	Invisible: Boolean);
var
	I, Count: Integer;
	AbornStr, Str: string;
begin
	Count := 0;

	AbornStr := AnsiReplaceStr(DatList.Messages[Index], '<br>', '');
	AbornStr := AnsiReplaceStr(AbornStr, '@', '');
	AbornStr := AnsiReplaceStr(AbornStr, ' ', '');

	for I := 0 to DatList.Count - 1 do
	begin
		Str := AnsiReplaceStr(DatList.Messages[I], '<br>', '');
		Str := AnsiReplaceStr(Str, '@', '');
		Str := AnsiReplaceStr(Str, ' ', '');
		
		if Str = AbornStr then
		begin
			Inc(Count);
			DatList.Aborn(I, Invisible);
		end;
	end;

	if Count > 0 then
	begin
		ShowMessage(Format('%d̃Xځ`񂵂܂B', [Count]));
		Modified := True;
	end;
end;

procedure TBrowserViewFrame.MainContentsAbornExecute(Sender: TObject);
begin
	DoContentsAborn(NoticeIndex, False);
	if Modified then DatListToHtml(True);
end;

procedure TBrowserViewFrame.ToolAbornConvertExecute(Sender: TObject);
var
  DateStr: string;
	AbornFlag: array [0 .. 999] of Char;
	I, Count: Integer;
	OrigCursor: TCursor;
begin
	Count := 0;
	FillChar(AbornFlag, SizeOf(AbornFlag), 0);

	OrigCursor := Screen.Cursor;
	Screen.Cursor := crHourGlass;
	Application.ProcessMessages;

	try
		for I := 0 to DatList.Count - 1 do
		begin
			DateStr := DatList.Dates[I];
			if (DateStr = 'ځ`') or (DateStr = 'ځ[') then
			begin
				Inc(Count);
				AbornFlag[I] := #1;
			end;
		end;

		if Count = 0 then
			ShowMessage('ځ[͌܂łB')
		else begin
			if MessageDlg(Format('ځ[%d݂܂Bځ`ɕϊ܂H', [Count]), mtInformation, [mbYes, mbNo], -1) = mrYes then
			begin
				for I := 0 to Min(999, DatList.Count - 1) do
					if AbornFlag[I] = #1 then
						DatList.Aborn(I, True);
						
				Modified := True;
				DatListToHtml(True);
			end;
		end;
	finally
		Screen.Cursor := OrigCursor;
	end;
end;

procedure TBrowserViewFrame.SaveButtonClick(Sender: TObject);
var
	Index: T2chThreadIndex;
begin
	if MessageDlg('ύX_ۑ܂B낵łH', mtWarning, mbOKCancel, 0) = mrOk then
	begin
		{ ŐVIDXǂݍ }
		FThreadIdx.LoadFromFile(TKatjusha.GetKatjushaBaseDir + 'log\' + FThreadIdx.LogPath);
		if FThreadIdx.ResCount <> DatList.Count then
			if MessageDlg('XۂdatƈقȂ܂Bidxւ܂H', mtWarning, mbOKCancel, 0) = mrOk then
			begin
				{ Ô߂xǂݍ }
				FThreadIdx.LoadFromFile(TKatjusha.GetKatjushaBaseDir + 'log\' + FThreadIdx.LogPath);
				FThreadIdx.ResCount := DatList.Count;
				FThreadIdx.SaveToFile(TKatjusha.GetKatjushaBaseDir + 'log\' + FThreadIdx.LogPath);

				Index := (Application.MainForm as TKatfavMainForm).MasterIndex.LogPathOfObject(FThreadIdx.LogPath);
				if Index <> nil then
				begin
					Index.ResCount := FThreadIdx.ResCount;
					if Index.ResState = rsError then
						Index.ResState := rsNone;
					(Application.MainForm as TKatfavMainForm).Refresh(Index);
				end;
			end;

		DatList.SaveToFile(TKatjusha.GetKatjushaBaseDir + ChangeFileExt('log\' + ThreadIdx.LogPath, '.dat'));
		Modified := False;
	end;
end;

procedure TBrowserViewFrame.ToolPopupMenuPopup(Sender: TObject);
var
	Zoom: Integer;
begin
	Zoom := Browser.ZoomValue;
	CharSizeMenuItem.Items[4 - Zoom].Checked := True;
end;

procedure TBrowserViewFrame.CharSizeMenuItemClick(Sender: TObject);
begin
	Browser.Zoom(4 - CharSizeMenuItem.IndexOf(TMenuItem(Sender)));
end;

procedure TBrowserViewFrame.ToolSaveHtmlExecute(Sender: TObject);
const
	Header =	'<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2//EN">'#13#10 +
						'<HTML>'#13#10 +
						'<HEAD>'#13#10 +
						'<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=x-sjis">';
	Title =	'<TITLE><\TITLE></TITLE>'#13#10'</HEAD>'#13#10 +
					'<BODY TEXT="#000000" BGCOLOR="#EFEFEF" LINK="#0000FF" ALINK="#FF0000" VLINK="#660099">'#13#10 +
					'<P><FONT SIZE=+1 COLOR="#FF0000"><\TITLE></FONT></B><BR>'#13#10 +
					'<DL>';
	Res =	'<DT><\NUM> OF<FONT COLOR="forestgreen"><\NAME></FONT> eF<\DATE><DD> <\MES><BR><BR>';
	Footer =	'</DL>'#13#10 +
						'<HR>'#13#10 +
						'<DIV ALIGN="right"><FONT size=-1><A HREF="http://katfav.sourceforge.jp/" target=_blank>'#13#10 +
						'Katfav</A> <\VERSION> Converted.</FONT></DIV>'#13#10 +
						'</BODY>'#13#10 +
						'</HTML>';

var
	Text, MailName, Number, DateStr: string;
	List: TStringList;
	I: Integer;
	DatArray: array [0 .. 4] of string;
begin
	List := TStringList.Create;

	try
		List.Add(Header);
		List.Add(StringReplace(Title, '<\TITLE>', ThreadIdx.ThreadName, [rfReplaceAll]));

		for I := 0 to DatList.Count - 1 do
		begin
			DatList.Split(I, DatArray);
			if DatArray[2] = 'ځ`' then Continue;

			Number := Format('<A NAME="R%d">%d', [I + 1, I + 1]);
			DateStr := DatArray[2];

			if DatArray[1] <> '' then
				MailName := '<A HREF="mailto:' + DatArray[1] + '">' + DatArray[0] + '</A>'
			else
				MailName := DatArray[0];

			Text := StringReplace(Res, '<\NUM>', Number, []);
			Text := StringReplace(Text, '<\NAME>', MailName, []);
			Text := StringReplace(Text, '<\DATE>', DateStr, []);
			Text := StringReplace(Text, '<\MES>', DatArray[3], []);

			List.Add(Text);
		end;

		List.Add(StringReplace(Footer, '<\VERSION>', (Application.MainForm as TKatfavMainForm).Version, []));

		SaveDialog.FileName := CurrToStr(ThreadIdx.ThreadNum) + '.html';
		if SaveDialog.Execute then
			List.SaveToFile(SaveDialog.FileName);

	finally
		List.Free;
	end;
end;

procedure TBrowserViewFrame.BrowserNewWindow2(Sender: TObject;
	var ppDisp: IDispatch; var Cancel: WordBool);
var
	URL: string;
	Data: TParse2chURLData;
begin
	Cancel := True;
	URL := (TEmbeddedWB(Sender).Document as IHTMLDocument2).activeElement.outerHTML;
	if AWKMatch1('<[Aa][ '#9']+[hH][rR][eE][fF]="([^"]+)"', AWKGSub('&amp;', '&', URL), URL) >= 0 then
		if Parse2chURL(URL, Data) then
		begin
			if (FThreadIdx.ServerName = Data.ServerName) and (FThreadIdx.BoardPath = Data.BoardName) and
				 (FThreadIdx.ThreadNum = Data.ThreadNum) and (Data.StartIndex > 0) then
				ScrollToAnchor(Data.StartIndex - 1, True)
			else
				CallKatjusha(URL);
		end else
			CallBrowser(URL);
end;

procedure TBrowserViewFrame.MainAbornExecute(Sender: TObject);
begin
	DatList.Aborn(NoticeIndex, False);
	Modified := True;
	DatListToHtml(True);
end;

procedure TBrowserViewFrame.MainInvisibleAbornExecute(Sender: TObject);
begin
	DatList.Aborn(NoticeIndex, True);
	Modified := True;
	DatListToHtml(True);
end;

procedure TBrowserViewFrame.ToolDoubleGetDeleteExecute(Sender: TObject);
var
	Before, DateTime: TDateTime;
	I, J, K, Index, Count, IgnoreCount: Integer;
	Button: Integer;
	P: PChar;
	Found: Boolean;
	DateStr: string;
	DateVar: Variant;
begin
	Before := Now;
	DateTime := Before + 1;
	Found := False;
	Button := 0;
	IgnoreCount := 0;
	P := nil;
	DateVar := Null;

	try
		I := 0;

		while I < DatList.Count do
		begin
			DateVar := DatList.DateTimes[I];
			if DateVar <> Null then
			begin
				Before := DateVar;
				Break;
			end;
			Inc(I);
		end;

		P := AllocMem(DatList.Count);
		
		while I < DatList.Count - 1 do
		begin
			{ JE^CNg }
			Inc(I);
			
			{ łɃ`FbNꂽs͔΂ }
			if IgnoreCount > 0 then
			begin
				Dec(IgnoreCount);
				Continue;
			end;
			
			{ ځ`Aځ`͔̎΂ }
			DateStr := DatList.Dates[I];
			if (DateStr = 'ځ[') or (DateStr = 'ځ`') or (DateStr = 'ځ`') or
					(DateStr = 'Over 1000 Thread') or (DateStr = 'Katjusha extender') then
				Continue;

			DateVar := DatList.DateTimes[I];
			if DateVar = Null
				then Continue	{ G[ꍇContinue }
				else DateTime := DateVar;

			if Before < DateTime then
			begin
				{ tOサĂȂꍇContinue }
				Before := DateTime;
				Continue;
			end;

			Index := DatList.IndexOf(DatList[I]);
			{ Ôق̍sɑSeƂ }
			if Index < I then
			begin
				Found := True;
				
				K := I + 1;
				for J := Index + 1 to I - 1 do
				begin
					if K >= DatList.Count then
						{ K̂قɓꍇ͔ }
						Break;

					if DatList[J] = DatList[K] then
						Inc(K)
					else
						Break;
				end;
				Dec(K);

				if Index + 1 > I - 1 then
					K := I;

				if I <= K then
				begin
					{ (K - I)s͖ }
					IgnoreCount := K - I;
					
					{ }b`s }
					Button := MessageDlg('d擾܂B'#13#10 +
						Format('X%d%d܂ł%dłB폜܂H', [I + 1, K + 1, K - I + 1]) + #13#10 +
						'(1̏ꍇ͂قƂǓdełBXԍŊmFĂ)',
						mtWarning, [mbYes, mbNo, mbAbort], 0);

					if Button = mrYes then
						for Index := I to K do
							P[Index] := #1;

					if Button = mrAbort then
						Break;
				end;
			end;
		end;

    Count := 0;

		if Button <> mrAbort then
			for I := DatList.Count - 1 downto 0 do
				if P[I] = #1 then
				begin
					Inc(Count);
					DatList.Delete(I);
				end;
	finally
		FreeMem(P);
	end;

	if not Found then
		ShowMessage('d擾͌܂łB')
	else if Button <> mrAbort then begin
		ShowMessage(IntToStr(Count) + '̃X폜܂B');
		if Count > 0 then
		begin
			Modified := True;
			DatListToHtml(True);
		end;
	end;
end;

procedure TBrowserViewFrame.BrowserStatusTextChange(Sender: TObject;
	const Text: WideString);
var
	PopupText: AnsiString;
	S: string;
	Data: TParse2chURLData;
	I: Integer;
	P: TPoint;
	Element: IHTMLElement;
{ Trim }
	procedure Trim(var Str: string);
	var
		I: Integer;
	begin
		I := Length(Str);
		while I > 0 do
		begin
			case Str[I] of
				#13, #10, #9, ' ': Dec(I);
				else Break;
			end;
		end;
		SetLength(Str, I);
	end;
{ ThreadPopup }
	procedure ThreadPopup;
	var
		ThreadIdx: T2chThreadIndex;
	begin
		ThreadIdx := T2chThreadIndex.Create;
		try
			try
				ThreadIdx.LoadFromFile(TKatjusha.GetKatjushaBaseDir + 'log\' + Data.LogPath);
			except
				on EFOpenError do
				begin
					FHintThreadData := Data;
					HintTimer.Enabled := True;
					Exit;
				end;
				else
					raise;
			end;
			ShowHint(Format('[%s] %s(%d)', [ThreadIdx.BoardName, ThreadIdx.ThreadName, ThreadIdx.ResCount]));
		finally
			ThreadIdx.Free;
		end;
	end;
{ HalfWidthNum }
	function HalfWidthNum(const Text: WideString): string;
	var
		I, J: Integer;
		C: WideChar;
	const
		FullWidth: array [0 .. 11] of string = ('', '', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'O');
		HalfWidth: array [0 .. 11] of Char = ('>', '=', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0');
	begin
		Result := '';
		for I := 1 to Length(Text) do
		begin
			C := Text[I];
			for J := 0 to 11 do
				if C = FullWidth[J] then
				begin
					C := WideChar(HalfWidth[J]);
					Break;
				end;
			Result := Result + C;
		end;
	end;
{ ThreadNumPopup }
	function ThreadNumPopup(const Text: string): string;
	var
		List: TStringList;
		S: string;
		I, Index: Integer;
	begin
		Result := '';
		List := TStringList.Create;
		try
			S := '';
			for I := 1 to Length(Text) do
			begin
				case Text[I] of
					'0' .. '9': S := S + Text[I];
					else
						if S <> '' then
						begin
							List.Add(Format('%05d', [StrToInt(S)]));
							S := '';
						end;
				end;
			end;

			if S <> '' then
				List.Add(Format('%05d', [StrToInt(S)]));

			List.Sort;

			for I := 0 to List.Count - 1 do
			begin
				Index := StrToInt(List[I]) - 1;
				if Index >= DatList.Count then Break;
				if I > 0 then
					Result := Result + #13#10#13#10;
				S := Format('%d OF%s eF%s'#13#10, [Index + 1, DatList.Names[Index], DatList.Dates[Index]]);
				S := S + DatList.Messages[Index];
				S := HTML2String(S);
				Trim(S);
				Result := Result + S;
			end;
		finally
			List.Free;
		end;
	end;
begin
	if AnsiStartsText('http://', Text) then
	begin
		if Parse2chURL(Text, Data) then
		begin
			if (FThreadIdx.ServerName = Data.ServerName) and (FThreadIdx.BoardPath = Data.BoardName) and
				 (FThreadIdx.ThreadNum = Data.ThreadNum) then
			begin
				if (Data.StartIndex > 0) and (Data.StartIndex <= DatList.Count) then
				begin
					I := Data.StartIndex - 1;
					S := Format('%d OF%s eF%s'#13#10, [I + 1, DatList.Names[I], DatList.Dates[I]]);
					S := S + DatList.Messages[I];
					PopupText := HTML2String(S);
					Trim(PopupText);
					for I := Data.StartIndex to Min(Data.EndIndex - 1, DatList.Count - 1) do
					begin
						PopupText := PopupText + #13#10#13#10;
						S := Format('%d OF%s eF%s'#13#10, [I + 1, DatList.Names[I], DatList.Dates[I]]);
						S := S + DatList.Messages[I];
						S := HTML2String(S);
						Trim(S);
						PopupText := PopupText + S;
					end;
					ShowHint(PopupText);
				end;
			end else if (Data.StartIndex < 0) and (Data.EndIndex < 0) then
				ThreadPopup;
		end else
			HintTimer.Enabled := False;
	end else if AnsiStartsText('mailto:', Text) then
	begin
		P := Mouse.CursorPos;
		P := Browser.ScreenToClient(P);
		Element := (Browser.Document as IHTMLDocument2).elementFromPoint(P.X, P.Y);
		PopupText := Copy(Text, 8, MaxInt);

		S := HalfWidthNum(Element.innerText);
		if AWKMatch('^(>|>>)?([0-9]+)(=(>|>>)?[0-9]+)*$', S, nil) >= 0 then
			PopupText := PopupText + #13#10 + ThreadNumPopup(S);

		ShowHint(PopupText);
	end else
	begin
		FPopupHint.ReleaseHandle;
		HintTimer.Enabled := False;
	end;
end;

function PointInControl(P: TPoint; Control: TControl): Boolean;
begin
	P := Control.ScreenToClient(P);
	Result := (0 <= P.X) and (P.X < Control.Width) and
						(0 <= P.Y) and (P.Y < Control.Height);
end;

procedure TBrowserViewFrame.ShowHint(const Text: string);
var
	P: TPoint;
	R: TRect;
begin
	if not Application.Active then Exit;
	P := Mouse.CursorPos;
	if not PointInControl(P, Browser) then Exit;

	R := FPopupHint.CalcHintRect(Screen.Width, Text, nil);
	
	Dec(P.X, 8);
	Dec(P.Y, R.Bottom + 8);
	Inc(R.Left, P.X);
	Inc(R.Right, P.X);
	Inc(R.Top, P.Y);
	Inc(R.Bottom, P.Y);

	FPopupHint.ActivateHint(R, Text);
end;

procedure TBrowserViewFrame.AppDeactivate(Sender: TObject);
begin
	FPopupHint.ReleaseHandle;
end;

procedure TBrowserViewFrame.HintTimerTimer(Sender: TObject);
var
	Subject: T2chSubject;
	Index: Integer;
begin
	HintTimer.Enabled := False;
	Subject := nil;

	try
		Subject := T2chSubject.Create;
		try
			Subject.LoadFromFile(TKatjusha.GetKatjushaBaseDir + 'subject\' +
				URLToPath(FHintThreadData.ServerName + '/' + FHintThreadData.BoardName) + '.txt');
		except
			on EFOpenError do
				Exit;
			else
				raise;
		end;

		Index := Subject.IndexOf(FHintThreadData.ThreadNum);
		if Index >= 0 then
			ShowHint(Format('%s(%d)', [Subject[Index].Title, Subject[Index].ResCount]));
	finally
		Subject.Free;
	end;
end;

function TBrowserViewFrame.ScrollToAnchor(num: integer;
	isTop: boolean): boolean;
var
	doc: IDispatch;
	top: integer;
	len: integer;
	//anchor: string;
begin
	result := false;
	doc := browser.Document;
	if doc = nil then
		exit;
	if DatList.Count <= num then
		num := DatList.Count -1;

	if num < 0 then
		exit;
	try
		(* ʒuvZB␳͉Ƃ *)
		len := OleVariant(doc as IHTMLDocument2).anchors.length;
		if num < len then
		begin
			(*OleVariant(doc as IHTMLDocument2).anchors.item(num).scrollIntoView(true);*)
			top := OleVariant(doc as IHTMLDocument2).anchors.item(num).offsetTop;
			if not isTop then
				Dec(top, browser.Height - 40);
			OleVariant(doc as IHTMLDocument2).body.scrollTop := top - 10;
			result := true;
		end;
	except
	end;
end;

end.

