unit AllThreadSearchDlg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, StdCtrls, Buttons, ComCtrls, ExtCtrls, Katjusha;

type
  TAllThreadSearchForm = class(TForm)
    StaticText1: TStaticText;
    ProgressBar1: TProgressBar;
    CancelBtn: TBitBtn;
    Timer1: TTimer;
    procedure Timer1Timer(Sender: TObject);
  private
		{ Private 錾 }
		MasterIndex: T2chIndexList;
		AllThreadNode: TTreeNode;
	public
		{ Public 錾 }
		class function Execute(MasterIndex: T2chIndexList; AllThreadNode: TTreeNode): Boolean;
  end;

implementation

{$R *.dfm}

class function TAllThreadSearchForm.Execute(MasterIndex: T2chIndexList; AllThreadNode: TTreeNode): Boolean;
var
	AllThreadSearchForm: TAllThreadSearchForm;
begin
	AllThreadSearchForm := nil;
	try
		AllThreadSearchForm := TAllThreadSearchForm.Create(Application.MainForm);
		AllThreadSearchForm.MasterIndex := MasterIndex;
		AllThreadSearchForm.AllThreadNode := AllThreadNode;
		Result := (AllThreadSearchForm.ShowModal = mrOk);
	finally
		AllThreadSearchForm.Free;
	end;
end;

procedure TAllThreadSearchForm.Timer1Timer(Sender: TObject);
var
	DirList: TStringList;
	I: Integer;
	IndexList: T2chIndexList;
{GetLogFolder}
	procedure GetLogFolder(List: TStrings);
	var
		TmpDir, FindName: string;
		FindData: TSearchRec;
	begin
		FindName := TKatjusha.GetKatjushaBaseDir + 'log\*.*';

		if FindFirst(FindName, faDirectory, FindData) <> 0 then
			Exit;

		try
			repeat
				if (FindData.Attr and faDirectory) <> 0 then
				begin
					if (FindData.Name <> '.') and (FindData.Name <> '..') then
					begin
						TmpDir := 'log\' + FindData.Name;
						List.Add(TmpDir);
					end;
				end;
			until FindNext(FindData) <> 0;

		finally
			FindClose(FindData);
		end;
	end;
{GetAllThread}
	procedure GetAllThread(IndexList: T2chIndexList; DirName: string);
	var
		TmpDir, FindName: string;
		FindData: TSearchRec;
		ThreadIdx, Idx2: T2chThreadIndex;
	begin
		ThreadIdx := T2chThreadIndex.Create;

		try
			FindName := IncludeTrailingPathDelimiter(DirName) + '*.*';

			if FindFirst(FindName, faDirectory, FindData) <> 0 then
				Exit;

			try
				repeat
					if (FindData.Attr and faDirectory) <> 0 then
					begin
						if (FindData.Name <> '.') and (FindData.Name <> '..') then
						begin
							TmpDir := IncludeTrailingPathDelimiter(DirName) + FindData.Name;
							GetAllThread(IndexList, TmpDir);
						end;
					end else if ExtractFileExt(LowerCase(FindData.Name)) = '.idx' then
					begin
						try
							ThreadIdx.LoadFromFile(IncludeTrailingPathDelimiter(DirName) + FindData.Name);
						except
						end;

						StaticText1.Caption := ThreadIdx.BoardName + ' - ' + ThreadIdx.ThreadName;
						Application.ProcessMessages;
						if ModalResult <> mrNone then Exit;

						Idx2 := MasterIndex.LogPathOfObject(ThreadIdx.LogPath);
						if not Assigned(Idx2) then
						begin
							Idx2 := T2chThreadIndex.Create;
							Idx2.Assign(ThreadIdx);
						end;
						IndexList.Add(Idx2);
					end;
				until FindNext(FindData) <> 0;

			finally
				FindClose(FindData);
			end;
		finally
			ThreadIdx.Free;
		end;
	end;
begin
	Timer1.Enabled := False;
	DirList := nil;
	
	try
		DirList := TStringList.Create;

		GetLogFolder(DirList);
		if DirList.Count = 0 then
		begin
			ShowMessage('O܂łB');
			Exit;
		end;

    IndexList := T2chIndexList(AllThreadNode.Data);

		ProgressBar1.Max := DirList.Count;
		for I := 0 to DirList.Count - 1 do
		begin
			GetAllThread(IndexList, DirList[I]);
			ProgressBar1.StepIt;
			if ModalResult <> mrNone then Exit;
		end;

		StaticText1.Caption := '܂F' + IntToStr(IndexList.Count) + 'X';
		CancelBtn.Kind := bkOK;
	finally
		DirList.Free;
	end;
end;

end.

