unit FullTextSearchConfig;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, StdCtrls, Buttons, ExtCtrls, FavTypes;

type
  TFullTextSearchConfigDlg = class(TForm)
    Label1: TLabel;
    SearchTextEdit: TEdit;
    OptionGroupBox: TGroupBox;
    CaseInsensitiveCheckBox: TCheckBox;
    RegExpCheckBox: TCheckBox;
    TargetThreadRadioGroup: TRadioGroup;
    TargetRadioGroup: TRadioGroup;
    IgnoreSpaceCheckBox: TCheckBox;
    IgnoreTagCheckBox: TCheckBox;
    StartBtn: TBitBtn;
    CancelBtn: TBitBtn;
    procedure FormShow(Sender: TObject);
    procedure StartBtnClick(Sender: TObject);
  private
		{ Private 錾 }
		FConfig: TFullTextSearchConfig;
	public
		{ Public 錾 }
		class function Execute(AOwner: TComponent; Config: TFullTextSearchConfig): Boolean;
		property Config: TFullTextSearchConfig read FConfig write FConfig;
	end;

implementation

{$R *.dfm}

{ TFullTextSearchConfigDlg }

class function TFullTextSearchConfigDlg.Execute(AOwner: TComponent;
	Config: TFullTextSearchConfig): Boolean;
var
	FullTextSearchConfigDlg: TFullTextSearchConfigDlg;
begin
	FullTextSearchConfigDlg := TFullTextSearchConfigDlg.Create(AOwner);
	try
		FullTextSearchConfigDlg.Config := Config;
		Result := FullTextSearchConfigDlg.ShowModal = mrOk;
	finally
		FullTextSearchConfigDlg.Free;
	end;
end;

procedure TFullTextSearchConfigDlg.FormShow(Sender: TObject);
begin
	Assert(FConfig <> nil);

	{ ̐ݒ }
	SearchTextEdit.Text := FConfig.SearchText;

	{ IvV̐ݒ }
	CaseInsensitiveCheckBox.Checked := FConfig.CaseInsensitive;
	RegExpCheckBox.Checked := FConfig.UseRegularExpression;
	IgnoreSpaceCheckBox.Checked := FConfig.IgnoreSpace;
	IgnoreTagCheckBox.Checked := FConfig.IgnoreTag;

	{ ΏۃX̐ݒ }
	if FConfig.TargetThread = fttFixed then
	begin
		TargetThreadRadioGroup.ItemIndex := Ord(fttAll);
		TargetThreadRadioGroup.Enabled := False;
	end else
		TargetThreadRadioGroup.ItemIndex := Ord(FConfig.TargetThread);

	{ Ώۂ̐ݒ }
	TargetRadioGroup.ItemIndex := Ord(FConfig.Target);
end;

procedure TFullTextSearchConfigDlg.StartBtnClick(Sender: TObject);
begin
	Assert(FConfig <> nil);

	{ ̐ݒ }
	FConfig.SearchText := SearchTextEdit.Text;

	{ IvV̐ݒ }
	FConfig.CaseInsensitive := CaseInsensitiveCheckBox.Checked;
	FConfig.UseRegularExpression := RegExpCheckBox.Checked;
	FConfig.IgnoreSpace := IgnoreSpaceCheckBox.Checked;
	FConfig.IgnoreTag := IgnoreTagCheckBox.Checked;

	{ ΏۃX̐ݒ }
	FConfig.TargetThread := TFullTextSearchTargetThread(TargetThreadRadioGroup.ItemIndex);

	{ Ώۂ̐ݒ }
	if FConfig.TargetThread <> fttFixed then
		FConfig.Target := TFullTextSearchTarget(TargetRadioGroup.ItemIndex);
end;

end.

