unit KageChkDlg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, ExtCtrls;

type
	TKageLogCheckDlg = class(TForm)
    Label1: TLabel;
    ProgressBar: TProgressBar;
    BitBtn1: TBitBtn;
    Timer1: TTimer;
    PaintBox1: TPaintBox;
    procedure FormActivate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
		{ Private 錾 }
		ListView: TListView;
		procedure ShowMsg(const Msg: string);
  public
		{ Public 錾 }
		class function Execute(ListView: TListView): Boolean;
  end;

implementation

uses Katjusha;

{$R *.dfm}

{ TKageLogCheckDlg }

class function TKageLogCheckDlg.Execute(ListView: TListView): Boolean;
var
	Dlg: TKageLogCheckDlg;
begin
	Dlg := TKageLogCheckDlg.Create(Application.MainForm);
	try
		Dlg.ListView := ListView;
		Result := IsPositiveResult(Dlg.ShowModal);
	finally
		Dlg.Free;
	end;
end;

procedure TKageLogCheckDlg.FormActivate(Sender: TObject);
begin
	Timer1.Enabled := True;
end;

procedure TKageLogCheckDlg.ShowMsg(const Msg: string);
var
	Rect: TRect;
begin
	with PaintBox1 do
	begin
		Rect := ClientRect;
		Canvas.FillRect(Rect);
		DrawText(Canvas.Handle, PChar(Msg), Length(Msg), Rect, DT_SINGLELINE or DT_VCENTER or DT_WORD_ELLIPSIS or DT_LEFT);
	end;
end;

procedure TKageLogCheckDlg.Timer1Timer(Sender: TObject);
var
	I, Count: Integer;
	ThreadIdx: T2chThreadIndex;
	Msg: string;
{ GetLastMessage }
	function GetLastMessage(ThreadIdx: T2chThreadIndex): string;
	var
		FileName: TFileName;
		Stream: TFileStream;
		List: TStringList;
		Message: string;
	begin
		Stream := nil;
		List := nil;

		FileName := ChangeFileExt('log\' + ThreadIdx.LogPath, '.dat');

		try
			Stream := TFileStream.Create(FileName, fmOpenRead or fmShareDenyWrite);
			List := TStringList.Create;

			Stream.Seek(-1024, soFromEnd);
			List.LoadFromStream(Stream);

			Message := List[List.Count - 1];
			Result := Message;
		finally
			Stream.Free;
			List.Free;
		end;
	end;
begin
	Timer1.Enabled := False;
	Count := 0;
	
	ProgressBar.Max := ListView.Items.Count;

	for I := 0 to ListView.Items.Count - 1 do
	begin
		ThreadIdx := T2chThreadIndex(ListView.Items[I].Data);
		ShowMsg(ThreadIdx.ThreadName);
		Msg := GetLastMessage(ThreadIdx);
		if Pos('<b>Katjusha extender</b>,', Msg) = 1 then
		begin
			ListView.Items[I].Selected := True;
			Inc(Count);
		end else
			ListView.Items[I].Selected := False;
		ProgressBar.Position := I + 1;

		Application.ProcessMessages;
	end;

{	ModalResult := mrOk;}
	if Count > 0 then
		ShowMsg(Format('qɗX%d܂', [Count]))
	else
		ShowMsg('qɗX͌܂ł');

	BitBtn1.Kind := bkOk;
end;

end.

