unit ThArcDlg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, StdCtrls, Buttons, ExtCtrls, Katjusha, Mask, ToolEdit;

type
  TThreadArchiveDlg = class(TForm)
    BitBtn2: TBitBtn;
		BitBtn3: TBitBtn;
    CheckBox1: TCheckBox;
    Label1: TLabel;
    FilenameEdit: TFilenameEdit;
    DatOnlyCheckBox: TCheckBox;
    procedure BitBtn2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure DatOnlyCheckBoxClick(Sender: TObject);
  private
    { Private 錾 }
  public
		{ Public 錾 }
		ArchiveExt: string; { ɂ̊gq }
		DeleteLib: Boolean;	{ ɂ폜ǂ }
		IndexList: T2chIndexList;
	end;

var
	ThreadArchiveDlg: TThreadArchiveDlg;

implementation

uses FavUtils, Archives;

{$R *.dfm}

procedure TThreadArchiveDlg.BitBtn2Click(Sender: TObject);
var
	ListFile: TStringList;
	I, Ret: Integer;
	ArchiveFile: TArchiveFile;
begin
	Assert(Assigned(IndexList));
	
	ListFile := TStringList.Create;
	ArchiveFile := TArchiveFile.Create(nil);
	try
		if not DatOnlyCheckBox.Checked then
		begin
			{ Xbhqɂ݂邩ǂeXg }
			if not FileExists(TKatjusha.GetKatjushaBaseDir + IndexList.LibName + '.idx') then
			begin
				ShowMessage('Xbhq"' + IndexList.LibName + '"܂B' +
										#13#10'SĕۑsĂ蒼ĂB');
				Exit;
			end;
			ListFile.Add(IndexList.LibName + '.idx');
		end;

		for I := 0 to IndexList.Count - 1 do
		begin
			if not DatOnlyCheckBox.Checked then
				ListFile.Add('log\' + IndexList[I].LogPath);
			ListFile.Add('log\' + ChangeFileExt(IndexList[I].LogPath, '.dat'));
		end;

		ArchiveFile.FileName := FilenameEdit.FileName;
		ArchiveFile.Options.x := 1;
		ArchiveFile.Options.jso := 1;
		Ret := ArchiveFile.PackFiles(Handle, nil, TKatjusha.GetKatjushaBaseDir, [ListFile]);
		
		if CheckBox1.Checked then
			if Ret <> 0 then
				ShowMessage('qɂ̈kɃG[̂ō폜͍s܂B')
			else begin
				MoveToRecycleBin(ListFile);
				DeleteLib := True;
			end;
	finally
		ArchiveFile.Free;
		ListFile.Free;
	end;
end;

procedure TThreadArchiveDlg.FormShow(Sender: TObject);
begin
	Assert(Assigned(IndexList));
	FilenameEdit.InitialDir := TKatjusha.GetKatjushaBaseDir;
	FilenameEdit.FileName := '`Xbhq-' + IndexList.LibName + ArchiveExt;
	FilenameEdit.SetFocus;
	DeleteLib := False;
end;

procedure TThreadArchiveDlg.DatOnlyCheckBoxClick(Sender: TObject);
begin
	if DatOnlyCheckBox.Checked then
	begin
		CheckBox1.Checked := False;
		CheckBox1.Enabled := False;
	end else
		CheckBox1.Enabled := True;
end;

end.

