unit MacherieBoardView;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	ComCtrls, ExtCtrls, ImgList, Katjusha;

type
	TMacherieBoardViewFrame = class(TFrame)
    BoardTreeView: TTreeView;
    ImageList: TImageList;
    procedure BoardTreeViewExpanded(Sender: TObject; Node: TTreeNode);
    procedure BoardTreeViewCollapsed(Sender: TObject; Node: TTreeNode);
  private
		{ Private 錾 }
		FBoardList: TStringList;
    function GetSelectedBoard: string;
    procedure SetSelectedBoard(const Value: string);
    function GetSelectedBoardName: string;
		procedure SetBoardText(const AList: T2chBoard);
  public
		{ Public 錾 }
    constructor Create(AOwner: TComponent); override;
		destructor Destroy; override;
		procedure ClearBoard;
		property BoardText: T2chBoard write SetBoardText;
		property SelectedBoard: string read GetSelectedBoard write SetSelectedBoard;
		property SelectedBoardName: string read GetSelectedBoardName;
	end;

implementation

{$R *.dfm}

{ TMacherieBoardViewFrame }

procedure TMacherieBoardViewFrame.ClearBoard;
var
	List: TStringList;
	Node, Node2: TTreeNode;
	I: Integer;
begin
	List := TStringList.Create;
	try
		Node := BoardTreeView.Items.GetFirstNode;

		while Node <> nil do
		begin
			for I := 0 to Node.Count - 1 do
				if Node.Item[I].Data <> nil then
					List.Add(Format('%.3d', [Integer(Node.Item[I].Data) - 1]));
			Node2 := Node.GetNextSibling;
			Node.Delete;
			Node := Node2;
		end;

		List.Sort;
		for I := List.Count - 1 downto 0 do
			FBoardList.Delete(StrToInt(List[I]));
	finally
		List.Free;
	end;
end;

constructor TMacherieBoardViewFrame.Create(AOwner: TComponent);
begin
  inherited;
	FBoardList := TStringList.Create;
end;

destructor TMacherieBoardViewFrame.Destroy;
begin
	FBoardList.Free;
  inherited;
end;

procedure TMacherieBoardViewFrame.BoardTreeViewExpanded(Sender: TObject;
  Node: TTreeNode);
begin
	Node.ImageIndex := 2;
	Node.SelectedIndex := 2;
end;

procedure TMacherieBoardViewFrame.BoardTreeViewCollapsed(Sender: TObject;
  Node: TTreeNode);
begin
	Node.ImageIndex := 1;
	Node.SelectedIndex := 1;
end;

function TMacherieBoardViewFrame.GetSelectedBoard: string;
begin
	Result := '';

	with BoardTreeView do
	begin
		if Selected = nil then Exit;
		if Selected.Data = nil then Exit;
		if Integer(Selected.Data) <= 0 then Exit;
		
		Result := FBoardList[Integer(Selected.Data) - 1];
	end;
end;

procedure TMacherieBoardViewFrame.SetSelectedBoard(const Value: string);
begin

end;

function TMacherieBoardViewFrame.GetSelectedBoardName: string;
begin
	Result := '';

	with BoardTreeView do
	begin
		if Selected = nil then Exit;
		if Selected.Data = nil then Exit;

		Result := Selected.Text;
	end;
end;

procedure TMacherieBoardViewFrame.SetBoardText(const AList: T2chBoard);
var
	I, Count: Integer;
	Token: array [0 .. 1] of string;
	Root, Node: TTreeNode;
begin
	Root := nil;

	try
		BoardTreeView.Items.BeginUpdate;

		ClearBoard;

		for I := 0 to AList.Count - 1 do
		begin
			Count := StringSplit(AList[I], '<>', Token);
			if Count = 1 then
			begin
				Root := BoardTreeView.Items.AddChild(nil, 'y' + Token[0] + 'z');
				Root.ImageIndex := 1;
				Root.SelectedIndex := 1;
			end else begin
				Assert(Root <> nil);
				Node := BoardTreeView.Items.AddChild(Root, Token[1]);
				Node.Data := Pointer(FBoardList.Add(Token[0]) + 1);
				Node.ImageIndex := 3;
			end;
		end;
	finally
		BoardTreeView.Items.EndUpdate;
	end;
end;

end.

