unit ThFrame;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	ComCtrls, ImgList, Katjusha, FavUtils, FavTypes, Menus, StdActns, ActnList, StrUtils,
  TB2Item;

type
	TThreadListFrame = class(TFrame)
		ListView: TListView;
    ActionList: TActionList;
    EditCut: TEditCut;
    EditCopy: TEditCopy;
    EditPaste: TEditPaste;
    EditSelectAll: TEditSelectAll;
    EditUndo: TEditUndo;
    EditDelete: TEditDelete;
    EditInvSelect: TAction;
    EditSelServer: TAction;
    EditSelBoard: TAction;
    FileProperty: TAction;
    MenuImageList: TImageList;
    EditMemo: TAction;
    EditURLCopy: TAction;
    BrowserCallKatjusha: TAction;
    ImageList: TImageList;
    EditSelectNewRes: TAction;
    FileSelectBoard: TAction;
    BrowserCallStandard: TAction;
    EditMoveSelServer: TAction;
    EditDeleteLog: TAction;
    EditLogInfo: TAction;
    TBPopupMenu: TTBPopupMenu;
    K1: TTBItem;
    B1: TTBItem;
    N2: TTBSeparatorItem;
    Cut2: TTBItem;
    Copy2: TTBItem;
    Paste2: TTBItem;
    Delete1: TTBItem;
    G1: TTBItem;
    N5: TTBSeparatorItem;
    T1: TTBItem;
    N6: TTBSeparatorItem;
    E1: TTBItem;
    LevelMenu: TTBSubmenuItem;
    N31: TTBItem;
    N21: TTBItem;
    N11: TTBItem;
    N01: TTBItem;
    N12: TTBItem;
    N22: TTBItem;
    N32: TTBItem;
    N9: TTBSeparatorItem;
    Property1: TTBItem;
    URLCopySubmenuItem: TTBSubmenuItem;
    TBItem2: TTBItem;
    EditCopyTitleURL: TAction;
    TBItem1: TTBItem;
    procedure ListViewColumnClick(Sender: TObject; Column: TListColumn);
    procedure ListViewDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure ListViewCustomDrawItem(Sender: TCustomListView;
      Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
    procedure FilePropertyExecute(Sender: TObject);
    procedure EditCutExecute(Sender: TObject);
    procedure EditCopyExecute(Sender: TObject);
    procedure EditPasteExecute(Sender: TObject);
    procedure EditSelectAllExecute(Sender: TObject);
    procedure EditDeleteExecute(Sender: TObject);
    procedure EditInvSelectExecute(Sender: TObject);
    procedure EditSelServerExecute(Sender: TObject);
    procedure EditSelBoardExecute(Sender: TObject);
    procedure EditMemoExecute(Sender: TObject);
    procedure PopupMenuPopup(Sender: TObject);
    procedure EditURLCopyExecute(Sender: TObject);
    procedure ListViewMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BrowserCallKatjushaExecute(Sender: TObject);
    procedure ListViewDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure EditSelectNewResExecute(Sender: TObject);
    procedure BrowserCallStandardExecute(Sender: TObject);
    procedure ListViewDblClick(Sender: TObject);
    procedure EditLogInfoExecute(Sender: TObject);
    procedure EditCopyTitleURLExecute(Sender: TObject);
    procedure EditActionUpdate(Sender: TObject);
	private
		{ Private 錾 }
		FSelected: T2chIndexList;
		FClipBoard: T2chIndexList;
		FAlreadyGet, FAlreadyGetNoFav: T2chIndexList; { XXg }
		SortKey1, SortKey2: T2chThreadSortTypes;
		LineBrush: TBrush;
		FLineVisible: Boolean;
		FSelectedBoard: string;
		LineItem: TListItem;
		FThreadListParams: TThreadListParams;
		procedure DrawDragLine(ListItem: TListItem);
		procedure RefreshThreadView(IndexList: T2chIndexList; Clear: Boolean = True);
    procedure SetSelected(const Value: T2chIndexList);
    function GetSelectedIndex: T2chThreadIndex;
		procedure LevelMenuClick(Sender: TObject);
		procedure SetClipBoard(const Value: T2chIndexList);
		procedure FreeAlreadyGetList(MasterIdx, AlreadyGet: T2chIndexList);
    procedure SetThreadListParams(const Value: TThreadListParams);
    function GetSelCount: Integer;
    function GetMasterIndex: T2chIndexList;
	public
		{ Public 錾 }
    constructor Create(AOwner: TComponent); override;
		destructor Destroy; override;
		procedure Copy(ClipBoard: T2chIndexList);
		procedure Cut(ClipBoard: T2chIndexList);
		procedure Paste(ClipBoard: T2chIndexList);
		procedure Delete;
		procedure SelectBoard;
		procedure SelectServer;
		procedure SelectAll;
		function ShowProperty(Option: TKatfavIniFile): Boolean;
		procedure ReverseSelect;
		procedure RefreshView;
		procedure RefreshItem(ListItem: TListItem); overload;
		procedure RefreshItem(Index: T2chThreadIndex); overload;
		function AddThread(ThreadIdx: T2chThreadIndex): TListItem;
		procedure IniFileUpdate(IniFile: TKatfavIniFile; Direction: Boolean);
		procedure Sort(SortType: T2chThreadSortType);
		procedure CreateAlreadyGetList(const ServerName: string; Subject: T2chSubject);
		function CreateSelectedThreadList(IndexList: T2chIndexList): Integer;
		procedure SetThreadState(State: T2chThreadState);
		function GetSelectedIndexs(IndexList: T2chIndexList = nil): T2chIndexList;
		property SelectedIndex: T2chThreadIndex read GetSelectedIndex;
		property Selected: T2chIndexList read FSelected write SetSelected;
		property ClipBoard: T2chIndexList read FClipBoard write SetClipBoard;
		property SelectedBoard: string read FSelectedBoard;
		property MasterIndex: T2chIndexList read GetMasterIndex;
		property ThreadListParams: TThreadListParams read FThreadListParams write SetThreadListParams;
		property SelCount: Integer read GetSelCount;
  end;

implementation

uses AWKFunc, ThProp, MemoDlg, Clipbrd, CommCtrl, FavMain;

{$R *.dfm}

{IntSortCompare}
function IntSortCompare(Item1, Item2: Pointer): Integer;
begin
	Result := 0;

	if Integer(Item1) < Integer(Item2) then
		Result := -1
	else if Integer(Item1) > Integer(Item2) then
		Result := 1;
end;

procedure TThreadListFrame.Copy(ClipBoard: T2chIndexList);
var
	ThreadIdx: T2chThreadIndex;
	Item: TListItem;
begin
	with ListView do
	begin
		if Selected = nil then Exit;
		Item := Selected;
		repeat
			ThreadIdx := T2chThreadIndex(Item.Data);
			ClipBoard.Add(ThreadIdx);
			Item := GetNextItem(Item, sdAll, [isSelected]);
		until Item = nil;
	end;
end;

procedure TThreadListFrame.Cut(ClipBoard: T2chIndexList);
var
	I: Integer;
	ThreadIdx: T2chThreadIndex;
	Item: TListItem;
	DelList: TList;
begin
	DelList := nil;

	try
		DelList := TList.Create;

		with ListView do
		begin
			if Selected = nil then Exit;
			Item := Selected;
			repeat
				ThreadIdx := T2chThreadIndex(FSelected.Extract(T2chThreadIndex(Item.Data)));
				ClipBoard.Add(ThreadIdx);
				DelList.Add(Pointer(Item.Index));
				Item := GetNextItem(Item, sdAll, [isSelected]);
			until Item = nil;

			DelList.Sort(IntSortCompare);
			for I := DelList.Count - 1 downto 0 do
				ListView.Items.Delete(Integer(DelList[I]));
		end;
	finally
		DelList.Free;
	end;
end;

procedure TThreadListFrame.Delete;
var
	Item: TListItem;
	Index: Integer;
begin
	with ListView do
	begin
		if Selected = nil then Exit;

		Item := Selected;

		repeat
			FSelected.Remove(T2chThreadIndex(Item.Data));
			Index := Item.Index;
			Item := GetNextItem(Item, sdAll, [isSelected]);
			Items.Delete(Index);
		until Item = nil;
	end;
end;

procedure TThreadListFrame.Paste(ClipBoard: T2chIndexList);
var
	I: Integer;
begin
	if ClipBoard = FSelected then Exit;

	for I := 0 to ClipBoard.Count - 1 do
	begin
		FSelected.Add(ClipBoard[I]);
	end;

	RefreshThreadView(FSelected);
end;

procedure TThreadListFrame.RefreshThreadView(IndexList: T2chIndexList; Clear: Boolean);
var
	I: Integer;
	ThreadIdx: T2chThreadIndex;
	ProgressBar: TProgressBar;
begin
	ProgressBar := (Owner as TKatfavMainForm).ListProgressBar;
	ProgressBar.Position := 0;
	ProgressBar.Step := 1;
	
	if Clear then
	begin
		ListView.Items.BeginUpdate;
		ListView.Items.Clear;

		try
			ListView.AllocBy := IndexList.Count;
			ProgressBar.Max := IndexList.Count;

			for I := 0 to IndexList.Count - 1 do
			begin
				ThreadIdx := IndexList[I];
				ThreadIdx.AssignTo(ListView.Items.Add);
				ProgressBar.StepIt;
				ProgressBar.Update;
			end;
		finally
			ListView.Items.EndUpdate;
		end;
	end else begin
		ListView.Items.BeginUpdate;
		try
			ProgressBar.Max := IndexList.Count;

			for I := 0 to IndexList.Count - 1 do
			begin
				ThreadIdx := IndexList[I];
				ThreadIdx.AssignTo(ListView.Items[I]);
				ProgressBar.StepIt;
				ProgressBar.Update;
			end;
		finally
			ListView.Items.EndUpdate;
		end;
	end;
end;

procedure TThreadListFrame.ReverseSelect;
var
	I: Integer;
begin
	with ListView do
	begin
		for I := 0 to Items.Count - 1 do
			Items[I].Selected := not Items[I].Selected;

		SetFocus;
	end;
end;

procedure TThreadListFrame.SelectAll;
begin
	ListView.SetFocus;
	ListView.SelectAll;
end;

procedure TThreadListFrame.SelectBoard;
var
	BoardName: string;
	I: Integer;
	ThreadIdx: T2chThreadIndex;
begin
	if ListView.Selected = nil then Exit;
	BoardName := T2chThreadIndex(ListView.Selected.Data).BoardName;
	for I := 0 to ListView.Items.Count - 1 do
	begin
		ThreadIdx := T2chThreadIndex(ListView.Items[I].Data);
		if BoardName = ThreadIdx.BoardName then
			ListView.Items[I].Selected := True
		else
			ListView.Items[I].Selected := False;
	end;
end;

procedure TThreadListFrame.SelectServer;
var
	ServerName: string;
	I: Integer;
	ThreadIdx: T2chThreadIndex;
begin
	if ListView.Selected = nil then Exit;
	ServerName := T2chThreadIndex(ListView.Selected.Data).ServerName;
	for I := 0 to ListView.Items.Count - 1 do
	begin
		ThreadIdx := T2chThreadIndex(ListView.Items[I].Data);
		if ServerName = ThreadIdx.ServerName then
			ListView.Items[I].Selected := True
		else
			ListView.Items[I].Selected := False;
	end;
end;

procedure TThreadListFrame.SetSelected(const Value: T2chIndexList);
begin
	if FSelected <> Value then
	begin
		SortKey1 := [];
		Sortkey2 := [];

		if Value <> FAlreadyGet then
			FSelectedBoard := '';

		if Value = nil then
		begin
			ListView.Clear;
			FreeAlreadyGetList(MasterIndex, FAlreadyGetNoFav);
			FAlreadyGet.Clear;
		end else
			RefreshThreadView(Value);
	end;
	
	FSelected := Value;
	FileSelectBoard.Execute;
end;

function TThreadListFrame.ShowProperty(Option: TKatfavIniFile): Boolean;
begin
	Result := False;
	if ListView.Selected <> nil then
		Result := TThreadPropertyForm.Execute(Application.MainForm, T2chThreadIndex(ListView.Selected.Data));
end;

procedure TThreadListFrame.ListViewColumnClick(Sender: TObject;
  Column: TListColumn);
const
	SortType: array [0 .. 19] of T2chThreadSortType =
			(tsTitle, tsGravity, tsBeforeResCount, tsResCount, tsNewResCount, tsDateTime, tsNone, tsBoardName, tsMemo, tsDepth,
			 tsThreadNum, tsNone, tsNone, tsNone, tsResDiff, tsNone, tsNone, tsNone, tsNone, tsNone);
var
	Shift: Boolean;
	Index: Integer;
begin
	Index := Column.Index;
	Shift := GetAsyncKeyState(VK_SHIFT) <> 0;

	if Shift then Inc(Index, 10);

	if SortType[Index] = tsNone then
		Exit;

	if SortType[Index] in SortKey1 then
	begin
		if tsAsc in SortKey1 then
			SortKey1 := SortKey1 - [tsAsc] + [tsDec]
		else
			SortKey1 := SortKey1 - [tsDec] + [tsAsc];
	end else if ((tsThreadNum in SortKey1) and (Index = 0)) or ((tsTitle in SortKey1) and (Index = 9)) then
	begin
		SortKey1 := [SortType[Index], tsAsc];
	end else begin
		SortKey2 := SortKey1;
		SortKey1 := [SortType[Index], tsAsc];
	end;
	FSelected.BoardSort(SortKey1, SortKey2);
	RefreshThreadView(FSelected, False);
end;

procedure TThreadListFrame.ListViewDragOver(Sender, Source: TObject; X,
	Y: Integer; State: TDragState; var Accept: Boolean);
begin
	Accept := Source is TListView;

	FLineVisible := False;
	LineItem := ListView.GetItemAt(X, Y);
	if LineItem = nil then Exit;
	FLineVisible := True;
end;

procedure TThreadListFrame.ListViewCustomDrawItem(Sender: TCustomListView;
	Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
var
	Rect: TRect;
	BkColor: TColor;
begin
	Rect := Item.DisplayRect(drBounds);
	Rect.Right := ListView.ClientWidth;

	if (ListView.Items.IndexOf(Item) mod 2) = 0 then
		BkColor := $E7EFEF
	else
		BkColor := clWindow;

	with ListView.Canvas do
	begin
		Brush.Color := clBlack;	{Ȃ[Aʂ̐Fɐݒ肷Ƃ܂}
		Brush.Color := BkColor;
		FillRect(Rect);

		if FLineVisible and (LineItem = Item) then
			DrawDragLine(LineItem);

		Brush.Color := BkColor;
	end;
end;

procedure TThreadListFrame.IniFileUpdate(IniFile: TKatfavIniFile; Direction: Boolean);
var
	I: Integer;
begin
	if Direction then
	begin
		for I := 0 to ListView.Columns.Count - 1 do
			ListView.Column[I].Width := FThreadListParams.ColumnWidth[I];
		case ThreadListParams.URLCopyAction of
			ucURLWithTitle: URLCopySubmenuItem.Action := EditCopyTitleURL;
			ucURLOnly: URLCopySubmenuItem.Action := EditURLCopy;
		end;
	end else begin
		FThreadListParams.ColumnCount := ListView.Columns.Count;
		for I := 0 to ListView.Columns.Count - 1 do
			FThreadListParams.ColumnWidth[I] := ListView.Column[I].Width;
		if URLCopySubmenuItem.Action = EditURLCopy
			then ThreadListParams.URLCopyAction := ucURLOnly
			else ThreadListParams.URLCopyAction := ucURLWithTitle;
	end;
end;

procedure TThreadListFrame.RefreshView;
begin
	RefreshThreadView(FSelected);
end;

function TThreadListFrame.GetSelectedIndex: T2chThreadIndex;
begin
	Result := nil;
	if ListView.Selected <> nil then
		Result := T2chThreadIndex(ListView.Selected.Data);
end;

procedure TThreadListFrame.FilePropertyExecute(Sender: TObject);
begin
//	ShowProperty;
end;

procedure TThreadListFrame.EditCutExecute(Sender: TObject);
begin
	FClipBoard.Clear;
	Cut(FClipBoard);
end;

procedure TThreadListFrame.EditCopyExecute(Sender: TObject);
begin
	FClipBoard.Clear;
	Copy(FClipBoard);
end;

procedure TThreadListFrame.EditPasteExecute(Sender: TObject);
begin
	Paste(FClipBoard);
end;

procedure TThreadListFrame.EditSelectAllExecute(Sender: TObject);
begin
	SelectAll;
end;

procedure TThreadListFrame.EditDeleteExecute(Sender: TObject);
begin
	Delete;
end;

procedure TThreadListFrame.EditInvSelectExecute(Sender: TObject);
begin
	ReverseSelect;
end;

procedure TThreadListFrame.EditSelServerExecute(Sender: TObject);
begin
	SelectServer;
end;

procedure TThreadListFrame.EditSelBoardExecute(Sender: TObject);
begin
	SelectBoard;
end;

constructor TThreadListFrame.Create(AOwner: TComponent);
var
	I: Integer;
begin
  inherited;

	{ Xbh̃vpeBAlt+Enterɐݒ肷 }
	FileProperty.ShortCut := ShortCut(VK_RETURN, [ssAlt]);

	{ dvxj[̐ݒ }
	for I := 0 to LevelMenu.Count - 1 do
	begin
		LevelMenu[I].Tag := I;
		LevelMenu[I].OnClick := LevelMenuClick;
	end;

	LineBrush := TBrush.Create;
	LineBrush.Bitmap := AllocPatternBitmap(clBlack, clWhite);

	{ XXg̍쐬 }
	FAlreadyGet := T2chIndexList.Create;
	FAlreadyGetNoFav := T2chIndexList.Create(True);

	{ p[^ǗNX̍쐬 }
	FThreadListParams := TThreadListParams.Create;
end;

function TThreadListFrame.AddThread(ThreadIdx: T2chThreadIndex): TListItem;
begin
	Result := nil;

	if FSelected = nil then Exit;
	if FSelected.Add(ThreadIdx) = -1 then Exit;
	Result := ListView.Items.Add;
	Result.Assign(ThreadIdx);
end;

procedure TThreadListFrame.EditMemoExecute(Sender: TObject);
var
	MemoList: TStringList;
	Memo: string;
	Item: TListItem;
begin
	MemoList := TStringList.Create;
	MemoList.Sorted := True;
	MemoList.Duplicates := dupIgnore;

	try
		with ListView do
		begin
			if Selected = nil then Exit;
			Item := Selected;
			repeat
				MemoList.Add(T2chThreadIndex(Item.Data).Memo);
				Item := GetNextItem(Item, sdAll, [isSelected]);
			until Item = nil;
		end;

    Memo := SelectedIndex.Memo;
		if TMemoEditDlg.Execute(Memo, MemoList) then
		begin
			Item := ListView.Selected;
			repeat
				T2chThreadIndex(Item.Data).Memo := Memo;
				Item.Assign(T2chThreadIndex(Item.Data));
				Item := ListView.GetNextItem(Item, sdAll, [isSelected]);
			until Item = nil;
		end;
	finally
		MemoList.Free;
	end;
end;

procedure TThreadListFrame.LevelMenuClick(Sender: TObject);
var
	ThreadIdx: T2chThreadIndex;
	Item: TListItem;
	Level: Integer;
begin
	Level := 8 - (Sender as TTBItem).Tag;
	with ListView do
	begin
		if Selected = nil then Exit;
		Item := Selected;
		repeat
			ThreadIdx := T2chThreadIndex(Item.Data);
			ThreadIdx.Gravity := Level;
			ThreadIdx.AssignTo(Item);
			Item := GetNextItem(Item, sdAll, [isSelected]);
		until Item = nil;
	end;
end;

procedure TThreadListFrame.PopupMenuPopup(Sender: TObject);
var
	ThreadIdx: T2chThreadIndex;
begin
	ThreadIdx := SelectedIndex;

	{ dvxj[̐ݒ }
	if ThreadIdx <> nil then
		LevelMenu[8 - ThreadIdx.Gravity].Checked := True;
end;

procedure TThreadListFrame.Sort(SortType: T2chThreadSortType);
begin
	if SortType in SortKey1 then
	begin
		if tsAsc in SortKey1 then
			SortKey1 := SortKey1 - [tsAsc] + [tsDec]
		else
			SortKey1 := SortKey1 - [tsDec] + [tsAsc];
	end else begin
		SortKey2 := SortKey1;
		SortKey1 := [SortType, tsAsc];
	end;
	FSelected.BoardSort(SortKey1, SortKey2);
	RefreshThreadView(FSelected, False);
end;

procedure TThreadListFrame.SetClipBoard(const Value: T2chIndexList);
var
	Enabled: Boolean;
begin
	FClipBoard := Value;

	Enabled := Assigned(FClipBoard);
	
	EditCut.Enabled := Enabled;
	EditCopy.Enabled := Enabled;
	EditPaste.Enabled := Enabled;
end;

procedure TThreadListFrame.EditURLCopyExecute(Sender: TObject);
var
	ThreadIdx: T2chThreadIndex;
	Item: TListItem;
	URL: string;
	Count: Integer;
begin
	Count := 0;

	with ListView do
	begin
		if Selected = nil then Exit;
		Item := Selected;
		repeat
			ThreadIdx := T2chThreadIndex(Item.Data);
			if Length(URL) > 0 then URL := URL + #13#10;
			URL := URL + ThreadIdx.URL;
			Inc(Count);
			Item := GetNextItem(Item, sdAll, [isSelected]);
		until Item = nil;
	end;

	if Count > 1 then
		URL := URL + #13#10;

	if URL <> '' then
		Clipbrd.Clipboard.AsText := URL;

	URLCopySubmenuItem.Action := EditURLCopy;
end;

procedure TThreadListFrame.ListViewMouseUp(Sender: TObject;
	Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	if Button = mbMiddle then
		BrowserCallKatjusha.Execute;
end;

procedure TThreadListFrame.BrowserCallKatjushaExecute(Sender: TObject);
var
	ThreadIdx: T2chThreadIndex;
	Item: TListItem;
begin
	with ListView do
	begin
		if Selected = nil then Exit;
		Item := Selected;
		repeat
			ThreadIdx := T2chThreadIndex(Item.Data);

			if ThreadIdx.ResState = rsNew then
			begin
				if ThreadIdx.BeforeResCount > ThreadIdx.ResCount then
					ThreadIdx.ResCount := ThreadIdx.BeforeResCount;
				{ UCKZbgVX̃[Zbg }
				if ThreadIdx.NewResCount = 0 then
					ThreadIdx.NewResCount := -1;
				ThreadIdx.ResState := rsNone;
				Item.Assign(ThreadIdx);
			end;

			CallKatjusha(ThreadIdx.URL);

			Item := GetNextItem(Item, sdAll, [isSelected]);
		until Item = nil;
	end;
end;

procedure TThreadListFrame.DrawDragLine(ListItem: TListItem);
var
	Rc: TRect;
	OldBrush: TBrush;
begin
	with ListView.Canvas do
	begin
		OldBrush := Brush;
		Brush := LineBrush;
		Refresh;
		Rc := ListItem.DisplayRect(drBounds);
		PatBlt(Handle, Rc.Left, Rc.Top, 100, 3, PATINVERT);
		Brush := OldBrush;
	end;
end;

procedure TThreadListFrame.ListViewDragDrop(Sender, Source: TObject; X,
	Y: Integer);
var
	Item, ListItem: TListItem;
	InsIndex: Integer;
begin
	if FLineVisible then
	begin
		FLineVisible := False;
		DrawDragLine(LineItem);
		LineItem := nil;
	end;

	ListItem := ListView.GetItemAt(X, Y);
	if ListItem = nil then Exit;


	InsIndex := ListItem.Index;
	with ListView do
	begin
		if Selected = nil then Exit;
		Item := Selected;
		repeat
			FSelected.Extract(T2chThreadIndex(Item.Data));
			if Item.Index < InsIndex then
				Dec(InsIndex);
			FSelected.Insert(InsIndex, TObject(Item.Data));
			Inc(InsIndex);
			Item := GetNextItem(Item, sdAll, [isSelected]);
		until Item = nil;
	end;
	RefreshThreadView(FSelected, False);
end;

destructor TThreadListFrame.Destroy;
begin
	FreeAlreadyGetList(MasterIndex, FAlreadyGetNoFav);
	FAlreadyGetNoFav.Free;
	FAlreadyGet.Free;
	LineBrush.Free;
	FThreadListParams.Free;
	
  inherited;
end;

procedure TThreadListFrame.EditSelectNewResExecute(Sender: TObject);
var
	Item: TListItem;
	I: Integer;
begin
	with ListView do
		if ListView.SelCount > 1 then
		begin
			{ łɕIĂꍇ́A̒I }
			Item := Selected;
			repeat
				if T2chThreadIndex(Item.Data).ResState <> rsNew then
					Item.Selected := False;
				Item := GetNextItem(Item, sdAll, [isSelected]);
			until Item = nil;
		end else
		begin
			for I := 0 to Items.Count - 1 do
				Items[I].Selected := (T2chThreadIndex(Items[I].Data).ResState = rsNew);
		end;
end;

procedure TThreadListFrame.RefreshItem(ListItem: TListItem);
begin
	ListItem.Assign(T2chThreadIndex(ListItem.Data));
end;

procedure TThreadListFrame.RefreshItem(Index: T2chThreadIndex);
var
	I: Integer;
begin
	with ListView do
		for I := 0 to Items.Count - 1 do
		begin
			if T2chThreadIndex(Items[I].Data) = Index then
			begin
				Items[I].Assign(Index);
				Break;
			end;
		end;
end;

procedure TThreadListFrame.CreateAlreadyGetList(const ServerName: string; Subject: T2chSubject);
var
	ThreadIdx: T2chThreadIndex;
	FindName, LogPath, BoardPath: string;
	FindData: TSearchRec;
{ SetSubjectData }
	procedure SetSubjectData;
	var
		Index: Integer;
	begin
		if Subject <> nil then
		begin
			Index := Subject.IndexOf(ThreadIdx.ThreadNum);
			if Index >= 0 then
			begin
				if ThreadIdx.BeforeResCount < Subject.ResCount[Index] then
					ThreadIdx.BeforeResCount := Subject.ResCount[Index];
				if ThreadIdx.DatPath <> 'jbbs.shitaraba.com' then
					ThreadIdx.Depth := Subject.Depth[Index];
				if ThreadIdx.BeforeResCount > ThreadIdx.ResCount then
					ThreadIdx.ResState := rsNew;
			end;
		end;
	end;
begin
	BoardPath := ExtractUrlName(ServerName);
	LogPath := URLToPath(ExcludeTrailingSlash(ExtractUrlPath(ServerName))) +
						 '\' + BoardPath;

	FreeAlreadyGetList(MasterIndex, FAlreadyGetNoFav);
	FAlreadyGet.Clear;
	FSelectedBoard := ServerName;

	FindName := TKatjusha.GetKatjushaBaseDir + 'log\' + LogPath + '\*.*';

	if FindFirst(FindName, 0, FindData) <> 0 then
	begin
		Selected := nil;
		Exit;
	end;

	try
		repeat
			if ((FindData.Attr and faDirectory) = 0) and
					(ExtractFileExt(LowerCase(FindData.Name)) = '.idx') then
			begin
				ThreadIdx := MasterIndex.LogPathOfObject(IncludeTrailingPathDelimiter(LogPath) + FindData.Name);
				if ThreadIdx <> nil then
				begin
					SetSubjectData;
					FAlreadyGet.Add(ThreadIdx);
				end else if ThreadListParams.AlreadyGetFull then { XSĕ\L̏ꍇ }
				begin
					ThreadIdx := T2chThreadIndex.Create;
					ThreadIdx.LoadFromFile(TKatjusha.GetKatjushaBaseDir + 'log\' + IncludeTrailingPathDelimiter(LogPath) + FindData.Name);
					SetSubjectData;
					FAlreadyGetNoFav.Add(ThreadIdx);
					FAlreadyGet.Add(ThreadIdx);
				end;
			end;
		until FindNext(FindData) <> 0;

	finally
		FindClose(FindData);
	end;
	
	{ Xbh̐VAVŃ\[g }
	FAlreadyGet.BoardSort([tsThreadNum, tsDec], []);
	FAlreadyGet.BoardSort([tsCheckRes, tsAsc], []);
	FAlreadyGet.LibName := ServerName;
	FAlreadyGet.DisplayName := ServerName;
	if Selected = FAlreadyGet then
		RefreshThreadView(FAlreadyGet, True);
	Selected := FAlreadyGet;
end;

procedure TThreadListFrame.BrowserCallStandardExecute(Sender: TObject);
var
	ThreadIdx: T2chThreadIndex;
	Item: TListItem;
	Postfix: string;
begin
	with ListView do
	begin
		if Selected = nil then Exit;
		Item := Selected;
		repeat
			ThreadIdx := T2chThreadIndex(Item.Data);
			case ThreadListParams.BrowserType of
				btLast50: Postfix := ThreadIdx.GetLastPrefix(50);
				btNewRes: begin
					if ThreadIdx.NewResCount <= 0
						then Postfix := ThreadIdx.GetResStartPrefix(ThreadIdx.ResCount)
						else Postfix := ThreadIdx.GetResStartPrefix(ThreadIdx.ResCount - ThreadIdx.NewResCount);
				end;
			end;

			CallBrowser(ThreadIdx.URL + Postfix);

			Item := GetNextItem(Item, sdAll, [isSelected]);
		until Item = nil;
	end;
end;

procedure TThreadListFrame.ListViewDblClick(Sender: TObject);
begin
	if SelectedIndex = nil then Exit;
	
	case FThreadListParams.DblClickAction of
		daKatjusha: BrowserCallKatjusha.Execute;
		daBrowser: BrowserCallStandard.Execute;
	end;
end;

function TThreadListFrame.CreateSelectedThreadList(
	IndexList: T2chIndexList): Integer;
var
	ThreadIdx: T2chThreadIndex;
	Item: TListItem;
begin
	Result := -1;
	with ListView do
	begin
		if Selected = nil then Exit;
		Item := Selected;
		repeat
			ThreadIdx := T2chThreadIndex(Item.Data);
			IndexList.Add(ThreadIdx);
			Item := GetNextItem(Item, sdAll, [isSelected]);
		until Item = nil;
	end;

	Result := IndexList.Count;
end;

procedure TThreadListFrame.FreeAlreadyGetList(MasterIdx,
  AlreadyGet: T2chIndexList);
var
	I: Integer;
begin
	for I := AlreadyGet.Count - 1 downto 0 do
	begin
		if MasterIdx.IndexOf(AlreadyGet[I]) >= 0 then
			AlreadyGet.Extract(AlreadyGet[I]);
	end;
	AlreadyGet.Clear;
end;

procedure TThreadListFrame.EditLogInfoExecute(Sender: TObject);
var
	ThreadIdx: T2chThreadIndex;
	Item: TListItem;
	Text: string;
begin
	with ListView do
	begin
		if Selected = nil then Exit;
		Item := Selected;
		repeat
			ThreadIdx := T2chThreadIndex(Item.Data);
			{ Xbhԍ 擾t ^Cg }
			Text := Text + CurrToStr(ThreadIdx.ThreadNum) + ' ' +
							DateTimeToStr(ThreadIdx.DateTime) + ' ' + ThreadIdx.ThreadName + #13#10;
			Item := GetNextItem(Item, sdAll, [isSelected]);
		until Item = nil;
	end;

	if Text <> '' then
		Clipbrd.Clipboard.AsText := Text;
end;

procedure TThreadListFrame.SetThreadListParams(
	const Value: TThreadListParams);
var
	ShowDepth: Boolean;
	Column: TListColumn;
begin
	FThreadListParams.Assign(Value);

	ShowDepth := (ListView.Column[ListView.Columns.Count - 1].Caption = '[x');
	if FThreadListParams.UseDepth and not ShowDepth then
	begin
		Column := ListView.Columns.Add;
		Column.AutoSize := false;
		Column.Caption := '[x';
		Column.Alignment := taRightJustify;

		if ListView.Columns.Count = FThreadListParams.ColumnCount
			then Column.Width := FThreadListParams.ColumnWidth[ListView.Columns.Count - 1]
			else Column.Width := ColumnHeaderWidth;
	end else if (not FThreadListParams.UseDepth) and ShowDepth then
	begin
		FThreadListParams.ColumnCount := ListView.Columns.Count;
		FThreadListParams.ColumnWidth[ListView.Columns.Count - 1] := ListView.Column[ListView.Columns.Count - 1].Width;
		ListView.Columns.Delete(ListView.Columns.Count - 1);
	end;
end;

procedure TThreadListFrame.SetThreadState(State: T2chThreadState);
var
	ThreadIdx: T2chThreadIndex;
	Item: TListItem;
begin
	with ListView do
	begin
		if Selected = nil then Exit;
		Item := Selected;
		repeat
			ThreadIdx := T2chThreadIndex(Item.Data);
			if State in ThreadIdx.State
				then ThreadIdx.State := ThreadIdx.State - [State]
				else ThreadIdx.State := ThreadIdx.State + [State];
			Item := GetNextItem(Item, sdAll, [isSelected]);
		until Item = nil;
	end;
end;

function TThreadListFrame.GetSelCount: Integer;
begin
	Result := ListView.SelCount;
end;

function TThreadListFrame.GetMasterIndex: T2chIndexList;
var
	MainForm: TKatfavMainForm;
begin
	MainForm := Owner as TKatfavMainForm;
	Result := MainForm.MasterIndex;
end;

function TThreadListFrame.GetSelectedIndexs(
	IndexList: T2chIndexList): T2chIndexList;
var
	ThreadIdx: T2chThreadIndex;
	Item: TListItem;
begin
	Result := nil;
	with ListView do
	begin
		if Selected = nil then Exit;

		if IndexList = nil
			then Result := T2chIndexList.Create
			else Result := IndexList;

		Item := Selected;
		repeat
			ThreadIdx := T2chThreadIndex(Item.Data);
			Result.Add(ThreadIdx);
			Item := GetNextItem(Item, sdAll, [isSelected]);
		until Item = nil;
	end;
end;

procedure TThreadListFrame.EditCopyTitleURLExecute(Sender: TObject);
var
	ThreadIdx: T2chThreadIndex;
	Item: TListItem;
	URL: string;
begin
	with ListView do
	begin
		if Selected = nil then Exit;
		Item := Selected;
		repeat
			ThreadIdx := T2chThreadIndex(Item.Data);
			URL := URL + ThreadIdx.ThreadName + #13#10;
			URL := URL + ThreadIdx.URL + #13#10;
			Item := GetNextItem(Item, sdAll, [isSelected]);
		until Item = nil;
	end;

	if URL <> '' then
		Clipbrd.Clipboard.AsText := URL;

	URLCopySubmenuItem.Action := EditCopyTitleURL;
end;

procedure TThreadListFrame.EditActionUpdate(Sender: TObject);
begin
	Exit;
end;

end.

