unit ThreadList;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, NewThreadView, Katjusha, StrUtils, ComCtrls, Menus;

type
  TThreadListForm = class(TForm)
    NewThreadView: TNewThreadViewFrame;
    StatusBar: TStatusBar;
    procedure NewThreadViewCloseButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
		FBoardPath: string;
		procedure SetBoardPath(const Value: string);
		{ Private 錾 }
  public
		{ Public 錾 }
		property BoardPath: string read FBoardPath write SetBoardPath;
	end;

{var
  ThreadListForm: TThreadListForm;}

implementation

uses FavUtils, FavMain;

{$R *.dfm}

procedure TThreadListForm.NewThreadViewCloseButtonClick(Sender: TObject);
begin
	Close;
end;

procedure TThreadListForm.SetBoardPath(const Value: string);
var
	URL, FileName: string;
	Subject: T2chSubject;
begin
	Subject := nil;

	try
		Subject := T2chSubject.Create;

		URL := 'http://' + Value + '/subject.txt';
		FileName := TKatjusha.GetKatjushaBaseDir + 'subject\' + URLToPath(Value) + '.txt';

		try
			Subject.LoadFromFile(FileName);
		except
			on E: EFOpenError do
			begin
				StatusBar.SimpleText := E.Message;
				Exit;
			end;
		end;

		NewThreadView.CreateList(Value, Subject);
		if Subject.ContentDate <> -1 then
			StatusBar.SimpleText := DateTimeToStr(Subject.ContentDate) + 'Ɏ擾ꗗłB';
		NewThreadView.RefreshColumn;
	finally
		Subject.Free;
	end;

	FBoardPath := Value;
end;

procedure TThreadListForm.FormCreate(Sender: TObject);
begin
	(Application.MainForm as TKatfavMainForm).AddSubForm(Self);
end;

procedure TThreadListForm.FormDestroy(Sender: TObject);
begin
	(Application.MainForm as TKatfavMainForm).RemoveSubForm(Self);
end;

procedure TThreadListForm.FormClose(Sender: TObject;
	var Action: TCloseAction);
begin
	{ EBhEƃ }
	Action := caFree;
end;

end.

