unit ThreadView;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	ComCtrls, OleCtrls, SHDocVw, ExtCtrls, Katjusha, StdCtrls, StrUtils,
  Buttons;

type
	TThreadViewFrame = class(TFrame)
		BottomPanel: TPanel;
		Browser: TWebBrowser;
    TrackBar: TTrackBar;
    TopPanel: TPanel;
    NumText: TStaticText;
    DateText: TStaticText;
    FromImage: TImage;
    TopBtn: TSpeedButton;
    PrevBtn: TSpeedButton;
    NextBtn: TSpeedButton;
    BottomBtn: TSpeedButton;
    procedure TrackBarChange(Sender: TObject);
    procedure TopBtnClick(Sender: TObject);
    procedure PrevBtnClick(Sender: TObject);
    procedure NextBtnClick(Sender: TObject);
    procedure BottomBtnClick(Sender: TObject);
    procedure FrameResize(Sender: TObject);
	private
		{ Private 錾 }
		Initialized: Boolean;
		MsgList: TStringList;
		FromText: string;
		procedure RefreshView(Index: Integer);
		procedure DrawFrom(const From: string);
	public
		{ Public 錾 }
		constructor Create(AOwner: TComponent); override;
		destructor Destroy; override;
		procedure FrameCreate(Sender: TObject);		{ p }
		procedure LoadDatFile(ThreadIdx: T2chThreadIndex);
	end;

var
	BodyStyle: string = 'font-size: x-small; font-family: "lr oSVbN";';
	
implementation

uses AWKFunc;

{$R *.dfm}

{ TThreadViewFrame }

constructor TThreadViewFrame.Create(AOwner: TComponent);
begin
	inherited;
	Initialized := False;
	MsgList := TStringList.Create;
	FrameCreate(Self);
end;

destructor TThreadViewFrame.Destroy;
begin
	FreeAndNil(MsgList);
	inherited;
end;

procedure TThreadViewFrame.DrawFrom(const From: string);
var
	Text, SubText: string;
	Pos: Integer;
	Bold: Boolean;
	Bitmap: TBitmap;
	BmpRect: TRect;
	List: TStringList;
begin
	Text := From;

	Bitmap := TBitmap.Create;
	List := TStringList.Create;
	try
		Bitmap.Height := FromImage.ClientHeight;
		Bitmap.Width := FromImage.ClientWidth;

		BmpRect := Rect(0, 0, Bitmap.Width, Bitmap.Height);
		with Bitmap.Canvas do
		begin
			Brush.Color := clBtnFace;
			FillRect(BmpRect);
			DrawEdge(Handle, BmpRect, BDR_SUNKENOUTER, BF_ADJUST or BF_RECT);
		end;
		Pos := BmpRect.Left;
		
		while Text <> '' do
		begin
			List.Clear;
			if AWKMatch('^([^<]+)<[Bb]>', Text, List) >= 0 then
			begin
				SubText := List[1];
				Text := Copy(Text, Length(List[1]) + 1, Length(Text) - Length(List[1]));
				Bold := False;
			end else
			if AWKMatch('^<[Bb]>([^<]*)</[Bb]>', Text, List) >= 0 then
			begin
				SubText := List[1];
				Text := Copy(Text, Length(List[0]) + 1, Length(Text) - Length(List[0]));
				Bold := True;
			end else
			begin
				SubText := Text;
				Text := '';
				Bold := False;
			end;

			if SubText <> '' then
			begin
				with Bitmap.Canvas do
				begin
					Font.Color := clBlack;
					if Bold then Font.Style := [fsBold];
					TextOut(Pos, BmpRect.Top, SubText);
					Pos := Pos + TextWidth(SubText);
					if Bold then Font.Style := [];
				end;
				if Pos > BmpRect.Right then Break;
			end;
		end;

		FromImage.Picture.Assign(Bitmap);
		FromImage.Refresh;
	finally
		Bitmap.Free;
	end;
end;

procedure TThreadViewFrame.FrameCreate(Sender: TObject);
begin
	if not Initialized then
	begin
		Browser.Navigate('about:blank');
		while (not Assigned(Browser.Document)) do
			Application.ProcessMessages;

		Initialized := True;
	end;
end;

procedure TThreadViewFrame.LoadDatFile(ThreadIdx: T2chThreadIndex);
var
	FileName: TFileName;
begin
	FileName := ChangeFileExt('log\' + ThreadIdx.LogPath, '.dat');
	MsgList.LoadFromFile(FileName);
	TrackBar.Min := 1;
	TrackBar.Max := MsgList.Count;
	RefreshView(0);
end;

procedure TThreadViewFrame.RefreshView(Index: Integer);
var
	Doc: Variant;
	Html: string;
	List: TStringList;
{CommaSplit}
	function CommaSplit(List: TStringList; const str: string): Integer;
	var
		I, Count: Integer;
		TmpStr: string;
	begin
		TmpStr := '';
		Count := 0;

		for I := 1 to Length(str) do
		begin
			if str[I] = ',' then
			begin
				TmpStr := StringReplace(TmpStr, 'M', ',', [rfReplaceAll]);
				List.Add(TmpStr);
				Inc(Count);
				TmpStr := '';
			end else
				TmpStr := TmpStr + str[I];
		end;

		if TmpStr <> '' then
		begin
			List.Add(TmpStr);
			Inc(Count);
		end;

		Result := Count;
	end;
begin
	List := TStringList.Create;
	try
		NumText.Caption := IntToStr(Index + 1);
		CommaSplit(List, MsgList[Index]);

		FromText := List[0];
		DrawFrom(FromText);
		FromImage.Hint := List[1];

		DateText.Caption := List[2];
		DateText.Hint := List[2];

		Doc := Browser.Document;
		Doc.Clear;
		Html := '<HTML LANG="ja">';
		if BodyStyle <> '' then
			Html := Html + '<BODY style=''' + BodyStyle + '''>'
		else
			Html := Html + '<BODY>';
		Html := Html + List[3] + '</BODY></HTML>';
		Doc.Write(Html);
		Doc.Close;
	finally
		List.Free;
	end;
end;

procedure TThreadViewFrame.TrackBarChange(Sender: TObject);
begin
	RefreshView(TrackBar.Position - 1);
end;

procedure TThreadViewFrame.TopBtnClick(Sender: TObject);
begin
	TrackBar.Position := TrackBar.Min;
end;

procedure TThreadViewFrame.PrevBtnClick(Sender: TObject);
begin
	with TrackBar do
		if Min < Position then Position := Position - 1;
end;

procedure TThreadViewFrame.NextBtnClick(Sender: TObject);
begin
	with TrackBar do
		if Position < Max then Position := Position + 1;
end;

procedure TThreadViewFrame.BottomBtnClick(Sender: TObject);
begin
	TrackBar.Position := TrackBar.Max;
end;

procedure TThreadViewFrame.FrameResize(Sender: TObject);
begin
	DrawFrom(FromText);
end;

end.

