unit XDOMIndent;

interface
uses
	XDOM_2_3_J3, Classes, Dialogs;

type
	TIndentedDomDocument = class(TdomDocument)
  	private
    	procedure writeElementsCode(node:TdomNode; stream: TStream; indent: Integer);
		public
    	procedure writeCode(stream: TStream);override;
      procedure SaveToFile(filename: String);
  end;

implementation
uses
  Sysutils;

{ TIndentedDomDocument }

procedure TIndentedDomDocument.SaveToFile(filename: String);
var
  fs: TFileStream;
begin
  fs := TFileStream.Create(filename, fmCreate);
  try
    writeCodeAsShiftJIS(fs);
  finally
    fs.Free;
  end;
end;

procedure TIndentedDomDocument.writeCode(stream: TStream);
var
  vr,ed,sd: wideString;
  i: Integer;
begin
// ̃R[h͎sȂ
//  inherited;
  if version = ''
    then vr:= '1.0'
    else vr:= version;
  if encoding = ''
    then ed:= ''
    else ed:= concat(' encoding="',encoding,'"');
  if standalone = ''
    then sd:= ''
    else sd:= concat(' standalone="',standalone,'"');
  writeWideStrings(stream, ['<?xml version="', vr, '"', ed, sd]);
  writeWideChars(stream, ['?', '>', #10]);

  for i:= 0 to ChildNodes.Length - 1 do
  begin
//    ChildNodes.item(i).writeCode(stream);
//    writeWideChars(stream, [#10]);
  	writeElementsCode(childNodes.item(i), stream, 0);
  end;
end;

procedure TIndentedDomDocument.writeElementsCode(node: TdomNode;
  stream: TStream; indent: Integer);
var
	ndName, ndValue: String;
  i: Integer;
begin
	ndName := node.nodeName;
  ndValue := node.nodeValue;

//  if (node.nodeType <> ntText_Node) or (ndValue <> '') then
	begin
    if node.nodeType = ntElement_Node then
    begin
      writeWideString(stream, StringOfChar(#9, indent));
      writeWideChars(stream, ['<']);
      writeWideString(stream, ndName);
      for i:= 0 to node.Attributes.length -1 do
        if (node.Attributes.Item(i) as TdomAttr).specified then
        begin
          writeWideChars(stream, [' ']);
          With node.Attributes do
          begin
            writeWideString(stream, Item(i).nodeName);
            writeWideString(stream, '="');
            writeWideString(stream, Item(i).nodeValue);
            writeWideChars(stream, ['"']);
          end;
        end;
      writeWideChars(stream, ['>']);
      if node.childNodes.length > 0 Then
      begin
        if node.firstChild.nodeType = ntElement_Node then
        begin
          writeWideChars(stream, [#10]);
          for i := 0 to node.childNodes.length - 1 do
            writeElementsCode(node.childNodes.item(i), stream, indent + 1);
          writeWideString(stream, StringOfChar(#9, indent));
        end
        else
	        writeWideString(stream, node.textContent);
      end;
      writeWideChars(stream, ['<', '/']);
      writeWideString(stream, ndName);
      writeWideChars(stream, ['>', #10]);
    end
    else if (node.nodeType = ntProcessing_Instruction_Node) then
//    else
    begin
      writeWideStrings(stream, ['<?', ndName, ' ', ndValue, '?>', #10]);
    end;
  end;
end;

end.
