unit untBBS2chKako;

interface

uses
  Classes, Dialogs, SysUtils,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  IdCookieManager,
  RegExpr, DzURL, gzip, 
  untStreamTool, untTool,
  untHttpThread,
  untBBSFramework,
  untLoginForm;

type

  TBBS2chKakoGetTopic = class(TBBSGetTopic)
  private
    FURL          : string;
    FNoFirstLine  : boolean;
    FReadPosition : integer;
    FWriteEvent   : TMemoryStreamEx;
    FBuffer       : TMemoryStream;
    FBufferReader : TStreamReader;
    FGzipStream   : TGzipDecompressStream;
    FGzipinitialized  : boolean;
    FServer           : string;
    FBoardId          : string;
    FTopicId          : string;
    FError            : boolean;
    FHeaderSize       : integer;
    FIsExists         : boolean;
    procedure HttpReceived(const Buff; Count : int64);
    procedure ShowLoginForm();
    procedure SetIsExists(const Value: boolean);
    procedure ParseBuffer();
  public
    property    IsExists : boolean read FIsExists write SetIsExists;
    procedure   Get(); override;
    constructor Create(Server, BoardId, TopicId : string);
    destructor  Destroy; override;
  end;

implementation

uses
  untOption;

{ TBBS2chKakoGetTopic }

constructor TBBS2chKakoGetTopic.Create(Server, BoardId, TopicId: string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;
  FTopicId := TopicId;

end;

destructor TBBS2chKakoGetTopic.Destroy;
begin

  inherited;
end;

procedure TBBS2chKakoGetTopic.Get;
var
  contentsize : integer;
  Url         : string;
  DirHead     : string;
begin
  inherited;

  if Length(FTopicId) > 9 then
    Url := 'http://' + FServer + '/' + FBoardId + '/kako/' + Copy(FTopicId, 1, 4)
                     + '/' + Copy(FTopicId, 1, 5) + '/' + FTopicId + '.dat.gz'
  else
    Url := 'http://' + FServer + '/' + FBoardId + '/kako/' + Copy(FTopicId, 1, 3)
                     + '/' + FTopicId + '.dat.gz';

  FBufferReader := nil;
  FBuffer       := nil;
  FWriteEvent   := nil;
  try
    FReadPosition := 0;
    FWriteEvent := TMemoryStreamEx.Create();
    FWriteEvent.OnWrite := HttpReceived;
    FBuffer       := TMemoryStream.Create();
    FBufferReader := TStreamReader.Create(FBuffer);
    FNoFirstLine  := true;
    FGzipinitialized := false;
    FError           := false;
    FHeaderSize      := 0;
    FIsExists        := true;
    FGzipStream      := TGzipDecompressStream.Create(FBuffer);

    FHttp.Get(URL, FWriteEvent);
    ParseBuffer;

    contentsize := FBuffer.Size - FHeaderSize;
    if contentsize > 0 then
    begin
      if FDatSize = 0 then
        FDatSize := contentsize
      else
        FDatSize := FDatSize + contentsize - 1;
    end;
    
  except
    on E : EIdHTTPProtocolException do
    begin
      FIsExists := false;
    end;
  end;

  FGzipStream.Free;
  FBufferReader.Free;
  FBuffer.Free;
  FWriteEvent.Free;

  if FGzipinitialized then
    FGzipStream.Free;

end;

procedure TBBS2chKakoGetTopic.HttpReceived(const Buff; Count: int64);
begin

  if FError then exit;

  FGzipStream.write(buff, count);

end;

procedure TBBS2chKakoGetTopic.ParseBuffer;
var
  line   : string;
  RegExp : TRegExpr;
  Index  : integer;
begin

  RegExp := TRegExpr.Create;
  RegExp.Expression := '^(.*?)<>(.*?)<>(.*?)<>(.*?)<>';

  Index := 0;
  FBuffer.Seek(0, soFromBeginning);
  while FBufferReader.ReadLine(line) do
  begin
    FReadPosition := FBuffer.Position;

    Inc(Index);
    if Index > FGotMessageCount then
    begin

      // sǉ
      if RegExp.Exec(line) then
        FArticleList.Add(line)
      else
      begin
        RaiseError(etParse, '̓G[');
        FArticleList.Add('<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                         '<>' +
                         '<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                         '<FONT COLOR="Gray">[Ă܂]</FONT><>');
      end;
    end;

  end;

  Regexp.Free;

  //Synchronize(RaiseMessageReceivedEvent);
  FBuffer.Seek(0, soFromEnd);

  if Assigned(OnReceived) then OnReceived(self);

end;

procedure TBBS2chKakoGetTopic.SetIsExists(const Value: boolean);
begin
  FIsExists := Value;
end;

procedure TBBS2chKakoGetTopic.ShowLoginForm;
begin

end;

end.
