unit untBBSJBBS;

interface

uses
  Classes, Dialogs, SysUtils,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  IdCookieManager,
  RegExpr, DzURL, 
  untStreamTool, untTool,
  untHttpThread,
  untBBSFramework;

type

  TBBSJBBSGetTopic = class(TBBSGetTopic)
  private
    FURL             : string;
    FMessageCount    : integer;
    FNoFirstLine     : boolean;
    FReadPosition    : integer;
    FWriteEvent      : TMemoryStreamEx;
    FBuffer          : TMemoryStream;
    FBufferLines     : string;
    FBufferReader    : TStreamReader;
    FReceivedDatSize : integer;
    FReceivedIndex   : integer;
    procedure HttpReceived(const Buff; Count : int64);
  public
    procedure   Get(); override;
    constructor Create(Server, BoardId, TopicId : string);
    destructor  Destroy; override;
  end;

  TBBSJBBSPostArticle = class(TBBSPostArticle)
  private
    FServer  : string;
    FBoardId : string;
    FTopicId : string;
    procedure HTTPRedirect(Sender: TObject; var dest: String;
      var NumRedirect: Integer; var Handled: Boolean;
      var VMethod: TIdHTTPMethod);
  public
    procedure   Post(PostName, PostEmail, Body : string); override;
    constructor Create(Server, BoardId, TopicId : string);
    destructor  Destroy; override;
  end;

  TBBSJBBSGetTopicList = class(TBBSGetTopicList)
  private
    FServer       : string;
    FBoardId      : string;
    FReadPosition : integer;
    FWriteEvent   : TMemoryStreamEx;
    FBuffer : TMemoryStream;
    FBufferReader : TStreamReader;
    procedure HttpReceived(const Buff; Count : int64);
  public
    procedure   Get(); override;
    constructor Create(Server, BoardId : string);
  end;

implementation

{ TBBSJBBSGetTopic }

constructor TBBSJBBSGetTopic.Create(Server, BoardId, TopicId : string);
begin
  inherited Create();

  FURL := 'http://' + Server
        + '/bbs/read.cgi?BBS=' + BoardId
        + '&KEY=' + TopicId;

  FArticleList := TStringList.Create;

end;

destructor TBBSJBBSGetTopic.Destroy;
begin

  FArticleList.Free;

  inherited;
end;

procedure TBBSJBBSGetTopic.Get;
var
  contentsize : integer;
begin
  inherited;

  try
    FReadPosition := 0;
    FWriteEvent := TMemoryStreamEx.Create();
    FWriteEvent.OnWrite := HttpReceived;
    FBuffer       := TMemoryStream.Create();
    FBufferReader := TStreamReader.Create(FBuffer);
    FReceivedIndex := FDatSize;
    FHttp.Get(FURL, FWriteEvent);

    FDatSize := FReceivedIndex;

  finally
    FBufferReader.Free;
    FBuffer.Free;
    FWriteEvent.Free;
  end;

end;

procedure TBBSJBBSGetTopic.HttpReceived(const Buff; Count: int64);
var
  line       : string;
  RegExp     : TRegExpr;
  msgNo      : integer;
  msgName    : string;
  msgEmail   : string;
  msgRestStr : string;
  msgBody    : string;
  RegOK      : boolean;
begin

  FBuffer.Seek(0, soFromEnd);
  FBuffer.Write(Buff, Count);
  FBuffer.Seek(FReadPosition, soFromBeginning);

  RegExp := TRegExpr.Create;

  while FBufferReader.ReadLine(line) do
  begin
    FBufferLines  := FBufferLines + line;
    FReadPosition := FBuffer.Position;

    RegOK := false;
    RegExp.Expression := '<dt>(.+?) .+<b>(.*?)</[bB]></font>(.+?)<br><dd>(.*?)<br><br>$';
    if RegExp.Exec(FBufferLines) then
    begin
      RegOK      := true;
      msgno      := StrToIntNeo(RegExp.Substitute('$1'));
      msgEmail   := '';
      msgName    := RegExp.Substitute('$2');
      msgRestStr := RegExp.Substitute('$3');
      msgBody    := RegExp.Substitute('$4');
    end else
    begin
      RegExp.Expression := '<dt>(.+?) .+<a href="mailto:(.*?)"><b>(.*?)</[bB]></a> (.+?)<br><dd>(.*?)<br><br>$';
      if RegExp.Exec(FBufferLines) then
      begin
        RegOK      := true;
        msgno      := StrToIntNeo(RegExp.Substitute('$1'));
        msgEmail   := RegExp.Substitute('$2');
        msgName    := RegExp.Substitute('$3');
        msgRestStr := RegExp.Substitute('$4');
        msgBody    := RegExp.Substitute('$5');
      end;
    end;

    if RegOK then
    begin
      FBufferLines := '';

      if msgno = FReceivedIndex + 1 then
      begin
        Inc(FReceivedIndex);

        // sǉ
        FArticleList.Add(msgName    + '<>'
                       + msgEmail   + '<>'
                       + msgRestStr + '<>'
                       + msgBody    + '<>');
      end;
    end;


  end;

  Regexp.Free;

  //Synchronize(RaiseMessageReceivedEvent);
  FBuffer.Seek(0, soFromEnd);

  if Assigned(OnReceived) then OnReceived(self);

end;

{ TBBSJBBSPostArticle }

constructor TBBSJBBSPostArticle.Create(Server, BoardId, TopicId: string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;
  FTopicId := TopicId;
end;

destructor TBBSJBBSPostArticle.Destroy;
begin

  inherited;
end;

procedure TBBSJBBSPostArticle.Post(PostName, PostEmail, Body: string);
var
  PostData : TStringList;
  intTime  : integer;
  response : string;
  ErrorMsg : string;
begin

  FHttp.Request.Referer := 'http://' + FServer + '/' + FBoardId  + '/index2.html';
  //FHttp.CookieManager   := TIdCookieManager.Create(nil);
  FHttp.HTTPOptions := [];
  FHttp.Request.CustomHeaders.Add('Cookie: NAME=' + UrlEncode(PostName)
                               + '&Cookie: MAIL=' + UrlEncode(PostEmail) +';');
  FHttp.OnRedirect := HTTPRedirect;
  
  intTime := Round((Now() - EncodeDate(1970, 1, 1)) * 86400);
  PostData := TStringList.Create;
  PostData.Add('submit='  + UrlEncode('') + '&' +
               'NAME='    + UrlEncode(PostName)   + '&' +
               'MAIL='    + UrlEncode(PostEmail)  + '&' +
               'MESSAGE=' + UrlEncode(Body)       + '&' +
               'BBS='     + FBoardId              + '&' +
               'KEY='     + FTopicId              + '&' +
               'TIME='    + IntToStr(intTime));

  try
    response := FHttp.Post('http://' + FServer + '/bbs/write.cgi', PostData);
  except on Exception do ;
  end;

  PostData.Free;

  if ErrorMsg <> '' then
    RaiseError(etPostArticle, ErrorMsg)
  else
    if Assigned(FOnComplete) then FOnComplete(self);

end;

procedure TBBSJBBSPostArticle.HTTPRedirect(Sender: TObject; var dest: String;
  var NumRedirect: Integer; var Handled: Boolean;
  var VMethod: TIdHTTPMethod);
begin
  Handled := false;
end;

{ TBBSJBBSGetTopicList }

constructor TBBSJBBSGetTopicList.Create(Server, BoardId: string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;

end;

procedure TBBSJBBSGetTopicList.Get;
begin
  inherited;

  try
    FWriteEvent := TMemoryStreamEx.Create();
    FWriteEvent.OnWrite := HttpReceived;
    FBuffer       := TMemoryStream.Create();
    FBufferReader := TStreamReader.Create(FBuffer);
    FHttp.Get('http://' + FServer + '/' + FBoardId + '/subject.txt', FWriteEvent);
  finally
    FBufferReader.Free;
    FBuffer.Free;
    FWriteEvent.Free;
  end;

end;

procedure TBBSJBBSGetTopicList.HttpReceived(const Buff; Count: int64);
var
  line  : string;
  Regex : TRegExpr;
begin

  Regex := TRegExpr.Create;

  // sPʂ
  FBuffer.Seek(0, soFromEnd);
  FBuffer.Write(Buff, Count);
  FBuffer.Seek(FReadPosition, soFromBeginning);

  while FBufferReader.ReadLine(line) do
  begin
    FReadPosition := FBuffer.Position;

    Regex.Expression := '^(.+?)\.cgi,(.*)\((.+)\)$';
    if Regex.Exec(line) then
    begin
      FTopicList.Add(Regex.Substitute('$1.dat<>$2 ($3)'));
    end else
    begin
      RaiseError(etParse, '̓G[');
    end;

    if Assigned(OnReceived) then OnReceived(self);
  end;

  Regex.Free;

end;

end.
