unit untTopicDownloadThread;

interface

uses
  Classes, SysUtils, Dialogs, SyncObjs,
  untHttpClient, untStreamTool, untTool,
  untBBSCore, untTopic, untGlobal, untOption,
  untHttp3, untHttpThread, IdComponent, RegExpr,
  untBBSSub, untBoard, jconvert, untBBSFramework,
  untBBS2ch, untBBS2chKako;

type
  TTopicDownloadThread = class(TThread)
  protected
    FBBSGetTopic    : TBBSGetTopic;
    FParent         : TTopic;
    FNoDownload     : Boolean;
    FTopicStateType : TTopicStateType;
    FDatFile        : TextFile;
    FNewMessage     : TTopicMessage;
    FBuffer         : TMemoryStream;
    FBufferReader   : TStreamReader;
    FReadPosition   : int64;
    FMessageCount   : integer;
    FNoFirstLine    : Boolean;
    FDatValue       : string;
    FRegex          : TRegExpr;
    FReadCgi        : boolean;
    FBufferLine     : string;
    FReceivedIndex  : integer;
    FCritSec        : TCriticalSection;
    FNewDat         : string;
    FNewMsgCount    : integer;
    FNoBrowser      : boolean;
    FError          : boolean;
    FErrorString    : string;
    FReseted        : boolean;
    FLoadedIndex    : integer;
    procedure LoadLog;
    procedure BBS_DownloadProcess (Sender : TObject);
    procedure BBS_DownloadComplete(Sender : TObject);
    procedure BBS_Error(Sender : TObject; ErrorCode : TFrameworkErrorType; ErrorString : string);
    procedure BBS_StatusTextChange(Sender : TObject; StatusText : string);
    function  ParseDat(line : string) : TTopicMessage;
  public
    procedure   Execute; override;
    constructor Create(Parent: TTopic; NoDownload : Boolean);
    destructor  Destroy; override;
    procedure   RaiseMessageReceivedEvent;
  end;

implementation

{ TTopicDownloadThread }

constructor TTopicDownloadThread.Create(Parent: TTopic; NoDownload : Boolean);
var
  Board  : TOnlineBoard;
  newmsg : integer;
begin
  inherited Create(True);

  FParent := Parent;
  FParent.CountUp;
  FNoDownload := NoDownload;
  FCritSec    := TCriticalSection.Create;

  if Parent.NewMessageCount < 0 then
    newmsg := 0
  else
    newmsg := Parent.NewMessageCount;
  FLoadedIndex := Parent.GotMessageCount - newmsg;
  Board := TOnlineBoard(Parent.Board);
  FBBSGetTopic := CreateBBSGetTopic(Board.Server, Board.BoardName, parent.TopicId);

end;

destructor TTopicDownloadThread.Destroy;
begin
  FParent.CountDown;
  FBBSGetTopic.Free;
  FCritSec.Free;

  inherited;
end;

procedure TTopicDownloadThread.Execute;
var
  logpath        : string;
  msgcount       : integer;
  parse          : TTopicMessage;
  contentsize    : integer;
  blnError       : boolean;
  I              : integer;
  blnBreak       : boolean;
  totalsecond    : string;
  proxyitem      : TStringArray;
  proxyhost      : string;
  proxyport      : integer;
  logvalue       : string;
  msg            : TTopicMessage;
  startindex     : integer;
  newmsgcount    : integer;
  blnFreezed     : boolean;
  Board          : TOnlineBoard;
label
  StartDownload,
  Finish;
begin
  inherited;

  FParent.IsDownloadingTopic := true;
  FParent.CheckWriteFolder;
  FNewMsgCount := 0;
  FNoBrowser   := not Assigned(FParent.OnMessageReceived);

  // Oǂݍ
  LoadLog();

  {
  if FNoBrowser = false then
  begin
    FParent.NewMessageCount := 0;
  end;
  }

StartDownload:

  if FNoDownload = false then
  begin

    if Terminated = true then goto Finish;

    // ʐMJn
    FReceivedIndex := -1;
    FBBSGetTopic.OnReceived         := BBS_DownloadProcess;
    FBBSGetTopic.OnComplete         := BBS_DownloadComplete;
    FBBSGetTopic.OnStatusTextChange := BBS_StatusTextChange;
    FBBSGetTopic.OnError            := BBS_Error;
    FBBSGetTopic.LastModified       := FParent.LastModified;
    FBBSGetTopic.DatSize            := FParent.DatSize;
    FBBSGetTopic.GotMessageCount    := FParent.GotMessageCount;
    FBBSGetTopic.Get;

    if FBBSGetTopic is TBBS2chGetTopic then
      if TBBS2chGetTopic(FBBSGetTopic).Freezed then
      begin
        FBBSGetTopic.Free;
        Board := TOnlineBoard(FParent.Board);
        FBBSGetTopic := CreateBBSGetTopic(Board.Server, Board.BoardName, Fparent.TopicId, btKako);
        goto StartDownload;
      end;

    if gSessionId <> '' then
      if FBBSGetTopic is TBBS2chKakoGetTopic then
        if TBBS2chKakoGetTopic(FBBSGetTopic).IsExists = false then
        begin
          FBBSGetTopic.Free;
          Board := TOnlineBoard(FParent.Board);
          FBBSGetTopic := CreateBBSGetTopic(Board.Server, Board.BoardName, Fparent.TopicId, btDolib);
          goto StartDownload;
        end;

    // L^
    FParent.LastModified    := FBBSGetTopic.LastModified;
    FParent.DatSize         := FBBSGetTopic.DatSize;
    FParent.GotMessageCount := FParent.GotMessageCount + FNewMsgCount;
    FParent.MessageCount    := FParent.GotMessageCount;

    if FNewMsgCount > 0 then
      FParent.LastReadDate  := DateTimeToStr(Now());

    if FNoBrowser then
      FParent.NewMessageCount := FParent.NewMessageCount + FNewMsgCount
    else
      FParent.NewMessageCount := 0;
      
    //FParent.GotMessageCount := FParent.MessageList.Count;

    if FError = false then
    begin
      FParent.DownloadState := dsNone;

      if FNewMsgCount = 0 then
        FParent.StatusText := 'VȂ'
      else
        FParent.StatusText := IntToStr(FNewMsgCount) + '̃XM';
    end else
      FParent.StatusText := FErrorString;
  end;

  // DATt@C̏o
  logpath := FParent.LocalDir + FParent.TopicId + '.d';
  AssignFile(FDatFile, logpath);
  if FileExists(logpath) = false then ReWrite(FDatFile);
  Append(FDatFile);
  Write(FDatFile, FNewDat);
  CloseFile(FDatFile);

Finish:

  FParent.SaveIdx();

  FParent.DownloadState := dsNone;
  FParent.IsDownloadingTopic := false;

  Terminate;
end;

procedure TTopicDownloadThread.BBS_DownloadProcess(Sender: TObject);
var
  I   : integer;
  msg : TTopicMessage;
begin

  FCritSec.Enter;

  if FBBSGetTopic.Reset then
    if FReseted = false then
    begin
      FParent.EraseMessageList;
      FReseted := true;
    end;
  
  for I := FReceivedIndex + 1 to FBBSGetTopic.ArticleList.Count - 1 do
  begin

    if FParent.IsLoadedLocalDat then
    begin
      try
        msg := ParseDat(FBBSGetTopic.ArticleList[I]);
        msg.IsNewMessage := true;
        FParent.AddNewMessage(msg);
      except on Exception do ;
      end;
    end;

    Inc(FNewMsgCount);
    FNewDat := FNewDat + FBBSGetTopic.ArticleList[I] + #13#10;

    FReceivedIndex := I;
  end;

  if FNoBrowser = false then
    RaiseMessageReceivedEvent;

  FCritSec.Leave;

end;

procedure TTopicDownloadThread.BBS_DownloadComplete(Sender: TObject);
begin
end;

procedure TTopicDownloadThread.RaiseMessageReceivedEvent;
begin
  if Assigned(FParent.OnMessageReceived) then
    FParent.OnMessageReceived(FParent);
end;

function TTopicDownloadThread.ParseDat(line: string): TTopicMessage;
var
  items : TStringArray;
  msgName     : string;
  msgEmail    : string;
  msgRestStr  : string;
  msgBody     : string;
  msg         : TTopicMessage;
begin

  items := Split(line, '<>');
  msgName    := items[0];
  msgEmail   := items[1];
  msgRestStr := items[2];
  msgBody    := items[3];

  msg := TTopicMessage.Create;
  msg.PostName  := msgName;
  msg.PostEmail := msgEmail;
  msg.RestStr   := msgRestStr;
  msg.Body      := msgBody;

  result := msg

end;

procedure TTopicDownloadThread.LoadLog;
var
  localloaded : boolean;
  I, J        : Integer;
  msg         : TTopicMessage;
  msgcount    : Integer;
  logpath     : string;
  logvalue    : string;
  lines       : TStringList;
  parse       : TTopicMessage;
  items       : TStringArray;
  msgName     : string;
  msgEmail    : string;
  msgRestStr  : string;
  msgBody     : string;
begin

  msgcount := FParent.MessageList.Count;

  if FParent.IsLoadedLocalDat = false then
  begin

    lines := TStringList.Create;

    logpath := FParent.LocalDir + FParent.TopicId + '.d';
    if FileExists(logpath) = true then
    begin

      if FNoBrowser = false then
      begin

        // [Jǂݍ
        lines.LoadFromFile(logpath);
        for I := 0 to lines.Count - 1 do
        begin
          msg := ParseDat(lines[I]);
          FParent.AddNewMessage(msg);
          if msg.Index > FLoadedIndex then
            msg.IsNewMessage := true;

        end;
        localloaded := true;
      end;

    end else
    begin

      localloaded := true;

      // Of[^AÂ``
      // ÔȂ炻炩ǂݍ
      logpath := FParent.LocalDir + FParent.TopicId + '.dat';
      if FileExists(logpath) = true then
      begin
        FParent.OldLog := true;

        lines.LoadFromFile(logpath);
        for I := 0 to lines.Count - 1 do
        begin
          items := Split(lines[I], ',');
          for J := 0 to 3 do
            items[J] := StringReplace(items[J], 'M', ',', [rfReplaceAll]);

          msgName    := items[0];
          msgEmail   := items[1];
          msgRestStr := items[2];
          msgBody    := items[3];

          if FNoBrowser = false then
          begin
            msg := TTopicMessage.Create;
            msg.PostName  := msgName;
            msg.PostEmail := msgEmail;
            msg.RestStr   := msgRestStr;
            msg.Body      := msgBody;
            FParent.AddNewMessage(msg);
          end;

          FNewDat := FNewDat +
                     msg.PostName  + '<>'
                   + msg.Postemail + '<>'
                   + msg.RestStr   + '<>'
                   + msg.Body + #13#10;

        end;
      end;
    end;
    if localloaded then
      FParent.IsLoadedLocalDat := true;

    lines.Free;    
  end;

  if FParent.IsLoadedLocalDat then
  begin
  	FParent.Gotmessagecount := FParent.MessageList.Count;
  end;

  Synchronize(RaiseMessageReceivedEvent);
  FParent.DownloadState := dsDatLoaded;

end;

procedure TTopicDownloadThread.BBS_StatusTextChange(Sender: TObject;
  StatusText: string);
begin
  FParent.StatusText := StatusText;
end;

procedure TTopicDownloadThread.BBS_Error(Sender: TObject;
  ErrorCode: TFrameworkErrorType; ErrorString: string);
begin
  FParent.StatusText := ErrorString;
  FError := true;
  FErrorString := ErrorString;

end;

end.
