unit untTopicBrowser;

interface

uses
  Classes, ComCtrls, Controls,
  untTopic, untHttp, SysUtils, untGlobal, untOption, Forms,
  untTool, ExtCtrls, windows, untBBSCore, BmRegExp, StrUtils,
  untHintWindow;

type

  TNavigateUrlEvent = procedure(sender : TObject; URL : string) of object;

  TTopicBrowser = class(TPanel)
  protected
    FOnNavigateUrl         : TNavigateUrlEvent;
    FLoading               : Boolean;
    FViewLimit             : Integer;
    FReloadTimer           : TTimer;
    FTopic                 : TTopic;
    FLogLoaded             : Boolean;
    FNewMsg                : Boolean;
    FAutoReload            : Boolean;
    FDownloading           : Boolean;
    FImageIndex            : integer;
    FCaption               : string;
    FOnChangeDownloadState : TNotifyEvent;
    FClearNewMsgFlag       : Boolean;
    procedure SetOnChangeDownloadState(const Value: TNotifyEvent);
    procedure SetTopic(const Value: TTopic);
    procedure Topic_MessageReceived(sender : TObject);  virtual;
    procedure Topic_ChangeDownloadState(Sender : TObject); virtual;
    procedure SetAutoReload(const Value: Boolean);
    procedure AutoReloadTimer(sender : TObject);
    procedure SetImageIndex(const Value: integer);
    procedure SetCaption(const Value: string);
    procedure RaiseNavigateUrlEvent(Url : string);
    procedure SetOnNavigateUrl(const Value: TNavigateUrlEvent);
    procedure JumpMessage(msgno : integer); virtual; abstract;
    function  ChangeStatusText(statustext: string) : boolean;
  public
    property    OnChangeDownloadState : TNotifyEvent read FOnChangeDownloadState write SetOnChangeDownloadState;
    property    Topic : TTopic read FTopic write SetTopic;
    property    AutoReload : Boolean read FAutoReload write SetAutoReload;
    property    ImageIndex : integer read FImageIndex write SetImageIndex;
    property    Caption : string read FCaption write SetCaption;
    property    OnNavigateUrl : TNavigateUrlEvent read FOnNavigateUrl write SetOnNavigateUrl;
    procedure   SaveScrollPosition(); virtual; abstract;
    procedure   OpenTopic(Topic : TTopic); virtual;
    procedure   CloseTopic(); virtual;
    procedure   Download();   virtual;
    procedure   ClearNewMsg();
    procedure   SearchText(str : string); virtual; abstract;
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;
    procedure   ChangeViewLimit(NewLimit : integer); virtual; abstract;
  end;

implementation

{ TopicBrowser }

//  vpeB 

procedure TTopicBrowser.SetCaption(const Value: string);
begin
  FCaption := Value;
end;

procedure TTopicBrowser.SetImageIndex(const Value: integer);
begin
  FImageIndex := Value;
end;

procedure TTopicBrowser.SetTopic(const Value: TTopic);
begin
  FTopic := Value;
end;

// I[g[hݒ
procedure TTopicBrowser.SetAutoReload(const Value: Boolean);
begin
  FAutoReload := Value;
  FReloadTimer.Enabled := Value;
  Topic_ChangeDownloadState(FTopic);
end;

procedure TTopicBrowser.SetOnNavigateUrl(const Value: TNavigateUrlEvent);
begin
  FOnNavigateUrl := Value;
end;

//  \bh 

{ --------------------------------------------------------
  ֐: Create
  pr  : RXgN^
    : AOwner
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
constructor TTopicBrowser.Create(AOwner: TComponent);
var
  lines: cardinal;
begin
  inherited Create(AOwner);

  self.BevelInner := bvNone;
  self.BevelOuter := bvNone;

  FLoading := false;
  FImageIndex := -1;
  FTopic := nil;
  FReloadTimer := TTimer.Create(self);
  FReloadTimer.Enabled  := false;
  FReloadTimer.Interval := 60000;
  FReloadTimer.OnTimer  := AutoReloadTimer;

end;

{ --------------------------------------------------------
  ֐: Destroy
  pr  : fXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
destructor TTopicBrowser.Destroy;
begin

  if FTopic <> nil then
  begin
    FTopic.StopDownload;
    FTopic.OnMessageReceived := nil;
  end;

  FReloadTimer.Free;

  inherited Destroy;
end;

{ --------------------------------------------------------
  ֐: OpenTopic
  pr  : gsbNJ
    : Topic
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.OpenTopic(Topic: TTopic);
begin

  if FTopic <> nil then CloseTopic();

  FTopic := Topic;
  if FTopic <> nil then
  begin
    FTopic.CountUp;
    FTopic.OnMessageReceived     := Topic_MessageReceived;
    FTopic.OnChangeDownloadState := Topic_ChangeDownloadState;
    FCaption := FTopic.Title;
  end else
    FCaption := '';

  FViewLimit := gViewLimit;

end;

{ --------------------------------------------------------
  ֐: CloseTopic
  pr  : gsbN
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.CloseTopic;
begin

  if FTopic <> nil then
  begin
    FTopic.StopDownload;
    FTopic.OnMessageReceived     := nil;
    FTopic.OnChangeDownloadState := nil;
    FTopic.CountDown;

    SaveScrollPosition();
  end;

  SetAutoReload(false);
  FTopic     := nil;
  FCaption  := '';
  FImageIndex := -1;
  FLogLoaded := false;

end;

{ --------------------------------------------------------
  ֐: Download
  pr  : gsbN̎M
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.Download;
begin

  if FTopic <> nil then
  begin
    if FLogLoaded = false then FTopic.NoNotice := true;
    FNewMsg := false;
    gBBSCore.DownloadTopic(FTopic);
  end;

end;

{ --------------------------------------------------------
  ֐: ClearNewMsg
  pr  : V}[N̎O
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.ClearNewMsg;
begin
  if FClearNewMsgFlag = true then exit;
  FClearNewMsgFlag := true;
  FNewMsg := false;
  Topic_ChangeDownloadState(FTopic);
  FClearNewMsgFlag := false;
end;

//  Cxg 

// ԕω
procedure TTopicBrowser.Topic_ChangeDownloadState(Sender: TObject);
begin

  if FTopic = nil then exit;
  if FTopic <> sender then exit;

  Case FTopic.DownloadState of
    dsNone:
    begin

      if FNewMsg = true then
        FImageIndex := 6
      else if FAutoReload = true then
        FImageIndex := 9
      else
        FImageIndex := -1;

      if FDownloading = true then
      begin
        FDownloading := false;

        // vOANeBułȂ
        // ^Cgo[_ł
        if FNewMsg then
          if Application.Active  = false then
            FlashWindow(Application.Handle, True);
      end;

    end;
    dsError:      FImageIndex := 7;
    dsFreezed:    FImageIndex := 8;
    dsStarting:   FImageIndex := 0;
    dsProcessing: FImageIndex := 1;
    dsDatLoaded:
    begin

      //RestoreScrollPosition;

    end;
  end;

  if Assigned(FOnChangeDownloadState) then
    FOnChangeDownloadState(self);

end;

// I[g[h
procedure TTopicBrowser.AutoReloadTimer(sender: TObject);
begin
  if FNewMsg = false then
    Download;
end;

//  vCx[g֐ 

procedure TTopicBrowser.RaiseNavigateUrlEvent(Url: string);
var
  msgno : integer;
begin

  if AnsiStartsText('Jump://goto/', Url) then
  begin

    msgno := StrToIntNeo(CopyAfter(Url, 13));
    JumpMessage(msgno);

  end else
  if Assigned(FOnNavigateUrl) then
    FOnNavigateUrl(self, Url);

end;

function TTopicBrowser.ChangeStatusText(statustext: string) : boolean;
var
  Text2    : string;
  intPos   : Integer;
  intPopup : Integer;
  msg      : TTopicMessage;
begin

  Text2 := statustext;
  result := false;

  if Text2 = '' then
    ToolTip.ReleaseHandle
  else if Copy(Text2, 1, 7) = 'mailto:' then
  begin
    ToolTip.SetHint(CopyAfter(string(Text2), 8));
    result := true;
    exit;
  end else
  if Copy(Text2, 1, 12) = 'jump://goto/' then
  begin
    intPopup := StrToIntNeo(CopyAfter(Text2, 13));
    intPopup := intPopup - 1;
    if (intPopup >= 0) and (intPopup < FTopic.MessageList.Count) then
    begin
      msg := TTopicMessage(FTopic.MessageList[intPopup]);
      ToolTip.SetHint(msg.ForPopup);
      result := true;
      exit;
    end;
  end;

  ToolTip.ReleaseHandle;

end;

procedure TTopicBrowser.SetOnChangeDownloadState(
  const Value: TNotifyEvent);
begin
  FOnChangeDownloadState := Value;
end;

procedure TTopicBrowser.Topic_MessageReceived(sender: TObject);
begin
  if sender <> FTopic then exit;

  //FTopic.NewMessageCount := 0;

end;

end.
