unit untHttpThread;

interface

uses
  Classes, SysUtils,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  untOption, untTool;

type

  TWriteEvent = procedure(const Buffer; Count : int64) of object;

  TMemoryStreamEx = class(TMemoryStream)
  private
    FOnWrite: TWriteEvent;
    procedure SetOnWrite(const Value: TWriteEvent);
  public
    property OnWrite : TWriteEvent read FOnWrite write SetOnWrite;
    function Write(const Buffer; Count: integer) : integer; override;
  end;

  //THttpProcessEvent = procedure(Sender : TObject; DownloadedSize : integer) of object;

  THttpThread = class(TThread)
  private
    procedure SetOnConnectStatusChange(const Value: TIdStatusEvent);
    procedure SetOnProcess(const Value: TWriteEvent);
  protected
    FOnConnectStatusChange : TIdStatusEvent;
    FOnProcess             : TWriteEvent;
    FUrl                   : string;
    FStartRange            : integer;
    FReceivedSize          : integer;
    FHttp                  : TIdHttp;
    procedure HttpReceived(const Buff; Count : int64); virtual;
    procedure HttpStatusChange(axSender: TObject; const axStatus: TIdStatus; const asStatusText: string); virtual;
  public
    property OnConnectStatusChange : TIdStatusEvent read FOnConnectStatusChange write SetOnConnectStatusChange;
    property OnProcess             : TWriteEvent read FOnProcess write SetOnProcess;
    procedure   Execute; override;
    constructor Create(URL          : string = '';
                       StartRange   : integer = 0);
    destructor  Destroy; override;

  end;

implementation

{ TOnWriteStream }

procedure TMemoryStreamEx.SetOnWrite(const Value: TWriteEvent);
begin
  FOnWrite := Value;
end;

function TMemoryStreamEx.Write(const Buffer; Count: integer): integer;
begin

  inherited Seek(0, soFromEnd);
  inherited Write(Buffer, Count);
  if Assigned(FOnWrite) then FOnWrite(Buffer, Count);
  result := count;

end;

{ THttpThread }

//  \bh 

{ --------------------------------------------------------
  ֐: Create
  pr  : RXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
constructor THttpThread.Create(URL          : string;
                               StartRange   : integer);
begin
  inherited Create(true);

  FUrl                   := URL;
  FStartRange            := StartRange;
  FOnConnectStatusChange := nil;
  FOnProcess             := nil;

  FHttp := TIdHttp.Create(nil);

end;

{ --------------------------------------------------------
  ֐: Destroy
  pr  : fXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
destructor THttpThread.Destroy;
begin
  FHttp.Free;

  inherited;
end;

{ --------------------------------------------------------
  ֐: Execute
  pr  : Xbh̎sJn
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure THttpThread.Execute;
var
  DestStream : TMemoryStreamEx;
  proxyitem  : TStringArray;
  proxyhost  : string;
  proxyport  : integer;
begin
  inherited;

  FHttp.OnStatus                  := HttpStatusChange;
  FHttp.Request.UserAgent         := gUserAgent;
  FHttp.Request.ContentRangeStart := FStartRange;

  // proxy
  if gReadProxyUse = true then
    if gReadProxy <> '' then
    begin
      proxyitem := Split(gReadProxy, ':');
      if length(proxyitem) >= 2 then
        proxyport := StrToIntNeo(proxyitem[1])
      else
        proxyport := 8080;
      proxyhost := proxyitem[0];

      FHttp.ProxyParams.ProxyServer := proxyhost;
      FHttp.ProxyParams.ProxyPort   := proxyport;
    end;

  DestStream := TMemoryStreamEx.Create();
  DestStream.OnWrite := HttpReceived;

  FReceivedSize := 0;

  // ڑ
  FHttp.Get(FUrl, DestStream);

  DestStream.Free;
  
end;

//  Cxg 

// ڑԕύX
procedure THttpThread.HttpStatusChange(axSender: TObject;
  const axStatus: TIdStatus; const asStatusText: string);
begin

  // Cxgs
  if Assigned(FOnConnectStatusChange) then
    FOnConnectStatusChange(self, axStatus, asStatusText); 

end;

// obt@M
procedure THttpThread.HttpReceived(const Buff; Count: int64);
begin

  Inc(FReceivedSize, Count);  

  // Cxgs
  if Assigned(FOnProcess) then
    FOnProcess(Buff, Count);

end;

procedure THttpThread.SetOnConnectStatusChange(
  const Value: TIdStatusEvent);
begin
  FOnConnectStatusChange := Value;
end;

procedure THttpThread.SetOnProcess(const Value: TWriteEvent);
begin
  FOnProcess := Value;
end;

end.
