unit untOption;

interface

uses
  IniFiles, SysUtils, Forms, Registry,
  untCrypt,
  untTool;

const
  APP_USERAGENT    = 'Monazilla/1.00 hage/1.00 (88000)';
  APP_2chUA        = 'katju88';
  DIR_LOG          = 'log\';
  FILE_BOARDALIAS  = 'board.alias';

type
  TBrowserType = (ubIE = 0 , ubDoe = 1);

var

  // O[oIvV
  gBoardListUrl  : string;         // {[hXgURL
  gWriteProxyUse : Boolean;        // ݂ɃvLVg
  gWriteProxy    : string;         // ݗpvLV
  gReadProxyUse  : Boolean;        // ǂݍ݂ɃvLVg
  gReadProxy     : string;         // ǂݍݗpvLV
  gHeaderHtml    : string;         // uEUowb_HTML
  gResHtml       : string;         // uEUoXHTML
  gNewResHtml    : string;         // uEUoVXHTML
  gViewLimit     : Integer;        // \X
  gDefaultSage   : Boolean;        // ftHg"sage"ݒ肷邩
  gBrowserType   : TBrowserType;   // uEU
  gUserAgent     : string;         // User-Agent
  gAlwaysNewTab  : Boolean;        // ɐV^uŊJ
  gMultiLineTab  : Boolean;        // ^u𕡐s\邩
  gAutoLogin     : boolean;        // NɃOC邩
  gUserId        : string;         // [U[ID
  gPassword      : string;         // pX[h
  gSavePassword  : boolean;        // pX[hۑ邩

  gOffLineMode  : Boolean;         // ItC[h쒆
  gSessionID    : string;          // OCZbVID

  // CAEg֘A
  gMainFormWindowState : Integer;  // MainForm WindowState
  gMainFormWidth       : Integer;  // MainForm Width
  gMainFormHeight      : Integer;  // MainForm Height
  gMainFormStyleType3  : Boolean;
  gMainFormStyleSub1   : Boolean;
  gMainFormStyleSub2   : Boolean;
  gMainFormStyleSub3   : Boolean;
  gBoardListBoxWidth   : Integer;  // BoardListBox  Width  size
  gTopicListViewWidth  : Integer;  // TopicListView Width  size
  gTopicListViewHeight : Integer;  // TopicListView Height size
  gTopicListViewColumnOrders : string;
  gTopicListViewColumnWidths : string;
  gCoolBarBandId       : string;
  gCoolBarBandWidth    : string;
  gCoolBarBandBreak    : string;

  procedure ReadOption();
  procedure WriteOption();

implementation

const
  FILE_OPTIONINI     = 'katju88.ini';
  FILE_HEADERHTML    = 'Header.htm';
  FILE_RESHTML       = 'Res.htm';
  FILE_NEWRESHTML    = 'NewRes.htm';
  SEC_MAIN           = 'Main';
  SEC_PROXY          = 'Proxy';
  SEC_MAINFORM       = 'MainForm';
  SEC_BOARDLISTBOX   = 'BoardListBox';
  SEC_TOPICLISTVIEW  = 'TopicListView';
  SEC_COOLBAR        = 'CoolBar';
  SEC_KATJU88        = 'katju88';
  KEY_USERAGENT      = 'UserAgent';
  KEY_BOARDLISTURL   = 'BoardListUrl';
  KEY_WRITEPROXYUSE  = 'WriteProxyUse';
  KEY_WRITEPROXY     = 'WriteProxy';
  KEY_READPROXYUSE   = 'ReadProxyUse';
  KEY_READPROXY      = 'ReadProxy';
  KEY_WINDOWSTATE    = 'WindowState';
  KEY_WIDTH          = 'Width';
  KEY_HEIGHT         = 'Height';
  KEY_STYLETYPE3     = 'StyleType3';
  KEY_STYLESUB1      = 'StyleSub1';
  KEY_STYLESUB2      = 'StyleSub2';
  KEY_STYLESUB3      = 'StyleSub3';
  KEY_VIEWLIMIT      = 'ViewLimit';
  KEY_COLUMNWIDTHS   = 'ColumnWidths';
  KEY_COLUMNORDERS   = 'ColumnOrders';
  KEY_DEFAULTSAGE    = 'DefaultSage';
  KEY_BANDID         = 'BandId';
  KEY_BANDWIDTH      = 'BandWidth';
  KEY_BANDBREAK      = 'BandBreak';
  KEY_BROWSERTYPE    = 'BrowserType';
  KEY_ALWAYSNEWTAB   = 'AlwaysNewTab';
  KEY_MULTILINETAB   = 'MultiLineTab';
  KEY_AUTOLOGIN      = 'AutoLogin';
  KEY_USERID         = 'UserId';
  KEY_PASSWORD       = 'Password';
  KEY_SAVEPASSWORD   = 'SavePassword';

{  O[o֐  }

// -----------------------------------------------------
// ֐ : ReadOption
// @ : IvV̓ǂݍ
// @ : Ȃ
// ߂l : Ȃ
// l@ : Ȃ
// -----------------------------------------------------
procedure ReadOption();
var
  OptionIni : TIniFile;
  OptionReg : TRegIniFile;
  strPath   :string;
begin

  OptionIni      := TIniFile.Create(AppPath(FILE_OPTIONINI));

  // Main
  gBoardListUrl  := OptionIni.ReadString(SEC_MAIN, KEY_BOARDLISTURL, 'http://www6.ocn.ne.jp/~mirv/2chmenu.html');
  gViewLimit     := OptionIni.ReadInteger(SEC_MAIN, KEY_VIEWLIMIT, 50);
  gDefaultSage   := OptionIni.ReadBool(SEC_MAIN, KEY_DEFAULTSAGE, false);
  gBrowserType   := TBrowserType(OptionIni.ReadInteger(SEC_MAIn, KEY_BROWSERTYPE, 0));
  gUserAgent     := OptionIni.ReadString(SEC_MAIN, KEY_USERAGENT, APP_USERAGENT); 
  gAlwaysNewTab  := OptionIni.ReadBool(SEC_MAIN, KEY_ALWAYSNEWTAB, false);
  gMultiLineTab  := OptionIni.ReadBool(SEC_MAIN, KEY_MULTILINETAB, false);

  // Proxy
  gWriteProxyUse := OptionIni.ReadBool(  SEC_PROXY, KEY_WRITEPROXYUSE, false);
  gWriteProxy    := OptionIni.ReadString(SEC_PROXY, KEY_WRITEPROXY,    '');
  gReadProxyUse  := OptionIni.ReadBool(  SEC_PROXY, KEY_READPROXYUSE,  false);
  gReadProxy     := OptionIni.ReadString(SEC_PROXY, KEY_READPROXY,     '');

  // MainForm Layout
  gMainFormWindowState := OptionIni.ReadInteger(SEC_MAINFORM,      KEY_WINDOWSTATE, Integer(wsNormal));
  gMainFormWidth       := OptionIni.ReadInteger(SEC_MAINFORM,      KEY_WIDTH,  600);
  gMainFormHeight      := OptionIni.ReadInteger(SEC_MAINFORM,      KEY_HEIGHT, 500);
  gMainFormStyleType3  := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLETYPE3, false);
  gMainFormStyleSub1   := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLESUB1,  false);
  gMainFormStyleSub2   := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLESUB2,  false);
  gMainFormStyleSub3   := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLESUB3,  false);
  gBoardListBoxWidth   := OptionIni.ReadInteger(SEC_BOARDLISTBOX,  KEY_WIDTH,  120);
  gTopicListViewWidth  := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_WIDTH,  300);
  gTopicListViewHeight := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_HEIGHT, 100);
  gTopicListViewColumnOrders := OptionIni.ReadString(SEC_TOPICLISTVIEW, KEY_COLUMNORDERS, '');
  gTopicListViewColumnWidths := OptionIni.ReadString(SEC_TOPICLISTVIEW, KEY_COLUMNWIDTHS, '');
  gCoolBarBandId             := OptionIni.ReadString(SEC_COOLBAR, KEY_BANDID, '');
  gCoolBarBandWidth          := OptionIni.ReadString(SEC_COOLBAR, KEY_BANDWIDTH, '');
  gCoolBarBandBreak          := OptionIni.ReadString(SEC_COOLBAR, KEY_BANDBREAK, ''); 

  // wb_pHTML
  strPath := AppPath(FILE_HEADERHTML);
  if FileExists(strPath) = true then
    gHeaderHtml := GetFile(strPath)
  else
    gHeaderHtml := '<html><body><font face="lr oSVbN"><dl>';

  // X\pHTML
  strPath := AppPath(FILE_RESHTML);
  if FileExists(strPath) = true then
    gResHtml := GetFile(strPath)
  else
    gResHtml := '<dt>&NUMBER OF<font color="forestgreen">&MAILNAME</font> eF&DATE</dt><dd>&MESSAGE<BR></dd><br>';

  // VX\pHTML
  strPath := AppPath(FILE_NEWRESHTML);
  if FileExists(strPath) = true then
    gNewResHtml := GetFile(strPath)
  else
    gNewResHtml := '<dt><b>&NUMBER</b> OF<font color="forestgreen">&MAILNAME</font> eF&DATE</dt><dd>&MESSAGE<BR></dd><br>';

  OptionIni.Free;

  // Dolib֘A
  OptionReg     := TRegIniFile.Create;
  gAutoLogin    := OptionReg.ReadBool  (SEC_KATJU88, KEY_AUTOLOGIN,    false);
  gUserId       := Decrypt(OptionReg.ReadString(SEC_KATJU88, KEY_USERID,  ''));
  gPassword     := Decrypt(OptionReg.ReadString(SEC_KATJU88, KEY_PASSWORD,''));
  gSavePassword := OptionReg.ReadBool  (SEC_KATJU88, KEY_SAVEPASSWORD, false);
  OptionReg.Free;

end;

// -----------------------------------------------------
// ֐ : WriteOption
// @ : IvV̕ۑ
// @ : Ȃ
// ߂l : Ȃ
// l@ : Ȃ
// -----------------------------------------------------
procedure WriteOption();
var
  OptionIni : TIniFile;
  OptionReg : TRegIniFile;
begin

  OptionIni := TIniFile.Create(AppPath(FILE_OPTIONINI));

  // Main
  OptionIni.WriteString(SEC_MAIN, KEY_BOARDLISTURL, gBoardListUrl);
  OptionIni.WriteInteger(SEC_MAIN, KEY_VIEWLIMIT, gViewLimit);
  OptionIni.WriteBool(SEC_MAIN, KEY_DEFAULTSAGE, gDefaultSage);
  OptionIni.WriteInteger(SEC_MAIn, KEY_BROWSERTYPE, Integer(gBrowserType));
  OptionIni.WriteString(SEC_MAIN, KEY_USERAGENT, gUserAgent);
  OptionIni.WriteBool(SEC_MAIN, KEY_ALWAYSNEWTAB, gAlwaysNewTab);
  OptionIni.WriteBool(SEC_MAIN, KEY_MULTILINETAB, gMultiLineTab);

  // Proxy
  OptionIni.WriteBool(  SEC_PROXY, KEY_WRITEPROXYUSE, gWriteProxyUse);
  OptionIni.WriteString(SEC_PROXY, KEY_WRITEPROXY,    gWriteProxy);
  OptionIni.WriteBool(  SEC_PROXY, KEY_READPROXYUSE,  gReadProxyUse);
  OptionIni.WriteString(SEC_PROXY, KEY_READPROXY,     gReadProxy);

  // MainForm Layout
  OptionIni.WriteInteger(SEC_MAINFORM,      KEY_WINDOWSTATE,  gMainFormWindowState);
  OptionIni.WriteInteger(SEC_MAINFORM,      KEY_WIDTH,        gMainFormWidth);
  OptionIni.WriteInteger(SEC_MAINFORM,      KEY_HEIGHT,       gMainFormHeight);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLETYPE3, gMainFormStyleType3);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLESUB1,  gMainFormStyleSub1);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLESUB2,  gMainFormStyleSub2);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLESUB3,  gMainFormStyleSub3);
  OptionIni.WriteInteger(SEC_BOARDLISTBOX,  KEY_WIDTH,        gBoardListBoxWidth);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_WIDTH,        gTopicListViewWidth);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_HEIGHT,       gTopicListViewHeight);
  OptionIni.WriteString (SEC_TOPICLISTVIEW, KEY_COLUMNWIDTHS, gTopicListViewColumnWidths);
  OptionIni.WriteString (SEC_TOPICLISTVIEW, KEY_COLUMNORDERS, gTopicListViewColumnOrders);
  OptionIni.WriteString(SEC_COOLBAR, KEY_BANDID, gCoolBarBandId);
  OptionIni.WriteString(SEC_COOLBAR, KEY_BANDWIDTH, gCoolBarBandWidth);
  OptionIni.WriteString(SEC_COOLBAR, KEY_BANDBREAK, gCoolBarBandBreak);

  OptionIni.Free;

  // Dolib֘A
  OptionReg := TRegIniFile.Create;
  OptionReg.WriteBool  (SEC_KATJU88, KEY_AUTOLOGIN,    gAutoLogin);
  OptionReg.WriteString(SEC_KATJU88, KEY_USERID,       Crypt(gUserId));
  OptionReg.WriteBool  (SEC_KATJU88, KEY_SAVEPASSWORD, gSavePassword);

  if gSavePassword then
    OptionReg.WriteString(SEC_KATJU88, KEY_PASSWORD,   Crypt(gPassword))
  else
    OptionReg.DeleteKey(SEC_KATJU88, KEY_PASSWORD);

  OptionReg.Free;

end;


end.
