unit untBBS2chDolib;

interface

uses
  Classes, Dialogs, SysUtils,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  IdCookieManager,
  RegExpr, DzURL,  
  untStreamTool, untTool,
  untBBSFramework, untBBS2ch,
  untLoginForm;

type

  TBBS2chDolibGetTopic = class(TBBS2chGetTopic)
  private
    FIsExists: Boolean;
    procedure SetIsExists(const Value: Boolean);
    function  GetURL : string; override;
  public
    property Freezed : Boolean read FIsExists write SetIsExists;
    constructor Create(Server, BoardId, TopicId: string);
    destructor Destroy; override;
  end;

implementation

uses
  untGlobal;

{ TBBS2chDolibGetTopic }

constructor TBBS2chDolibGetTopic.Create(Server, BoardId, TopicId: string);
begin
  inherited Create(Server, BoardId, TopicId);

  FHttp.UseGzip := true;
  FRawMode := true;

end;

destructor TBBS2chDolibGetTopic.Destroy;
begin

  inherited;
end;

function TBBS2chDolibGetTopic.GetURL: string;
begin
  result := 'http://' + FServer + '/test/offlaw.cgi/' +
           FBoardId + '/' + FTopicId + '/?raw=.' +
           IntToStr(FDatSize) + '&sid=' + UrlEncode(gConfig.SessionId);
end;

procedure TBBS2chDolibGetTopic.SetIsExists(const Value: Boolean);
begin
  FIsExists := Value;
end;

end.
