unit untBBS2chKako;

interface

uses
  Classes, Dialogs, SysUtils,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  IdCookieManager,
  RegExpr, DzURL,  
  untStreamTool, untTool,
  untBBSFramework, untBBS2ch,
  untLoginForm;

type

  TBBS2chKakoGetTopic = class(TBBS2chGetTopic)
  protected
    FIsExists: Boolean;
    procedure SetIsExists(const Value: Boolean);
    function  GetURL : string; override;
  public
    constructor Create(Server, BoardId, TopicId : string);
    property IsExists : Boolean read FIsExists write SetIsExists;
  end;

implementation

{ TBBS2chKakoGetTopic }

constructor TBBS2chKakoGetTopic.Create(Server, BoardId, TopicId: string);
begin
  inherited Create(Server, BoardId, TopicId);

  FHttp.UseGzip := true;
  FRawMode := true;

end;

function TBBS2chKakoGetTopic.GetURL: string;
begin
  if Length(FTopicId) > 9 then
    result := 'http://' + FServer + '/' + FBoardId + '/kako/' + Copy(FTopicId, 1, 4)
                     + '/' + Copy(FTopicId, 1, 5) + '/' + FTopicId + '.dat.gz'
  else
    result := 'http://' + FServer + '/' + FBoardId + '/kako/' + Copy(FTopicId, 1, 3)
                     + '/' + FTopicId + '.dat.gz';
end;

procedure TBBS2chKakoGetTopic.SetIsExists(const Value: Boolean);
begin
  FIsExists := Value;
end;

end.
