unit untBBSJBBS;

interface

uses
  Classes, Dialogs, SysUtils,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  IdCookieManager,
  RegExpr, DzURL, jconvert, 
  untTool, untHttp, untGlobal, untConfig,
  untBBSFramework;

type

  TBBSJBBSGetTopic = class(TBBSGetTopic)
  private
    FHttp            : TAsyncHttp;
    FURL             : string;
    FReadPosition    : integer;
    FReceivedIndex   : integer;
    FBufferLines     : string;
    FServer          : string;
    procedure HttpReceived(Sender: TObject);
    procedure HttpComplete(Sender: TObject);
    procedure HttpStatus(ASender: TObject; const AStatus: TIdStatus; const AStatusText: string);
  public
    procedure   Get(); override;
    constructor Create(Server, BoardId, TopicId : string);
    destructor  Destroy; override;
  end;

  TBBSJBBSPostArticle = class(TBBSPostArticle)
  private
    FServer  : string;
    FBoardId : string;
    FTopicId : string;
    procedure HTTPRedirect(Sender: TObject; var dest: String;
      var NumRedirect: Integer; var Handled: Boolean;
      var VMethod: TIdHTTPMethod);
  public
    procedure   Post(PostName, PostEmail, Body : string); override;
    constructor Create(Server, BoardId, TopicId : string);
    destructor  Destroy; override;
  end;

  TBBSJBBSGetTopicList = class(TBBSGetTopicList)
  private
    FHttp         : TAsyncHttp;
    FServer       : string;
    FBoardId      : string;
    FReadPosition : integer;
    procedure HttpReceived(Sender: TObject);
    procedure HttpComplete(Sender: TObject);
    procedure HttpStatus(ASender: TObject; const AStatus: TIdStatus; const AStatusText: string);
  public
    procedure   Get(); override;
    constructor Create(Server, BoardId : string);
    destructor  Destroy; override;
  end;

implementation

{ TBBSJBBSGetTopic }

constructor TBBSJBBSGetTopic.Create(Server, BoardId, TopicId : string);
begin
  inherited Create();

  FServer := Server; 
  FURL := 'http://' + Server
        + '/bbs/read.pl?BBS=' + BoardId
        + '&KEY=' + TopicId;

  FArticleList := TStringList.Create;

  FHttp := TAsyncHttp(gHttpPool.GetThread);
  FHttp.FreeOnTerminate := false;
  FHttp.OnReceived := HttpReceived;
  FHttp.OnStatus   := HttpStatus;
  FHttp.OnComplete := HttpComplete;
  FHttp.UserAgent  := gConfig.UserAgent;
  FHttp.AddHeader('X-2ch-UA', APP_2chUA);
  gConfig.InitReadProxy(FHttp);

end;

destructor TBBSJBBSGetTopic.Destroy;
begin

  gHttpPool.ReleaseThread(FHttp);

  inherited;
end;

procedure TBBSJBBSGetTopic.Get;
begin
  inherited;

  FReadPosition := 0;

  if FDatSize > 0 then  FReceivedIndex := FDatSize;

  FHttp.Get(FURL);

end;

procedure TBBSJBBSGetTopic.HttpReceived(Sender: TObject);
var
  line       : string;
  RegExp     : TRegExpr;
  msgNo      : integer;
  msgName    : string;
  msgEmail   : string;
  msgRestStr : string;
  msgBody    : string;
  RegOK      : boolean;
  I          : Integer;
begin

  RegExp := TRegExpr.Create;

  msgno := -1;
  for I := FReadPosition to FHttp.ReceivedLines.Count - 1 do
  begin
    line          := ConvertJCode(FHttp.ReceivedLines[I], SJIS_OUT);
    FBufferLines  := FBufferLines + line;
    FReadPosition := I + 1;

    RegOK := false;
    RegExp.Expression := '<dt>(.+?) .+<b>(.*?)</[bB]></font>(.+?)<br><dd>(.*?)<br><br>$';
    if RegExp.Exec(FBufferLines) then
    begin
      RegOK      := true;
      msgno      := StrToIntNeo(RegExp.Substitute('$1'));
      msgEmail   := '';
      msgName    := RegExp.Substitute('$2');
      msgRestStr := RegExp.Substitute('$3');
      msgBody    := RegExp.Substitute('$4');
    end else
    begin
      RegExp.Expression := '<dt>(.+?) .+<a href="mailto:(.*?)"><b>(.*?)</[bB]></a> (.+?)<br><dd>(.*?)<br><br>$';
      if RegExp.Exec(FBufferLines) then
      begin
        RegOK      := true;
        msgno      := StrToIntNeo(RegExp.Substitute('$1'));
        msgEmail   := RegExp.Substitute('$2');
        msgName    := RegExp.Substitute('$3');
        msgRestStr := RegExp.Substitute('$4');
        msgBody    := RegExp.Substitute('$5');
      end;
    end;

    if RegOK then
    begin
      FBufferLines := '';

      if msgno = FReceivedIndex + 1 then
      begin
        Inc(FReceivedIndex);

        // sǉ
        FArticleList.Add(msgName    + '<>'
                       + msgEmail   + '<>'
                       + msgRestStr + '<>'
                       + msgBody    + '<>');
      end;
    end;


  end;

  Regexp.Free;

  if Assigned(FOnReceived) then FOnReceived(self);
end;

procedure TBBSJBBSGetTopic.HttpComplete(Sender: TObject);
begin

  FDatSIze := FReceivedIndex;
  if Assigned(FOnComplete) then FOnComplete(self);

end;


procedure TBBSJBBSGetTopic.HttpStatus(ASender: TObject;
  const AStatus: TIdStatus; const AStatusText: string);
begin
  case AStatus of
    hsConnecting : ChangeStatusText(FServer + 'ɐڑ');
    hsConnected  : ChangeStatusText(FServer + 'ɐڑ܂');
  end;
end;

{ TBBSJBBSPostArticle }

constructor TBBSJBBSPostArticle.Create(Server, BoardId, TopicId: string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;
  FTopicId := TopicId;
end;

destructor TBBSJBBSPostArticle.Destroy;
begin

  inherited;
end;

procedure TBBSJBBSPostArticle.Post(PostName, PostEmail, Body: string);
var
  PostData : TStringList;
  intTime  : integer;
  response : string;
  ErrorMsg : string;
begin

  FHttp.Request.Referer := 'http://' + FServer + '/' + FBoardId  + '/index2.html';
  //FHttp.CookieManager   := TIdCookieManager.Create(nil);
  FHttp.HTTPOptions := [];
  FHttp.Request.CustomHeaders.Add('Cookie: NAME=' + UrlEncode(PostName)
                               + '&Cookie: MAIL=' + UrlEncode(PostEmail) +';');
  FHttp.OnRedirect := HTTPRedirect;
  
  intTime := Round((Now() - EncodeDate(1970, 1, 1)) * 86400);
  PostData := TStringList.Create;
  PostData.Add('submit='  + UrlEncode('') + '&' +
               'NAME='    + UrlEncode(PostName)   + '&' +
               'MAIL='    + UrlEncode(PostEmail)  + '&' +
               'MESSAGE=' + UrlEncode(Body)       + '&' +
               'BBS='     + FBoardId              + '&' +
               'KEY='     + FTopicId              + '&' +
               'TIME='    + IntToStr(intTime));

  try
    response := FHttp.Post('http://' + FServer + '/bbs/write.cgi', PostData);
  except on Exception do ;
  end;

  PostData.Free;

  if ErrorMsg <> '' then
    RaiseError(etPostArticle, ErrorMsg)
  else
    if Assigned(FOnComplete) then FOnComplete(self);

end;

procedure TBBSJBBSPostArticle.HTTPRedirect(Sender: TObject; var dest: String;
  var NumRedirect: Integer; var Handled: Boolean;
  var VMethod: TIdHTTPMethod);
begin
  Handled := false;
end;

{ TBBSJBBSGetTopicList }

constructor TBBSJBBSGetTopicList.Create(Server, BoardId: string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;

  FHttp := TAsyncHttp(gHttpPool.GetThread);
  FHttp.FreeOnTerminate   := false;
  FHttp.OnReceived        := HttpReceived;
  FHttp.OnStatus          := HttpStatus;
  FHttp.OnComplete        := HttpComplete;
  FHttp.UserAgent := gConfig.UserAgent;
  FHttp.AddHeader('X-2ch-UA', APP_2chUA);
  gConfig.InitReadProxy(FHttp);

end;

destructor TBBSJBBSGetTopicList.Destroy;
begin

  gHttpPool.ReleaseThread(FHttp);

  inherited;
end;

procedure TBBSJBBSGetTopicList.Get;
begin
  inherited;

  FHttp.Get('http://' + FServer + '/' + FBoardId + '/subject.txt');
  
end;

procedure TBBSJBBSGetTopicList.HttpReceived(Sender: TObject);
var
  line  : string;
  Regex : TRegExpr;
  I     : Integer;
begin

  Regex := TRegExpr.Create;

  for I := FReadPosition to FHttp.ReceivedLines.Count - 1 do
  begin
    FReadPosition := I + 1;
    line := FHttp.ReceivedLines[I];

    Regex.Expression := '^(.+?)\.cgi,(.*)\((.+)\)$';
    if Regex.Exec(line) then
    begin
      AddNewLine(Regex.Substitute('$1.dat<>$2 ($3)'));
    end else
    begin
      RaiseError(etParse, '̓G[');
    end;

    if Assigned(OnReceived) then OnReceived(self);
  end;

  Regex.Free;

end;

procedure TBBSJBBSGetTopicList.HttpComplete(Sender: TObject);
begin

  if Assigned(FOnComplete) then FOnComplete(self);

end;

procedure TBBSJBBSGetTopicList.HttpStatus(ASender: TObject;
  const AStatus: TIdStatus; const AStatusText: string);
begin
  case AStatus of
    hsConnecting : ChangeStatusText(FServer + 'ɐڑ');
    hsConnected  : ChangeStatusText(FServer + 'ɐڑ܂'); 
  end;
end;

end.
