unit untConfig;

interface

uses
  IniFiles, SysUtils, Forms, Registry, Graphics,
  untCrypt,
  untTool, untHttp;

const
  APP_USERAGENT    = 'Monazilla/1.00 hage/1.00 (88000)';
  APP_2chUA        = 'katju88';
  DIR_LOG          = 'log\';
  FILE_BOARDALIAS  = 'board.alias';
  FILE_OPTIONINI   = 'katju88.ini';

type
  TBrowserType = (ubIE = 0 , ubDoe = 1);

  TConfig = class
  private
    FOptionIniPath : string;
    FMainFormStyleSub3: Boolean;
    FMainFormStyleType3: Boolean;
    FIsOffLineMode: Boolean;
    FTopicListViewGridLines: boolean;
    FMainFormStyleSub1: Boolean;
    FTopicListColorUse: Boolean;
    FDefaultSage: Boolean;
    FSavePassword: boolean;
    FMultiLineTab: Boolean;
    FMainFormStyleSub2: Boolean;
    FUseDefaultBrowser: Boolean;
    FWriteProxyUse: Boolean;
    FAutoLogin: boolean;
    FAlwaysNewTab: Boolean;
    FReadProxyUse: Boolean;
    FBoardListNoColor: Boolean;
    FAutoFocus: boolean;
    FBoardListOneCategory: Boolean;
    FTopicListViewColumnFontSize: Integer;
    FWriteFormTop: Integer;
    FMainFormWidth: Integer;
    FWriteFormHeight: Integer;
    FWriteFormLeft: Integer;
    FMainFormTop: Integer;
    FBoardListBoxWidth: Integer;
    FMainFormHeight: Integer;
    FMainFormLeft: Integer;
    FMainFormWindowState: Integer;
    FTopicListViewWidth: Integer;
    FTopicListViewColumnPadding: Integer;
    FWriteFormWidth: Integer;
    FViewLimit: Integer;
    FTopicListViewHeight: Integer;
    FWriteProxy: String;
    FInsertURL: string;
    FPassword: string;
    FCoolBarBandWidth: string;
    FBrowserPath: string;
    FTopicListViewColumnWidths: string;
    FResHtml: string;
    FKoteMail: string;
    FBoardListUrl: string;
    FNewResHtml: string;
    FCoolBarBandId: string;
    FSessionID: string;
    FMailListFile: string;
    FCoolBarBandBreak: string;
    FHeaderHtml: string;
    FReadProxy: string;
    FUserId: string;
    FTopicListViewColumnOrders: string;
    FNameListFile: string;
    FKoteHan: string;
    FUserAgent: string;
    FBrowserType: TBrowserType;
    FTopicListFavoriteColor: TColor;
    FTopicListNoNewMesColor: TColor;
    FTopicListNewTopicColor: TColor;
    FTopicListNotGotColor: TColor;
    FTopicListNewMesColor: TColor;
    procedure SetAlwaysNewTab(const Value: Boolean);
    procedure SetAutoFocus(const Value: boolean);
    procedure SetAutoLogin(const Value: boolean);
    procedure SetBoardListBoxWidth(const Value: Integer);
    procedure SetBoardListNoColor(const Value: Boolean);
    procedure SetBoardListOneCategory(const Value: Boolean);
    procedure SetBoardListUrl(const Value: string);
    procedure SetBrowserPath(const Value: string);
    procedure SetBrowserType(const Value: TBrowserType);
    procedure SetCoolBarBandBreak(const Value: string);
    procedure SetCoolBarBandId(const Value: string);
    procedure SetCoolBarBandWidth(const Value: string);
    procedure SetDefaultSage(const Value: Boolean);
    procedure SetHeaderHtml(const Value: string);
    procedure SetInsertURL(const Value: string);
    procedure SetIsOffLineMode(const Value: Boolean);
    procedure SetKoteHan(const Value: string);
    procedure SetKoteMail(const Value: string);
    procedure SetMailListFile(const Value: string);
    procedure SetMainFormHeight(const Value: Integer);
    procedure SetMainFormLeft(const Value: Integer);
    procedure SetMainFormStyleSub1(const Value: Boolean);
    procedure SetMainFormStyleSub2(const Value: Boolean);
    procedure SetMainFormStyleSub3(const Value: Boolean);
    procedure SetMainFormStyleType3(const Value: Boolean);
    procedure SetMainFormTop(const Value: Integer);
    procedure SetMainFormWidth(const Value: Integer);
    procedure SetMainFormWindowState(const Value: Integer);
    procedure SetMultiLineTab(const Value: Boolean);
    procedure SetNameListFile(const Value: string);
    procedure SetNewResHtml(const Value: string);
    procedure SetPassword(const Value: string);
    procedure SetReadProxy(const Value: string);
    procedure SetReadProxyUse(const Value: Boolean);
    procedure SetResHtml(const Value: string);
    procedure SetSavePassword(const Value: boolean);
    procedure SetSessionID(const Value: string);
    procedure SetTopicListColorUse(const Value: Boolean);
    procedure SetTopicListFavoriteColor(const Value: TColor);
    procedure SetTopicListNewMesColor(const Value: TColor);
    procedure SetTopicListNewTopicColor(const Value: TColor);
    procedure SetTopicListNoNewMesColor(const Value: TColor);
    procedure SetTopicListNotGotColor(const Value: TColor);
    procedure SetTopicListViewColumnFontSize(const Value: Integer);
    procedure SetTopicListViewColumnOrders(const Value: string);
    procedure SetTopicListViewColumnPadding(const Value: Integer);
    procedure SetTopicListViewColumnWidths(const Value: string);
    procedure SetTopicListViewGridLines(const Value: boolean);
    procedure SetTopicListViewHeight(const Value: Integer);
    procedure SetTopicListViewWidth(const Value: Integer);
    procedure SetUseDefaultBrowser(const Value: Boolean);
    procedure SetUserAgent(const Value: string);
    procedure SetUserId(const Value: string);
    procedure SetViewLimit(const Value: Integer);
    procedure SetWriteFormHeight(const Value: Integer);
    procedure SetWriteFormLeft(const Value: Integer);
    procedure SetWriteFormTop(const Value: Integer);
    procedure SetWriteFormWidth(const Value: Integer);
    procedure SetWriteProxy(const Value: String);
    procedure SetWriteProxyUse(const Value: Boolean);

    procedure SetProxy(Http : TAsyncHttp; ProxyString : string);
  public
    property BoardListUrl  : string read FBoardListUrl write SetBoardListUrl;
    property WriteProxyUse : Boolean read FWriteProxyUse write SetWriteProxyUse;
    property WriteProxy    : String read FWriteProxy write SetWriteProxy;
    property ReadProxyUse  : Boolean read FReadProxyUse write SetReadProxyUse;
    property ReadProxy     : string read FReadProxy write SetReadProxy;
    property HeaderHtml    : string read FHeaderHtml write SetHeaderHtml;
    property ResHtml       : string read FResHtml write SetResHtml;
    property NewResHtml    : string read FNewResHtml write SetNewResHtml;
    property ViewLimit     : Integer read FViewLimit write SetViewLimit;
    property DefaultSage   : Boolean read FDefaultSage write SetDefaultSage;
    property BrowserType   : TBrowserType read FBrowserType write SetBrowserType;
    property UserAgent     : string read FUserAgent write SetUserAgent;
    property AlwaysNewTab  : Boolean read FAlwaysNewTab write SetAlwaysNewTab;
    property MultiLineTab  : Boolean read FMultiLineTab write SetMultiLineTab;
    property AutoLogin     : boolean read FAutoLogin write SetAutoLogin;
    property UserId        : string read FUserId write SetUserId;
    property Password      : string read FPassword write SetPassword;
    property SavePassword  : boolean read FSavePassword write SetSavePassword;
    property AutoFocus     : boolean read FAutoFocus write SetAutoFocus;
    property IsOffLineMode : Boolean read FIsOffLineMode write SetIsOffLineMode;
    property SessionID     : string read FSessionID write SetSessionID;

    property MainFormWindowState : Integer read FMainFormWindowState write SetMainFormWindowState;
    property MainFormWidth       : Integer read FMainFormWidth write SetMainFormWidth;
    property MainFormHeight      : Integer read FMainFormHeight write SetMainFormHeight;
    property MainFormLeft        : Integer read FMainFormLeft write SetMainFormLeft;
    property MainFormTop         : Integer read FMainFormTop write SetMainFormTop;
    property MainFormStyleType3  : Boolean read FMainFormStyleType3 write SetMainFormStyleType3;
    property MainFormStyleSub1   : Boolean read FMainFormStyleSub1 write SetMainFormStyleSub1;
    property MainFormStyleSub2   : Boolean read FMainFormStyleSub2 write SetMainFormStyleSub2;
    property MainFormStyleSub3   : Boolean read FMainFormStyleSub3 write SetMainFormStyleSub3;
    property BoardListBoxWidth   : Integer read FBoardListBoxWidth write SetBoardListBoxWidth;
    property BoardListNoColor    : Boolean read FBoardListNoColor write SetBoardListNoColor;
    property BoardListOneCategory: Boolean read FBoardListOneCategory write SetBoardListOneCategory;
    property TopicListViewWidth  : Integer read FTopicListViewWidth write SetTopicListViewWidth;  // TopicListView Width  size
    property TopicListViewHeight : Integer read FTopicListViewHeight write SetTopicListViewHeight;  // TopicListView Height size
    property TopicListViewColumnOrders : string read FTopicListViewColumnOrders write SetTopicListViewColumnOrders;
    property TopicListViewColumnWidths : string read FTopicListViewColumnWidths write SetTopicListViewColumnWidths;
    property TopicListViewColumnPadding : Integer read FTopicListViewColumnPadding write SetTopicListViewColumnPadding;
    property TopicListViewColumnFontSize : Integer read FTopicListViewColumnFontSize write SetTopicListViewColumnFontSize;
    property TopicListViewGridLines      : boolean read FTopicListViewGridLines write SetTopicListViewGridLines;
    property CoolBarBandId       : string read FCoolBarBandId write SetCoolBarBandId;
    property CoolBarBandWidth    : string read FCoolBarBandWidth write SetCoolBarBandWidth;
    property CoolBarBandBreak    : string read FCoolBarBandBreak write SetCoolBarBandBreak;

    // OuEUݒ 
    property UseDefaultBrowser : Boolean read FUseDefaultBrowser write SetUseDefaultBrowser;
    property BrowserPath       : string read FBrowserPath write SetBrowserPath;
    property InsertURL         : string read FInsertURL write SetInsertURL;

    //݃tH[֘A
    property NameListFile    : string read FNameListFile write SetNameListFile;
    property MailListFile    : string read FMailListFile write SetMailListFile;
    property WriteFormWidth  : Integer read FWriteFormWidth write SetWriteFormWidth;
    property WriteFormHeight : Integer read FWriteFormHeight write SetWriteFormHeight;
    property WriteFormLeft   : Integer read FWriteFormLeft write SetWriteFormLeft;
    property WriteFormTop    : Integer read FWriteFormTop write SetWriteFormTop;
    property KoteHan         : string read FKoteHan write SetKoteHan;
    property KoteMail        : string read FKoteMail write SetKoteMail;

    // XꗗF֘A
    property TopicListColorUse      : Boolean read FTopicListColorUse write SetTopicListColorUse;
    property TopicListNotGotColor   : TColor read FTopicListNotGotColor write SetTopicListNotGotColor;
    property TopicListFavoriteColor : TColor read FTopicListFavoriteColor write SetTopicListFavoriteColor;
    property TopicListNewMesColor   : TColor read FTopicListNewMesColor write SetTopicListNewMesColor;
    property TopicListNoNewMesColor : TColor read FTopicListNoNewMesColor write SetTopicListNoNewMesColor;
    property TopicListNewTopicColor : TColor read FTopicListNewTopicColor write SetTopicListNewTopicColor;

    constructor Create(IniPath : string);
    procedure ReadOption;
    procedure WriteOption;
    procedure InitWriteProxy(Http : TAsyncHttp);
    procedure InitReadProxy (Http : TAsyncHttp);
    procedure ParseProxy(ProxyString: string; out ProxyHost : string; out ProxyPort : Integer);
  end;

implementation

const
  FILE_HEADERHTML    = 'Header.htm';
  FILE_RESHTML       = 'Res.htm';
  FILE_NEWRESHTML    = 'NewRes.htm';
  FILE_NAMELIST      = 'namelist.txt'; 
  FILE_MAILLIST      = 'maillist.txt';
  SEC_MAIN           = 'Main';
  SEC_PROXY          = 'Proxy';
  SEC_MAINFORM       = 'MainForm';
  SEC_BOARDLISTBOX   = 'BoardListBox';
  SEC_TOPICLISTVIEW  = 'TopicListView';
  SEC_COOLBAR        = 'CoolBar';
  SEC_KATJU88        = 'katju88';
  SEC_LOGIN          = 'Login';
  SEC_WRITEFORM      = 'WriteForm';
  SEC_BROWSER        = 'Browser';
  KEY_USERAGENT      = 'UserAgent';
  KEY_BOARDLISTURL   = 'BoardListUrl';
  KEY_WRITEPROXYUSE  = 'WriteProxyUse';
  KEY_WRITEPROXY     = 'WriteProxy';
  KEY_READPROXYUSE   = 'ReadProxyUse';
  KEY_READPROXY      = 'ReadProxy';
  KEY_WINDOWSTATE    = 'WindowState';
  KEY_WIDTH          = 'Width';
  KEY_HEIGHT         = 'Height';
  KEY_TOP            = 'Top';
  KEY_LEFT           = 'Left';
  KEY_STYLETYPE3     = 'StyleType3';
  KEY_STYLESUB1      = 'StyleSub1';
  KEY_STYLESUB2      = 'StyleSub2';
  KEY_STYLESUB3      = 'StyleSub3';
  KEY_VIEWLIMIT      = 'ViewLimit';
  KEY_COLUMNWIDTHS   = 'ColumnWidths';
  KEY_COLUMNORDERS   = 'ColumnOrders';
  KEY_COLUMNPADDING  = 'ColumnPadding'; 
  KEY_COLUMNFONTSIZE = 'ColumnFontSize'; 
  KEY_DEFAULTSAGE    = 'DefaultSage';
  KEY_BANDID         = 'BandId';
  KEY_BANDWIDTH      = 'BandWidth';
  KEY_BANDBREAK      = 'BandBreak';
  KEY_BROWSERTYPE    = 'BrowserType';
  KEY_ALWAYSNEWTAB   = 'AlwaysNewTab';
  KEY_MULTILINETAB   = 'MultiLineTab';
  KEY_AUTOLOGIN      = 'AutoLogin';
  KEY_USERID         = 'UserId';
  KEY_PASSWORD       = 'Password';
  KEY_SAVEPASSWORD   = 'SavePassword';
  KEY_GRIDLINES      = 'GridLines';
  KEY_NAMELIST       = 'NameListFile'; 
  KEY_MAILLIST       = 'MailListFile';
  KEY_NoColor        = 'NoColor'; 
  KEY_ONECATEGORY    = 'OneCategory';
  KEY_KOTEHAN        = 'KoteHan'; 
  KEY_KOTEMAIL       = 'KoteMail';
  KEY_USEDEFBROWSER  = 'UseDefBrowser';
  KEY_BROWSERPATH    = 'BrowserPath';
  KEY_INSERTURL      = 'InsertUrl';
  KEY_AUTOFOCUS      = 'AutoFocus';
  KEY_USECOLOR       = 'UseColor'; 
  KEY_CLNOTGOT       = 'NotGotColor'; 
  KEY_CLFAVORITE     = 'FavoriteColor'; 
  KEY_CLNEWMES       = 'NewMessageColor'; 
  KEY_CLNONEWMES     = 'NoNewMessageColor'; 
  KEY_CLNEWTOPIC     = 'NewTopicColor';

{ TConfig }

//  vpeB

procedure TConfig.SetAlwaysNewTab(const Value: Boolean);
begin
  FAlwaysNewTab := Value;
end;

procedure TConfig.SetAutoFocus(const Value: boolean);
begin
  FAutoFocus := Value;
end;

procedure TConfig.SetAutoLogin(const Value: boolean);
begin
  FAutoLogin := Value;
end;

procedure TConfig.SetBoardListBoxWidth(const Value: Integer);
begin
  FBoardListBoxWidth := Value;
end;

procedure TConfig.SetBoardListNoColor(const Value: Boolean);
begin
  FBoardListNoColor := Value;
end;

procedure TConfig.SetBoardListOneCategory(const Value: Boolean);
begin
  FBoardListOneCategory := Value;
end;

procedure TConfig.SetBoardListUrl(const Value: string);
begin
  FBoardListUrl := Value;
end;

procedure TConfig.SetBrowserPath(const Value: string);
begin
  FBrowserPath := Value;
end;

procedure TConfig.SetBrowserType(const Value: TBrowserType);
begin
  FBrowserType := Value;
end;

procedure TConfig.SetCoolBarBandBreak(const Value: string);
begin
  FCoolBarBandBreak := Value;
end;

procedure TConfig.SetCoolBarBandId(const Value: string);
begin
  FCoolBarBandId := Value;
end;

procedure TConfig.SetCoolBarBandWidth(const Value: string);
begin
  FCoolBarBandWidth := Value;
end;

procedure TConfig.SetDefaultSage(const Value: Boolean);
begin
  FDefaultSage := Value;
end;

procedure TConfig.SetHeaderHtml(const Value: string);
begin
  FHeaderHtml := Value;
end;

procedure TConfig.SetInsertURL(const Value: string);
begin
  FInsertURL := Value;
end;

procedure TConfig.SetIsOffLineMode(const Value: Boolean);
begin
  FIsOffLineMode := Value;
end;

procedure TConfig.SetKoteHan(const Value: string);
begin
  FKoteHan := Value;
end;

procedure TConfig.SetKoteMail(const Value: string);
begin
  FKoteMail := Value;
end;

procedure TConfig.SetMailListFile(const Value: string);
begin
  FMailListFile := Value;
end;

procedure TConfig.SetMainFormHeight(const Value: Integer);
begin
  FMainFormHeight := Value;
end;

procedure TConfig.SetMainFormLeft(const Value: Integer);
begin
  FMainFormLeft := Value;
end;

procedure TConfig.SetMainFormStyleSub1(const Value: Boolean);
begin
  FMainFormStyleSub1 := Value;
end;

procedure TConfig.SetMainFormStyleSub2(const Value: Boolean);
begin
  FMainFormStyleSub2 := Value;
end;

procedure TConfig.SetMainFormStyleSub3(const Value: Boolean);
begin
  FMainFormStyleSub3 := Value;
end;

procedure TConfig.SetMainFormStyleType3(const Value: Boolean);
begin
  FMainFormStyleType3 := Value;
end;

procedure TConfig.SetMainFormTop(const Value: Integer);
begin
  FMainFormTop := Value;
end;

procedure TConfig.SetMainFormWidth(const Value: Integer);
begin
  FMainFormWidth := Value;
end;

procedure TConfig.SetMainFormWindowState(const Value: Integer);
begin
  FMainFormWindowState := Value;
end;

procedure TConfig.SetMultiLineTab(const Value: Boolean);
begin
  FMultiLineTab := Value;
end;

procedure TConfig.SetNameListFile(const Value: string);
begin
  FNameListFile := Value;
end;

procedure TConfig.SetNewResHtml(const Value: string);
begin
  FNewResHtml := Value;
end;

procedure TConfig.SetPassword(const Value: string);
begin
  FPassword := Value;
end;

procedure TConfig.SetReadProxy(const Value: string);
begin
  FReadProxy := Value;
end;

procedure TConfig.SetReadProxyUse(const Value: Boolean);
begin
  FReadProxyUse := Value;
end;

procedure TConfig.SetResHtml(const Value: string);
begin
  FResHtml := Value;
end;

procedure TConfig.SetSavePassword(const Value: boolean);
begin
  FSavePassword := Value;
end;

procedure TConfig.SetSessionID(const Value: string);
begin
  FSessionID := Value;
end;

procedure TConfig.SetTopicListColorUse(const Value: Boolean);
begin
  FTopicListColorUse := Value;
end;

procedure TConfig.SetTopicListFavoriteColor(const Value: TColor);
begin
  FTopicListFavoriteColor := Value;
end;

procedure TConfig.SetTopicListNewMesColor(const Value: TColor);
begin
  FTopicListNewMesColor := Value;
end;

procedure TConfig.SetTopicListNewTopicColor(const Value: TColor);
begin
  FTopicListNewTopicColor := Value;
end;

procedure TConfig.SetTopicListNoNewMesColor(const Value: TColor);
begin
  FTopicListNoNewMesColor := Value;
end;

procedure TConfig.SetTopicListNotGotColor(const Value: TColor);
begin
  FTopicListNotGotColor := Value;
end;

procedure TConfig.SetTopicListViewColumnFontSize(const Value: Integer);
begin
  FTopicListViewColumnFontSize := Value;
end;

procedure TConfig.SetTopicListViewColumnOrders(const Value: string);
begin
  FTopicListViewColumnOrders := Value;
end;

procedure TConfig.SetTopicListViewColumnPadding(const Value: Integer);
begin
  FTopicListViewColumnPadding := Value;
end;

procedure TConfig.SetTopicListViewColumnWidths(const Value: string);
begin
  FTopicListViewColumnWidths := Value;
end;

procedure TConfig.SetTopicListViewGridLines(const Value: boolean);
begin
  FTopicListViewGridLines := Value;
end;

procedure TConfig.SetTopicListViewHeight(const Value: Integer);
begin
  FTopicListViewHeight := Value;
end;

procedure TConfig.SetTopicListViewWidth(const Value: Integer);
begin
  FTopicListViewWidth := Value;
end;

procedure TConfig.SetUseDefaultBrowser(const Value: Boolean);
begin
  FUseDefaultBrowser := Value;
end;

procedure TConfig.SetUserAgent(const Value: string);
begin
  FUserAgent := Value;
end;

procedure TConfig.SetUserId(const Value: string);
begin
  FUserId := Value;
end;

procedure TConfig.SetViewLimit(const Value: Integer);
begin
  FViewLimit := Value;
end;

procedure TConfig.SetWriteFormHeight(const Value: Integer);
begin
  FWriteFormHeight := Value;
end;

procedure TConfig.SetWriteFormLeft(const Value: Integer);
begin
  FWriteFormLeft := Value;
end;

procedure TConfig.SetWriteFormTop(const Value: Integer);
begin
  FWriteFormTop := Value;
end;

procedure TConfig.SetWriteFormWidth(const Value: Integer);
begin
  FWriteFormWidth := Value;
end;

procedure TConfig.SetWriteProxy(const Value: String);
begin
  FWriteProxy := Value;
end;

procedure TConfig.SetWriteProxyUse(const Value: Boolean);
begin
  FWriteProxyUse := Value;
end;

//  \bh

constructor TConfig.Create(IniPath: string);
begin
  FOptionIniPath := IniPath;
end;

procedure TConfig.ReadOption;
var
  OptionIni : TIniFile;
  strPath   : string;
begin

  OptionIni      := TIniFile.Create(FOptionIniPath);

  // Main
  FBoardListUrl  := OptionIni.ReadString(SEC_MAIN, KEY_BOARDLISTURL, 'http://www6.ocn.ne.jp/~mirv/2chmenu.html');
  FViewLimit     := OptionIni.ReadInteger(SEC_MAIN, KEY_VIEWLIMIT, 50);
  FDefaultSage   := OptionIni.ReadBool(SEC_MAIN, KEY_DEFAULTSAGE, false);
  FBrowserType   := TBrowserType(OptionIni.ReadInteger(SEC_MAIn, KEY_BROWSERTYPE, 0));
  FUserAgent     := OptionIni.ReadString(SEC_MAIN, KEY_USERAGENT, APP_USERAGENT);
  FAlwaysNewTab  := OptionIni.ReadBool(SEC_MAIN, KEY_ALWAYSNEWTAB, false);
  FMultiLineTab  := OptionIni.ReadBool(SEC_MAIN, KEY_MULTILINETAB, false);
  FAutoFocus     := OptionIni.ReadBool(SEC_MAIN, KEY_AUTOFOCUS, true);

  // Proxy
  FWriteProxyUse := OptionIni.ReadBool(  SEC_PROXY, KEY_WRITEPROXYUSE, false);
  FWriteProxy    := OptionIni.ReadString(SEC_PROXY, KEY_WRITEPROXY,    '');
  FReadProxyUse  := OptionIni.ReadBool(  SEC_PROXY, KEY_READPROXYUSE,  false);
  FReadProxy     := OptionIni.ReadString(SEC_PROXY, KEY_READPROXY,     '');

  // MainForm Layout
  FMainFormWindowState := OptionIni.ReadInteger(SEC_MAINFORM, KEY_WINDOWSTATE, Integer(wsNormal));
  FMainFormWidth       := OptionIni.ReadInteger(SEC_MAINFORM, KEY_WIDTH,  600);
  FMainFormHeight      := OptionIni.ReadInteger(SEC_MAINFORM, KEY_HEIGHT, 500);
  FMainFormLeft        := OptionIni.ReadInteger(SEC_MAINFORM, KEY_LEFT,   10);
  FMainFormTop         := OptionIni.ReadInteger(SEC_MAINFORM, KEY_TOP,    10);
  FMainFormStyleType3  := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLETYPE3, false);
  FMainFormStyleSub1   := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLESUB1,  false);
  FMainFormStyleSub2   := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLESUB2,  false);
  FMainFormStyleSub3   := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLESUB3,  false);
  FBoardListBoxWidth   := OptionIni.ReadInteger(SEC_BOARDLISTBOX,  KEY_WIDTH,  120);
  FBoardListNoColor    := OptionIni.ReadBool(SEC_BOARDLISTBOX, KEY_NoColor, false);
  FBoardListOneCategory:= OptionIni.ReadBool(SEC_BOARDLISTBOX, KEY_ONECATEGORY, False);
  FTopicListViewWidth  := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_WIDTH,  300);
  FTopicListViewHeight := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_HEIGHT, 100);
  FTopicListViewColumnOrders := OptionIni.ReadString(SEC_TOPICLISTVIEW, KEY_COLUMNORDERS, '');
  FTopicListViewColumnWidths := OptionIni.ReadString(SEC_TOPICLISTVIEW, KEY_COLUMNWIDTHS, '');
  FTopicListViewColumnPadding := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_COLUMNPADDING, 2); 
  FTopicListViewColumnFontSize := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_COLUMNFONTSIZE, 9); 
  FTopicListViewGridLines      := OptionIni.ReadBool   (SEC_TOPICLISTVIEW, KEY_GRIDLINES, false);
  FCoolBarBandId             := OptionIni.ReadString(SEC_COOLBAR, KEY_BANDID, '');
  FCoolBarBandWidth          := OptionIni.ReadString(SEC_COOLBAR, KEY_BANDWIDTH, '');
  FCoolBarBandBreak          := OptionIni.ReadString(SEC_COOLBAR, KEY_BANDBREAK, '');

  // OuEUݒ 
  FUseDefaultBrowser := OptionIni.ReadBool  (SEC_BROWSER, KEY_USEDEFBROWSER, True); 
  FBrowserPath       := OptionIni.ReadString(SEC_BROWSER, KEY_BROWSERPATH,   ''); 
  FInsertURL         := OptionIni.ReadString(SEC_BROWSER, KEY_INSERTURL,     '');

  // wb_pHTML
  strPath := AppPath(FILE_HEADERHTML);
  if FileExists(strPath) = true then
    FHeaderHtml := GetFile(strPath)
  else
    FHeaderHtml := '<html lang="ja"><body><font face="lr oSVbN"><dl>';

  // X\pHTML
  strPath := AppPath(FILE_RESHTML);
  if FileExists(strPath) = true then
    FResHtml := GetFile(strPath)
  else
    FResHtml := '<dt>&NUMBER OF<font color="forestgreen">&MAILNAME</font> eF&DATE</dt><dd>&MESSAGE<BR></dd><br>';

  // VX\pHTML
  strPath := AppPath(FILE_NEWRESHTML);
  if FileExists(strPath) = true then
    FNewResHtml := GetFile(strPath)
  else
    FNewResHtml := '<dt><b>&NUMBER</b> OF<font color="forestgreen">&MAILNAME</font> eF&DATE</dt><dd>&MESSAGE<BR></dd><br>';

  // Dolib֘A
  FAutoLogin    := OptionIni.ReadBool  (SEC_LOGIN, KEY_AUTOLOGIN,    false);
  FUserId       := Decrypt(OptionIni.ReadString(SEC_LOGIN, KEY_USERID,  ''));
  FPassword     := Decrypt(OptionIni.ReadString(SEC_LOGIN, KEY_PASSWORD,''));
  FSavePassword := OptionIni.ReadBool  (SEC_LOGIN, KEY_SAVEPASSWORD, false);

  // ݊֘A
  FNameListFile    := OptionIni.ReadString(SEC_WRITEFORM, KEY_NAMELIST, FILE_NAMELIST);
  FMailListFile    := OptionIni.ReadString(SEC_WRITEFORM, KEY_MAILLIST, FILE_MAILLIST);
  FWriteFormWidth  := OptionIni.ReadInteger(SEC_WRITEFORM, KEY_WIDTH,  450);
  FWriteFormHeight := OptionIni.ReadInteger(SEC_WRITEFORM, KEY_HEIGHT, 370);
  FWriteFormLeft   := OptionIni.ReadInteger(SEC_WRITEFORM, KEY_LEFT,   385);
  FWriteFormTop    := OptionIni.ReadInteger(SEC_WRITEFORM, KEY_TOP,    180);
  FKoteHan         := OptionIni.ReadString (SEC_WRITEFORM, KEY_KOTEHAN,  '');
  FKoteMail        := OptionIni.ReadString (SEC_WRITEFORM, KEY_KOTEMAIL, '');

  // XꗗF֘A
  FTopicListColorUse      := OptionIni.ReadBool   (SEC_TOPICLISTVIEW, KEY_USECOLOR,   True);
  FTopicListNotGotColor   := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLNOTGOT,   clBlack);
  FTopicListFavoriteColor := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLFAVORITE, clBlack);
  FTopicListNewMesColor   := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLNEWMES,   16711680);
  FTopicListNoNewMesColor := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLNONEWMES, clBlack);
  FTopicListNewTopicColor := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLNEWTOPIC, 4227327);

  OptionIni.Free;
end;

procedure TConfig.WriteOption;
var
  OptionIni : TIniFile;
begin

  OptionIni := TIniFile.Create(FOptionIniPath);

  // Main
  OptionIni.WriteString(SEC_MAIN, KEY_BOARDLISTURL, FBoardListUrl);
  OptionIni.WriteInteger(SEC_MAIN, KEY_VIEWLIMIT, FViewLimit);
  OptionIni.WriteBool(SEC_MAIN, KEY_DEFAULTSAGE, FDefaultSage);
  OptionIni.WriteInteger(SEC_MAIn, KEY_BROWSERTYPE, Integer(FBrowserType));
  //OptionIni.WriteString(SEC_MAIN, KEY_USERAGENT, FUserAgent);
  OptionIni.WriteBool(SEC_MAIN, KEY_ALWAYSNEWTAB, FAlwaysNewTab);
  OptionIni.WriteBool(SEC_MAIN, KEY_MULTILINETAB, FMultiLineTab);
  OptionIni.WriteBool(SEC_MAIN, KEY_AUTOFOCUS, FAutoFocus);

  // Proxy
  OptionIni.WriteBool(  SEC_PROXY, KEY_WRITEPROXYUSE, FWriteProxyUse);
  OptionIni.WriteString(SEC_PROXY, KEY_WRITEPROXY,    FWriteProxy);
  OptionIni.WriteBool(  SEC_PROXY, KEY_READPROXYUSE,  FReadProxyUse);
  OptionIni.WriteString(SEC_PROXY, KEY_READPROXY,     FReadProxy);

  // MainForm Layout
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_WINDOWSTATE, FMainFormWindowState);
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_WIDTH,       FMainFormWidth);
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_HEIGHT,      FMainFormHeight);
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_LEFT,        FMainFormLeft);
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_TOP,         FMainFormTop);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLETYPE3, FMainFormStyleType3);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLESUB1,  FMainFormStyleSub1);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLESUB2,  FMainFormStyleSub2);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLESUB3,  FMainFormStyleSub3);
  OptionIni.WriteInteger(SEC_BOARDLISTBOX,  KEY_WIDTH,        FBoardListBoxWidth);
  OptionIni.WriteBool(SEC_BOARDLISTBOX, KEY_NOCOLOR,    FBoardListNoColor); 
  OptionIni.WriteBool(SEC_BOARDLISTBOX, KEY_ONECATEGORY, FBoardListOneCategory);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_WIDTH,        FTopicListViewWidth);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_HEIGHT,       FTopicListViewHeight);
  OptionIni.WriteString (SEC_TOPICLISTVIEW, KEY_COLUMNWIDTHS, FTopicListViewColumnWidths);
  OptionIni.WriteString (SEC_TOPICLISTVIEW, KEY_COLUMNORDERS, FTopicListViewColumnOrders);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_COLUMNPADDING, FTopicListViewColumnPadding);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_COLUMNFONTSIZE, FTopicListViewColumnFontSize);
  OptionIni.WriteBool   (SEC_TOPICLISTVIEW, KEY_GRIDLINES, FTopicListViewGridLines);
  OptionIni.WriteString(SEC_COOLBAR, KEY_BANDID, FCoolBarBandId);
  OptionIni.WriteString(SEC_COOLBAR, KEY_BANDWIDTH, FCoolBarBandWidth);
  OptionIni.WriteString(SEC_COOLBAR, KEY_BANDBREAK, FCoolBarBandBreak);

  // OuEUݒ 
  OptionIni.WriteBool  (SEC_BROWSER, KEY_USEDEFBROWSER, FUseDefaultBrowser); 
  OptionIni.WriteString(SEC_BROWSER, KEY_BROWSERPATH,   FBrowserPath); 
  OptionIni.WriteString(SEC_BROWSER, KEY_INSERTURL,     FInsertURL);

  // Dolib֘A
  OptionIni.WriteBool  (SEC_LOGIN, KEY_AUTOLOGIN,    FAutoLogin);
  OptionIni.WriteString(SEC_LOGIN, KEY_USERID,       Crypt(FUserId));
  OptionIni.WriteBool  (SEC_LOGIN, KEY_SAVEPASSWORD, FSavePassword);
  if FSavePassword then
    OptionIni.WriteString(SEC_LOGIN, KEY_PASSWORD,   Crypt(FPassword))
  else
    OptionIni.DeleteKey(SEC_LOGIN, KEY_PASSWORD);

  // ݊֘A 
  OptionIni.WriteString(SEC_WRITEFORM, KEY_NAMELIST, FNameListFile); 
  OptionIni.WriteString(SEC_WRITEFORM, KEY_MAILLIST, FMailListFile); 
  OptionIni.WriteInteger(SEC_WRITEFORM, KEY_WIDTH,  FWriteFormWidth); 
  OptionIni.WriteInteger(SEC_WRITEFORM, KEY_HEIGHT, FWriteFormHeight); 
  OptionIni.WriteInteger(SEC_WRITEFORM, KEY_LEFT,   FWriteFormLeft); 
  OptionIni.WriteInteger(SEC_WRITEFORM, KEY_TOP,    FWriteFormTop);
  OptionIni.WriteString (SEC_WRITEFORM, KEY_KOTEHAN,  FKoteHan); 
  OptionIni.WriteString (SEC_WRITEFORM, KEY_KOTEMAIL, FKoteMail);

  // XꗗF֘A 
  OptionIni.WriteBool   (SEC_TOPICLISTVIEW, KEY_USECOLOR,   FTopicListColorUse); 
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLNOTGOT,   FTopicListNotGotColor); 
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLFAVORITE, FTopicListFavoriteColor); 
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLNEWMES,   FTopicListNewMesColor); 
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLNONEWMES, FTopicListNoNewMesColor); 
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLNEWTOPIC, FTopicListNewTopicColor);

  OptionIni.Free;
end;

procedure TConfig.SetProxy(Http: TAsyncHttp; ProxyString : string);
var
  host : string;
  port : integer;
begin
  ParseProxy(FReadProxy, host, port);
  Http.ProxyHost := host;
  Http.ProxyPort := port;
end;

procedure TConfig.InitReadProxy(Http: TAsyncHttp);
begin
  if FReadProxyUse then
    SetProxy(Http, FReadProxy);
end;

procedure TConfig.InitWriteProxy(Http: TAsyncHttp);
begin
  if FWriteProxyUse then
    SetProxy(Http, FWriteProxy);
end;

procedure TConfig.ParseProxy(ProxyString: string; out ProxyHost: string;
  out ProxyPort: Integer);
var
  proxyitem : TStringArray;
begin

  SetLength(proxyitem, 0);
  if ProxyString <> '' then
  begin
    proxyitem := Split(ProxyString, ':');
    if length(proxyitem) >= 2 then
      proxyport := StrToIntNeo(proxyitem[1])
    else
      proxyport := 8080;
    proxyhost := proxyitem[0];
  end;

end;

end.
