unit untDolibLogin;

// O[oϐ܂B

interface

uses
  Dialogs, 
  Dolib,
  untLoginForm;

type
  TDolibLogin = class
  private
    FSessionId : string;
    FUserAgent: string;
    procedure SetSessionId(const Value: string);
    procedure SetUserAgent(const Value: string);
  public
    property    SessionId : string read FSessionId write SetSessionId;
    property    UserAgent : string read FUserAgent write SetUserAgent;
    function    Login() : boolean;
    constructor Create;
    destructor  Destroy; override;
  end;

implementation

uses
  untGlobal, untConfig;

{ TDolibLogin }

constructor TDolibLogin.Create;
begin
end;

destructor TDolibLogin.Destroy;
begin

  inherited;
end;

// OC
function TDolibLogin.Login : boolean;
var
  Login     : TDolib;
  SessionId : string;
  UserAgent : string;
  ErrorMsg  : string;
  ErrorCode : integer;
  proxyhost : string;
  proxyport : integer;
begin

  result := false;

  Login := TDolib.Create;
  Login.UserName := gConfig.UserId;
  Login.Password := gConfig.Password;
  Login.ClientUA := APP_2chUA;

  {
  if gConfig.ReadProxyUse then
  begin
    gConfig.ParseProxy(gConfig.ReadProxy, proxyhost, proxyport);
    Login.ProxyAddress := proxyhost;
    Login.ProxyPort    := proxyport;
  end;
  }

  if  (not Login.Connect) then  begin
    ShowMessage(Login.ErrorMsg);
  end else begin
    SessionId := Login.SessionID;
    UserAgent := Login.UserAgent;
    ErrorMsg  := Login.ErrorMsg;
    ErrorCode := Login.ErrorCode;
    if ErrorCode <> 0 then
      ShowMessage(Login.ErrorMsg)
    else
      result := true;

    Login.Disconnect;
  end;
  Login.Free;

  if SessionId <> '' then
    gConfig.SessionId := SessionId;

  if UserAgent <> '' then
    gConfig.UserAgent := UserAgent;

end;

procedure TDolibLogin.SetSessionId(const Value: string);
begin
  FSessionId := Value;
end;

procedure TDolibLogin.SetUserAgent(const Value: string);
begin
  FUserAgent := Value;
end;

end.
