/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-khtml.h,v 1.2 2004/11/25 07:28:48 ikezoe Exp $
 */

#ifndef __KZ_KHTML_H__
#define __KZ_KHTML_H__

#include <gtk/gtk.h>
#include <gtk-khtml.h>
#include "kazehakase.h"
#include "kz-embed-event.h"
#include "kz-embed.h"

G_BEGIN_DECLS

#define KZ_TYPE_KHTML		(kz_khtml_get_type ())
#define KZ_KHTML(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_KHTML, KzKHTML))
#define KZ_KHTML_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_KHTML, KzKHTMLClass))
#define KZ_IS_KHTML(obj)	(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_KHTML))
#define KZ_IS_KHTML_CLASS(klass)(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_KHTML))
#define KZ_KHTML_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_KHTML, KzKHTMLClass))

typedef struct _KzKHTML		KzKHTML;
typedef struct _KzKHTMLClass	KzKHTMLClass;
typedef struct _KzKHTMLPriv	KzKHTMLPriv;

struct _KzKHTML
{
	/* embedding widget */
	GtkKHTML parent;

	gboolean  is_loading;

	KzKHTMLPriv *priv;
};

struct _KzKHTMLClass
{
	GtkKHTMLClass parent_class;
};


GType        kz_khtml_get_type              (void) G_GNUC_CONST;
GtkWidget   *kz_khtml_new                   (const gchar *url);

G_END_DECLS

#endif /* __KZ_KHTML_H__ */
