// -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-

//
//  Copyright (C) 2004 Hiroyuki Ikezoe
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//  This file is based on nsAboutProtocolHandler.h in Mozilla.
//
//  The Initial Developer of the Original Code is 
//  Netscape Communications Corporation.
//  Portions created by the Initial Developer are Copyright (C) 1998
//  the Initial Developer. All Rights Reserved.


#ifndef KzMozHistorySearchProtocolHandler_h___
#define KzMozHistorySearchProtocolHandler_h___

#include <nsIProtocolHandler.h>

#define KZ_HISTORY_SEARCH_PROTOCOLHANDLER_CID                  \
{ /* 9e3b6c90-2f75-11d3-8cd0-0060b0fc14a3 */         \
    0x9e3b6c90,                                      \
    0x2f75,                                          \
    0x11d3,                                          \
    {0x8c, 0xd0, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3} \
}

#define KZ_HISTORY_SEARCH_PROTOCOLHANDLER_CONTRACTID NS_NETWORK_PROTOCOL_CONTRACTID_PREFIX "history-search"
#define KZ_HISTORY_SEARCH_PROTOCOLHANDLER_CLASSNAME "'Kazehakases History Search protocol handler"
#define KZ_HISTORY_SEARCH_CONTRACTID "history-search"

class KzMozHistorySearchProtocolHandler : public nsIProtocolHandler
{
public:
    NS_DECL_ISUPPORTS

    // nsIProtocolHandler methods:
    NS_DECL_NSIPROTOCOLHANDLER

    // KzMozHistorySearchProtocolHandler methods:
    KzMozHistorySearchProtocolHandler();
    virtual ~KzMozHistorySearchProtocolHandler();

    static NS_METHOD
    Create(nsISupports *aOuter, REFNSIID aIID, void **aResult);

    nsresult Init();

protected:
};

#endif /* KzMozHistorySearchProtocolHandler_h___ */
