/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-proxy-folder.h,v 1.1.1.1 2005/03/27 12:58:27 poincare Exp $
 */

#ifndef __KZ_PROXY_FOLDER_H__
#define __KZ_PROXY_FOLDER_H__

#include "kz-bookmark.h"

G_BEGIN_DECLS

#define KZ_TYPE_PROXY_FOLDER			(kz_proxy_folder_get_type ())
#define KZ_PROXY_FOLDER(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_PROXY_FOLDER, KzProxyFolder))
#define KZ_PROXY_FOLDER_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_PROXY_FOLDER, KzProxyFolderClass))
#define KZ_IS_PROXY_FOLDER(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_PROXY_FOLDER))
#define KZ_IS_PROXY_FOLDER_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_PROXY_FOLDER))
#define KZ_PROXY_FOLDER_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_PROXY_FOLDER, KzProxyFolderClass))

#define KZ_TYPE_PROXY_FOLDER_TYPE		(kz_proxy_folder_type_get_type())

typedef struct _KzProxyFolder         KzProxyFolder;
typedef struct _KzProxyFolderClass    KzProxyFolderClass;

struct _KzProxyFolder
{
	KzBookmark parent;
};

struct _KzProxyFolderClass
{
	KzBookmarkClass parent_class;
};

GType	     kz_proxy_folder_get_type		(void) G_GNUC_CONST;
KzBookmark  *kz_proxy_folder_new		(KzBookmark *folder);

KzBookmark  *kz_proxy_folder_get_original_bookmark (KzProxyFolder *proxy,
						    KzBookmark    *bookmark);
KzBookmark  *kz_proxy_folder_get_original_bookmark_from_index
						   (KzProxyFolder *proxy,
						    gint           index);

G_END_DECLS

#endif /* __KZ_PROXY_FOLDER_H__ */
