/*
 *  Copyright (C) 2003, 2004 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: MozillaPrivate.cpp,v 1.1.1.1 2005/03/27 12:58:36 poincare Exp $
 */

/*
 * Based on MozillaPrivate.cpp in Epiphany-1.5.1.
 *  Copyright (C) 2003, 2004 Marco Pesenti Gritti
 */

#include "mozilla-config.h"

#include "config.h"

#include "MozillaPrivate.h"

#include <nsIPrintSettingsService.h>
#include <nsIServiceManager.h>
#include <nsISimpleEnumerator.h>
#include <nsISupportsPrimitives.h>
#include <nsPromiseFlatString.h>
#include <nsIPrintOptions.h>
#include <nsIContent.h>
#include <nsIDOMHTMLDocument.h>
#include <nsIDOMHTMLElement.h>
#ifdef HAVE_NSIPRESCONTEXT_H
#include <nsIPresContext.h>
#else
#include <nsPresContext.h>
#endif

/* IMPORTANT. Put only code that use internal mozilla strings (nsAutoString for
 * example) in this file. Note that you cannot use embed strings here,
 * the header inclusions will conflict.
 */

GList *
MozillaPrivate::GetPrinterList ()
{
	GList *printers = NULL;
	nsresult rv = NS_OK;

	nsCOMPtr<nsIPrintSettingsService> pss =
		do_GetService("@mozilla.org/gfx/printsettings-service;1", &rv);
	NS_ENSURE_SUCCESS(rv, nsnull);

	nsCOMPtr<nsIPrintOptions> po = do_QueryInterface(pss, &rv);
	NS_ENSURE_SUCCESS(rv, nsnull);

	nsCOMPtr<nsISimpleEnumerator> avPrinters;
	rv = po->AvailablePrinters(getter_AddRefs(avPrinters));
	NS_ENSURE_SUCCESS(rv, nsnull);

	PRBool more = PR_FALSE;

	for (avPrinters->HasMoreElements(&more);
	     more == PR_TRUE;
	     avPrinters->HasMoreElements(&more))
	{
		nsCOMPtr<nsISupports> i;
		rv = avPrinters->GetNext(getter_AddRefs(i));
		NS_ENSURE_SUCCESS(rv, nsnull);

		nsCOMPtr<nsISupportsString> printer = do_QueryInterface(i, &rv);
		NS_ENSURE_SUCCESS(rv, nsnull);

		nsAutoString data;
		rv = printer->GetData(data);
		NS_ENSURE_SUCCESS(rv, nsnull);

		printers = g_list_prepend (printers, g_strdup (NS_ConvertUCS2toUTF8 (data).get()));
	}

	return g_list_reverse (printers);
}

gboolean
MozillaPrivate::CreatePrintSettings (nsIPrintSettings **options)
{
	nsCOMPtr<nsIPrintOptions> printService;
	printService = do_GetService("@mozilla.org/gfx/printsettings-service;1");
	
	if (!printService) return FALSE;

	nsresult rv = printService->CreatePrintSettings(options);
	if (NS_FAILED(rv)) return FALSE;

	return TRUE;
}

gboolean
MozillaPrivate::GetRootRange (nsIDOMDocument *domDoc, nsIDOMRange *range)
{
	nsCOMPtr<nsIContent> rootContent;
	nsCOMPtr<nsIDOMHTMLDocument> htmlDoc = do_QueryInterface(domDoc);
	if (htmlDoc)
	{
		nsCOMPtr<nsIDOMHTMLElement> bodyElement;
		htmlDoc->GetBody(getter_AddRefs(bodyElement));
		rootContent = do_QueryInterface(bodyElement);
	}

        // to avoid segfault with DetailedPreference, 
        // return if rootContent is NULL.
	if (!rootContent)
		return FALSE;

	nsCOMPtr<nsIDOMNode> rootNode(do_QueryInterface(rootContent));

	PRUint32 childcount;
	childcount = rootContent->GetChildCount();
	
	range->SetStart(rootNode,0);
	range->SetEnd(rootNode,childcount);

	return TRUE;
}

gboolean
MozillaPrivate::GetSelectedRange (nsIDOMDocument *domDoc,
				  nsIDOMRange *range,
				  nsISelection *selection,
				  gboolean backward)
{
	nsCOMPtr<nsIContent> rootContent;
	nsCOMPtr<nsIDOMHTMLDocument> htmlDoc = do_QueryInterface(domDoc);
	if (htmlDoc)
	{
		nsCOMPtr<nsIDOMHTMLElement> bodyElement;
		htmlDoc->GetBody(getter_AddRefs(bodyElement));
		rootContent = do_QueryInterface(bodyElement);
	}

        // to avoid segfault with DetailedPreference, 
        // return if rootContent is NULL.
	if (!rootContent)
		return FALSE;

	// Get root content node
	nsCOMPtr<nsIDOMNode> rootNode(do_QueryInterface(rootContent));

	PRUint32 childcount;
	childcount = rootContent->GetChildCount();
	
	if (backward)
	{
		if (selection)
		{
			nsCOMPtr<nsIDOMNode> endNode;
			PRInt32 endOffset;
			selection->CollapseToStart();
			selection->GetAnchorNode(getter_AddRefs(endNode));
			selection->GetAnchorOffset(&endOffset);
	
			range->SetEnd(endNode, endOffset);
		}
		else
		{
			range->SetEnd(rootNode, childcount);
		}
		range->SetStart(rootNode, 0);
	}
	else
	{
		if (selection)
		{
			nsCOMPtr<nsIDOMNode> endNode;
			PRInt32 endOffset;
			selection->GetAnchorNode(getter_AddRefs(endNode));
			selection->GetAnchorOffset(&endOffset);
	
			range->SetStart(endNode, endOffset + 1);
		}
		else
		{
			range->SetStart(rootNode, 0);
		}
		range->SetEnd(rootNode, childcount);
	}

	return TRUE;
}

gboolean
MozillaPrivate::SetZoomOnDocShell (float aZoom, nsIDocShell *DocShell)
{
#ifdef HAVE_NSIPRESCONTEXT_H
	nsCOMPtr<nsIPresContext> PresContext;
#else
	nsCOMPtr<nsPresContext> PresContext;
#endif
	nsresult rv = DocShell->GetPresContext (getter_AddRefs(PresContext));
	if (NS_FAILED(rv) || !PresContext) return FALSE;

	nsIDeviceContext *DeviceContext(nsnull);
	DeviceContext = PresContext->DeviceContext();
	if (!DeviceContext) return FALSE;

	rv = DeviceContext->SetTextZoom (aZoom);

	if NS_FAILED(rv) return FALSE;
	
	return TRUE;
}

