// -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-

//
//  Copyright (C) 2004 Hiroyuki Ikezoe
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kz-mozdownloader.h"
#include <glib/gi18n.h>

#include "kazehakase.h"
#include "gobject-utils.h"
#include "kz-mozprogresslistener.h"

struct _KzMozDownloaderPrivate
{
	KzMozProgressListener *mProgress;
};

static void kz_moz_downloader_class_init    (KzMozDownloaderClass *klass);
static void kz_moz_downloader_init          (KzMozDownloader *kzdl);
static void kz_moz_downloader_dispose       (GObject    *object);
static void kz_moz_downloader_finalize      (GObject    *object);

static gint kz_moz_downloader_get_percent   (KzDownloader *downloader);
static void kz_moz_downloader_cancel        (KzDownloader *downloader);

static KzDownloaderClass *parent_class = NULL;

KZ_OBJECT_GET_TYPE(kz_moz_downloader, "KzMozDownloader", KzMozDownloader,
		   kz_moz_downloader_class_init, kz_moz_downloader_init,
		   KZ_TYPE_DOWNLOADER)


static void
kz_moz_downloader_class_init (KzMozDownloaderClass *klass)
{
	GObjectClass *object_class;
	KzDownloaderClass *dl_class;

	parent_class    = (KzDownloaderClass *) g_type_class_peek_parent (klass);

	object_class    = (GObjectClass *) klass;
	dl_class        = (KzDownloaderClass *) klass;

	// GObject
	object_class->dispose  = kz_moz_downloader_dispose;
	object_class->finalize = kz_moz_downloader_finalize;

	dl_class->kz_downloader_get_percent = kz_moz_downloader_get_percent;
	dl_class->kz_downloader_cancel      = kz_moz_downloader_cancel;
}


static void
kz_moz_downloader_init (KzMozDownloader *kzdl)
{
	kzdl->priv = g_new0(KzMozDownloaderPrivate, 1);
	
	kzdl->priv->mProgress = NULL;
}

KzMozDownloader *
kz_moz_downloader_new (gpointer aProgress, const gchar *filename)
{
	KzMozDownloader *kzdl;

	kzdl = KZ_MOZ_DOWNLOADER(
		g_object_new(KZ_TYPE_MOZ_DOWNLOADER,
			     "filename", filename,
			     NULL));

	kzdl->priv->mProgress = (KzMozProgressListener*)aProgress;

	return kzdl;
}

static void
kz_moz_downloader_dispose (GObject *object)
{
	KzMozDownloader *kzdl = KZ_MOZ_DOWNLOADER(object);
	kzdl->priv->mProgress = NULL;

	if (G_OBJECT_CLASS (parent_class)->dispose)
		G_OBJECT_CLASS (parent_class)->dispose(object);
}


KZ_OBJECT_FINALIZE(kz_moz_downloader, KzMozDownloader)


static	gint
kz_moz_downloader_get_percent (KzDownloader *downloader)
{
	KzMozDownloader *kzdl;
	gint percent;
	
	g_return_val_if_fail(KZ_IS_MOZ_DOWNLOADER(downloader), -1);
	
	kzdl = KZ_MOZ_DOWNLOADER(downloader);

	kzdl->priv->mProgress->GetPercentComplete(&percent);

	return percent;
}

static void
kz_moz_downloader_cancel (KzDownloader *downloader)
{
	KzMozDownloader *kzdl;
	
	g_return_if_fail(KZ_IS_MOZ_DOWNLOADER(downloader));
	
	kzdl = KZ_MOZ_DOWNLOADER(downloader);

	kzdl->priv->mProgress->Cancel();
}
