/* gtkcellrendererprogress.h
 * Gaim is the legal property of its developers, whose names are too numerous
 * to list here.  Please refer to the COPYRIGHT file distributed with this
 * source distribution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * 2004-04-21 Takuro Ashie <ashie@homa.ne.jp>
 *
 *     * Taken from Gaim and replace "Gtk" prefix with "Kz".
 */

#ifndef __KZ_CELL_RENDERER_PROGRESS_H__
#define __KZ_CELL_RENDERER_PROGRESS_H__

#include <gtk/gtkcellrenderer.h>

G_BEGIN_DECLS

#define KZ_TYPE_CELL_RENDERER_PROGRESS			(kz_cell_renderer_progress_get_type())
#define KZ_CELL_RENDERER_PROGRESS(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), KZ_TYPE_CELL_RENDERER_PROGRESS, KzCellRendererProgress))
#define KZ_CELL_RENDERER_PROGRESS_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_CELL_RENDERER_PROGRESS, KzCellRendererProgressClass))
#define KZ_IS_CELL_PROGRESS_PROGRESS(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_CELL_RENDERER_PROGRESS))
#define KZ_IS_CELL_PROGRESS_PROGRESS_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_CELL_RENDERER_PROGRESS))
#define KZ_CELL_RENDERER_PROGRESS_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_CELL_RENDERER_PROGRESS, KzCellRendererProgressClass))

typedef struct _KzCellRendererProgress      KzCellRendererProgress;
typedef struct _KzCellRendererProgressClass KzCellRendererProgressClass;

struct _KzCellRendererProgress
{
	GtkCellRenderer parent;

	gdouble   progress;
	gchar    *text;
	gboolean  text_set;
};

struct _KzCellRendererProgressClass
{
	GtkCellRendererClass parent_class;
};

GType            kz_cell_renderer_progress_get_type     (void) G_GNUC_CONST;
GtkCellRenderer *kz_cell_renderer_progress_new          (void);

G_END_DECLS

#endif /* __KZ_CELL_RENDERER_PROGRESS_H__ */
