/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Ryo SHIMIZU
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_COPY_FORMAT_DIALOG_H__
#define __KZ_COPY_FORMAT_DIALOG_H__

#include <gtk/gtk.h>

#include "kz-window.h"

G_BEGIN_DECLS

#define KZ_TYPE_COPY_FORMAT_DIALOG		   (kz_copy_format_dialog_get_type ())
#define KZ_COPY_FORMAT_DIALOG(obj)		   (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_COPY_FORMAT_DIALOG, KzCopyFormatDialog))
#define KZ_COPY_FORMAT_DIALOG_CLASS(klass)	   (G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_COPY_FORMAT_DIALOG, KzCopyFormatDialogClass))
#define KZ_IS_COPY_FORMAT_DIALOG(obj)	   (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_COPY_FORMAT_DIALOG))
#define KZ_IS_COPY_FORMAT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_COPY_FORMAT_DIALOG))
#define KZ_COPY_FORMAT_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_COPY_FORMAT_DIALOG, KzCopyFormatDialogClass))

typedef struct _KzCopyFormatDialog           KzCopyFormatDialog;
typedef struct _KzCopyFormatDialogClass      KzCopyFormatDialogClass;

typedef struct
{
        gchar *title;
        gchar *format;
} CopyFormat;

struct _KzCopyFormatDialog
{
	GtkDialog parent;

	KzWindow     *kz;

	GtkWidget    *scrolled_window;
	GtkTreeView  *tree_view;
	GtkListStore *list_store;
};

struct _KzCopyFormatDialogClass
{
	GtkDialogClass parent_class;
};

GType            kz_copy_format_dialog_get_type (void) G_GNUC_CONST;
GtkWidget       *kz_copy_format_dialog_new      (KzWindow   *kz);

G_END_DECLS

#endif /* __KZ_COPY_FORMAT_DIALOG_H__ */
