/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

#include "kazehakase.h"
#include "kz-langinfo.h"
#include <glib/gi18n.h>

/*
 *  These arrays are picked from epiphany-0.7 (src/prefs-diarlog.c).
 *  Copyright (C) 2000, 2001, 2002 Marco Pesenti Gritti
 */
const LanguageInfo 
languages [] =
{
	{ N_("Arabic (IBM-864)"),                  "IBM864",                LG_ARABIC },
	{ N_("Arabic (IBM-864-I)"),                "IBM864i",               LG_ARABIC },
	{ N_("Arabic (ISO-8859-6)"),               "ISO-8859-6",            LG_ARABIC },
	{ N_("Arabic (ISO-8859-6-E)"),             "ISO-8859-6-E",          LG_ARABIC },
	{ N_("Arabic (ISO-8859-6-I)"),             "ISO-8859-6-I",          LG_ARABIC },
	{ N_("Arabic (MacArabic)"),                "x-mac-arabic",          LG_ARABIC },
	{ N_("Arabic (Windows-1256)"),             "windows-1256",          LG_ARABIC },
	{ N_("Armenian (ARMSCII-8)"),              "armscii-8",             LG_OTHER },
	{ N_("Baltic (ISO-8859-13)"),              "ISO-8859-13",           LG_BALTIC },
	{ N_("Baltic (ISO-8859-4)"),               "ISO-8859-4",            LG_BALTIC },
	{ N_("Baltic (Windows-1257)"),             "windows-1257",          LG_BALTIC },
	{ N_("Celtic (ISO-8859-14)"),              "ISO-8859-14",           LG_OTHER },
	{ N_("Central European (IBM-852)"),        "IBM852",                LG_CENTRAL_EUROPEAN },
	{ N_("Central European (ISO-8859-2)"),     "ISO-8859-2",            LG_CENTRAL_EUROPEAN },
	{ N_("Central European (MacCE)"),          "x-mac-ce",              LG_CENTRAL_EUROPEAN },
	{ N_("Central European (Windows-1250)"),   "windows-1250",          LG_CENTRAL_EUROPEAN },
	{ N_("Chinese Simplified (GB18030)"),      "gb18030",               LG_CHINESE },
	{ N_("Chinese Simplified (GB2312)"),       "GB2312",                LG_CHINESE },
	{ N_("Chinese Simplified (GBK)"),          "x-gbk",                 LG_CHINESE },
	{ N_("Chinese Simplified (HZ)"),           "HZ-GB-2312",	    LG_CHINESE },
	{ N_("Chinese Simplified (ISO-2022-CN)"),  "ISO-2022-CN",           LG_CHINESE },
	{ N_("Chinese Simplified (Windows-936)"),  "windows-936",           LG_CHINESE },
	{ N_("Chinese Traditional (Big5)"),        "Big5",                  LG_CHINESE },
	{ N_("Chinese Traditional (Big5-HKSCS)"),  "Big5-HKSCS",	    LG_CHINESE },
	{ N_("Chinese Traditional (EUC-TW)"),      "x-euc-tw",              LG_CHINESE },
	{ N_("Croatian (Mac Croatian)"),           "x-mac-croatian",        LG_CENTRAL_EUROPEAN },
	{ N_("Cyrillic (IBM-855)"),                "IBM855",                LG_CYRILLIC },
	{ N_("Cyrillic (ISO-8859-5)"),             "ISO-8859-5",	    LG_CYRILLIC },
	{ N_("Cyrillic (ISO-IR-111)"),             "ISO-IR-111",            LG_CYRILLIC },
	{ N_("Cyrillic (KOI8-R)"),                 "KOI8-R",                LG_CYRILLIC },
	{ N_("Cyrillic (MacCyrillic)"),            "x-mac-cyrillic",        LG_CYRILLIC },
	{ N_("Cyrillic (Windows-1251)"),           "windows-1251",          LG_CYRILLIC },
	{ N_("Cyrillic/Russian (CP-866)"),         "IBM866",                LG_CYRILLIC },
	{ N_("Cyrillic/Ukrainian (KOI8-U)"),       "KOI8-U",                LG_CYRILLIC },
	{ N_("Cyrillic/Ukrainian (Mac Ukrainian)"),"x-mac-ukrainian",       LG_CYRILLIC },
	{ N_("English (US-ASCII)"),                "us-ascii",              LG_WESTERN },
	{ N_("Farsi (MacFarsi)"),                  "x-mac-farsi",           LG_OTHER },
	{ N_("Georgian (GEOSTD8)"),                "geostd8",               LG_OTHER },
	{ N_("Greek (ISO-8859-7)"),                "ISO-8859-7",            LG_GREEK },
	{ N_("Greek (MacGreek)"),                  "x-mac-greek",           LG_GREEK },
	{ N_("Greek (Windows-1253)"),              "windows-1253",          LG_GREEK },
	{ N_("Gujarati (MacGujarati)"),            "x-mac-gujarati",        LG_INDIAN },
	{ N_("Gurmukhi (Mac Gurmukhi)"),           "x-mac-gurmukhi",        LG_INDIAN },
	{ N_("Hebrew (IBM-862)"),                  "IBM862",                LG_HEBREW },
	{ N_("Hebrew (ISO-8859-8-E)"),             "ISO-8859-8-E",          LG_HEBREW },
	{ N_("Hebrew (ISO-8859-8-I)"),             "ISO-8859-8-I",          LG_HEBREW },
	{ N_("Hebrew (MacHebrew)"),                "x-mac-hebrew",          LG_HEBREW },
	{ N_("Hebrew (Windows-1255)"),             "windows-1255",          LG_HEBREW },
	{ N_("Hindi (Mac Devanagari)"),            "x-mac-devanagari",      LG_INDIAN },
	{ N_("Icelandic (MacIcelandic)"),          "x-mac-icelandic",       LG_OTHER },
	{ N_("Japanese (EUC-JP)"),                 "EUC-JP",                LG_JAPANESE },
	{ N_("Japanese (ISO-2022-JP)"),            "ISO-2022-JP",           LG_JAPANESE },
	{ N_("Japanese (Shift_JIS)"),              "Shift_JIS",             LG_JAPANESE },
	{ N_("Korean (EUC-KR)"),                   "EUC-KR",                LG_KOREAN },
	{ N_("Korean (ISO-2022-KR)"),              "ISO-2022-KR",           LG_KOREAN },
	{ N_("Korean (JOHAB)"),                    "x-johab",               LG_KOREAN },
	{ N_("Korean (UHC)"),                      "x-windows-949",         LG_KOREAN },
	{ N_("Nordic (ISO-8859-10)"),              "ISO-8859-10",           LG_OTHER },
	{ N_("Romanian (MacRomanian)"),            "x-mac-romanian",        LG_OTHER },
	{ N_("Romanian (ISO-8859-16)"),            "ISO-8859-16",           LG_OTHER },
	{ N_("South European (ISO-8859-3)"),       "ISO-8859-3",            LG_OTHER },
	{ N_("Thai (TIS-620)"),                    "TIS-620",               LG_OTHER },
	{ N_("Turkish (IBM-857)"),                 "IBM857",                LG_TURKISH },
	{ N_("Turkish (ISO-8859-9)"),              "ISO-8859-9",            LG_TURKISH },
	{ N_("Turkish (MacTurkish)"),              "x-mac-turkish",         LG_TURKISH },
	{ N_("Turkish (Windows-1254)"),            "windows-1254",          LG_TURKISH },
	{ N_("Unicode (UTF-7)"),                   "UTF-7",                 LG_UNICODE },
	{ N_("Unicode (UTF-8)"),                   "UTF-8",                 LG_UNICODE },
	{ N_("Unicode (UTF-16BE)"),                "UTF-16BE",              LG_UNICODE },
	{ N_("Unicode (UTF-16LE)"),                "UTF-16LE",              LG_UNICODE },
	{ N_("Unicode (UTF-32BE)"),                "UTF-32BE",              LG_UNICODE },
	{ N_("Unicode (UTF-32LE)"),                "UTF-32LE",              LG_UNICODE },
	{ N_("User Defined"),                      "x-user-defined",        LG_OTHER },
	{ N_("Vietnamese (TCVN)"),                 "x-viet-tcvn5712",       LG_VIETNAMESE },
	{ N_("Vietnamese (VISCII)"),               "VISCII",                LG_VIETNAMESE },
	{ N_("Vietnamese (VPS)"),                  "x-viet-vps",            LG_VIETNAMESE },
	{ N_("Vietnamese (Windows-1258)"),         "windows-1258",          LG_VIETNAMESE },
	{ N_("Visual Hebrew (ISO-8859-8)"),        "ISO-8859-8",            LG_HEBREW },
	{ N_("Western (IBM-850)"),                 "IBM850",                LG_WESTERN },
	{ N_("Western (ISO-8859-1)"),              "ISO-8859-1",            LG_WESTERN },
	{ N_("Western (ISO-8859-15)"),             "ISO-8859-15",           LG_WESTERN },
	{ N_("Western (MacRoman)"),                "x-mac-roman",           LG_WESTERN },
	{ N_("Western (Windows-1252)"),            "windows-1252",          LG_WESTERN },
	/* encodings without translatable names */
	{ "T.61-8bit",                             "T.61-8bit",             LG_OTHER },
	{ "x-imap4-modified-utf7",                 "x-imap4-modified-utf7", LG_UNICODE },
	{ "x-u-escaped",                           "x-u-escaped",           LG_OTHER }
};

const guint n_languages = G_N_ELEMENTS (languages);

const AcceptLanguageInfo
accept_languages [] =
{
	/**
	 * please translate like this: "<your language> (System setting)"
	 * Examples:
	 * "de"    translation: "Deutsch (Systemeinstellung)"
	 * "en_AU" translation: "English, Australia (System setting)" or
	 *                      "Australian English (System setting)"
	 */ 
	/* { N_("System language"), "system" }, */
	{ N_("Afrikaans"), "ak" },
	{ N_("Albanian"), "sq" },
	{ N_("Arabic"), "ar" },
	{ N_("Azerbaijani"), "az" },
	{ N_("Basque"), "eu" },
	{ N_("Breton"), "br" },
	{ N_("Bulgarian"), "bg" },
	{ N_("Byelorussian"), "be" },
	{ N_("Catalan"), "ca" },
	{ N_("Simplified Chinese"), "zh-cn" },
	{ N_("Traditional Chinese"), "zh-tw" },
	{ N_("Chinese"), "zh" },
	{ N_("Croatian"), "hr" },
	{ N_("Czech"), "cs" },
	{ N_("Danish"), "da" },
	{ N_("Dutch"), "nl" },
	{ N_("English"), "en" },
	{ N_("Esperanto"), "eo" },
	{ N_("Estonian"), "et" },
	{ N_("Faeroese"), "fo" },
	{ N_("Finnish"), "fi" },
	{ N_("French"), "fr" },
	{ N_("Galician"), "gl" },
	{ N_("German"), "de" },
	{ N_("Greek"), "el" },
	{ N_("Hebrew"), "he" },
	{ N_("Hungarian"), "hu" },
	{ N_("Icelandic"), "is" },
	{ N_("Indonesian"), "id" },
	{ N_("Irish"), "ga" },
	{ N_("Italian"), "it" },
	{ N_("Japanese"), "ja" },
	{ N_("Korean"), "ko" },
	{ N_("Latvian"), "lv" },
	{ N_("Lithuanian"), "lt" },
	{ N_("Macedonian"), "mk" },
	{ N_("Malay"), "ms" },
	{ N_("Norwegian/Nynorsk"), "nn" },
	{ N_("Norwegian/Bokmal"), "nb" },
	{ N_("Norwegian"), "no" },
	{ N_("Polish"), "pl" },
	{ N_("Portuguese"), "pt" },
	{ N_("Portuguese of Brazil"), "pt-br" },
	{ N_("Romanian"), "ro" },
	{ N_("Russian"), "ru" },
	{ N_("Scottish"), "gd" },
	{ N_("Serbian"), "sr" },
	{ N_("Slovak"), "sk" },
	{ N_("Slovenian"), "sl" },
	{ N_("Spanish"), "es" },
	{ N_("Swedish"), "sv" },
	{ N_("Tamil"), "ta" },
	{ N_("Turkish"), "tr" },
	{ N_("Ukrainian"), "uk" },
	{ N_("Vietnamese"), "vi" },
	{ N_("Walloon"), "wa" }
};

const guint n_accept_languages = G_N_ELEMENTS (accept_languages);

const EncodingAutodetectorInfo 
encoding_autodetectors[] =
{
	{ N_("Off"),			"" },
	{ N_("Chinese"),		"zh_parallel_state_machine" },
	{ N_("East asian"),		"cjk_parallel_state_machine" },
	{ N_("Japanese"),		"ja_parallel_state_machine" },
	{ N_("Korean"),			"ko_parallel_state_machine" },
	{ N_("Russian"),		"ruprob" },
	{ N_("Simplified Chinese"),	"zhcn_parallel_state_machine" },
	{ N_("Traditional Chinese"),	"zhtw_parallel_state_machine" },
	{ N_("Ukrainian"),		"ukprob" }
};

const guint n_encoding_autodetectors = G_N_ELEMENTS (encoding_autodetectors);
