/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "egg-entryaction.h"

#include <gtk/gtkentry.h>

#include "gobject-utils.h"
#include "egg-toolitem.h"
#include "intl.h"

enum {
	VALUE_CHANGED,
	LAST_SIGNAL
};

enum {
  PROP_0,
  PROP_TEXT,
};

static void       egg_entry_action_init       (EggEntryAction *action);
static void       egg_entry_action_class_init (EggEntryActionClass *class);

static GtkWidget *create_menu_item            (EggAction *action);
static GtkWidget *create_tool_item            (EggAction *action);

static void       connect_proxy               (EggAction *action,
					       GtkWidget *proxy);
static void       disconnect_proxy            (EggAction *action,
					       GtkWidget *proxy);

static GObjectClass *parent_class = NULL;
static guint         action_signals[LAST_SIGNAL] = { 0 };

KZ_OBJECT_GET_TYPE(egg_entry_action, "EggEntryAction", EggEntryAction,
		   egg_entry_action_class_init, egg_entry_action_init,
		   EGG_TYPE_ACTION)

static void
egg_entry_action_class_init (EggEntryActionClass *class)
{
	GObjectClass *object_class;
	EggActionClass *action_class;

	parent_class = g_type_class_peek_parent(class);
	object_class = G_OBJECT_CLASS(class);
	action_class = EGG_ACTION_CLASS(class);

	action_class->create_menu_item = create_menu_item;
	action_class->create_tool_item = create_tool_item;
	action_class->connect_proxy    = connect_proxy;
	action_class->disconnect_proxy = disconnect_proxy;

	action_class->toolbar_item_type = EGG_TYPE_TOOL_ITEM;
}

static void
egg_entry_action_init (EggEntryAction *action)
{
}

static GtkWidget *
create_menu_item (EggAction *action)
{
	g_warning ("EggEntryActionClass: create_menu_item is not implemented yet.");
	return (*EGG_ACTION_GET_CLASS(action)->create_tool_item) (action);
}

static void
cb_entry_changed(GtkEditable *editable, EggAction *action)
{
}

static void
cb_entry_activate(GtkEntry *entry, EggAction *action)
{
	g_return_if_fail(GTK_IS_ENTRY(entry));
	g_return_if_fail(EGG_IS_ENTRY_ACTION(action));

	egg_action_activate(action);
}

static GtkWidget *
create_tool_item (EggAction *action)
{
	GtkWidget *widget, *combo;

	widget = (*EGG_ACTION_CLASS(parent_class)->create_tool_item) (action);
	egg_tool_item_set_expandable (EGG_TOOL_ITEM(widget), TRUE);

	combo = gtk_combo_new();
	gtk_container_add(GTK_CONTAINER(widget), combo);
	gtk_combo_disable_activate(GTK_COMBO(combo));
	gtk_widget_show(combo);

	return widget;
}

static GtkEntry *
get_entry_widget(GtkWidget *proxy)
{
	GtkEntry *entry = NULL;

	g_return_val_if_fail(proxy, NULL);

	if (GTK_IS_MENU_ITEM (proxy))
	{
		g_warning ("EggEntryActionClass: connect proxy for menu item is not implemented yet.");
	}	
	else if (EGG_IS_TOOL_ITEM (proxy))
	{
		if (GTK_IS_ENTRY(GTK_BIN(proxy)->child))
		{
			entry = GTK_ENTRY(GTK_BIN(proxy)->child);
		}
		else if (GTK_IS_COMBO(GTK_BIN(proxy)->child))
		{
			entry = GTK_ENTRY(GTK_COMBO(GTK_BIN(proxy)->child)->entry);
		}
	}
	else if (GTK_IS_ENTRY (proxy))
	{
		entry = GTK_ENTRY(proxy);
	}
	else if (GTK_IS_COMBO (proxy))
	{
		entry = GTK_ENTRY(GTK_COMBO(proxy)->entry);
	}

	return entry;
}

static void
connect_proxy (EggAction *action, GtkWidget *proxy)
{
	EggEntryAction *entry_action;
	GtkEntry *entry = NULL;

	entry_action = EGG_ENTRY_ACTION (action);

	entry = get_entry_widget(proxy);
	if (entry) {
		g_signal_connect(entry, "changed",
				 G_CALLBACK(cb_entry_changed), action);
		g_signal_connect(entry, "activate",
				 G_CALLBACK(cb_entry_activate), action);
	}

	(* EGG_ACTION_CLASS (parent_class)->connect_proxy) (action, proxy);
}

static void
disconnect_proxy (EggAction *action, GtkWidget *proxy)
{
	EggEntryAction *entry_action;
	GtkEntry *entry;

	entry_action = EGG_ENTRY_ACTION (action);

	entry = get_entry_widget(proxy);
	if (entry) {
		g_signal_handlers_disconnect_by_func
			(entry,  G_CALLBACK(cb_entry_changed), action);
		g_signal_handlers_disconnect_by_func
			(entry, G_CALLBACK(cb_entry_activate), action);
	}

	(* EGG_ACTION_CLASS (parent_class)->disconnect_proxy) (action, proxy);
}

#warning FIXME
void
egg_entry_action_set_text (EggEntryAction *action,
			   const gchar *text)
{
	GSList *node;

	g_return_if_fail(EGG_IS_ENTRY_ACTION(action));

	for (node = EGG_ACTION(action)->proxies; node; node = g_slist_next(node))
	{
		GtkEntry *entry = get_entry_widget(node->data);
		if (entry)
			gtk_entry_set_text(entry, text);
	}
}

#warning FIXME
const gchar *
egg_entry_action_get_text (EggEntryAction *action)
{
	GSList *node;

	g_return_val_if_fail(EGG_IS_ENTRY_ACTION(action), NULL);

	for (node = EGG_ACTION(action)->proxies; node; node = g_slist_next(node))
	{
		GtkEntry *entry = get_entry_widget(node->data);
		if (entry)
			return gtk_entry_get_text(entry);
	}

	return NULL;
}

