/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-mozprogresslistener.h"


KzMozProgressListener::KzMozProgressListener(void)
{
	mOwner = nsnull;
}


KzMozProgressListener::~KzMozProgressListener()
{
}

NS_IMPL_ISUPPORTS2(KzMozProgressListener,
		   nsIWebProgressListener,
		   nsISupportsWeakReference)

nsresult
KzMozProgressListener::Init(KzMozEmbed *aOwner)
{
	mOwner = aOwner;
	return NS_OK;
}


NS_IMETHODIMP
KzMozProgressListener::OnStateChange(nsIWebProgress *aWebProgress,
				     nsIRequest     *aRequest,
				     PRUint32        aStateFlags,
				     nsresult        aStatus)
{
	return NS_OK;
}

NS_IMETHODIMP
KzMozProgressListener::OnProgressChange(nsIWebProgress *aWebProgress,
					nsIRequest     *aRequest,
					PRInt32         aCurSelfProgress,
					PRInt32         aMaxSelfProgress,
					PRInt32         aCurTotalProgress,
					PRInt32         aMaxTotalProgress)
{
	return NS_OK;
}

NS_IMETHODIMP
KzMozProgressListener::OnLocationChange(nsIWebProgress *aWebProgress,
					nsIRequest     *aRequest,
					nsIURI         *aLocation)
{
	return NS_OK;
}

NS_IMETHODIMP
KzMozProgressListener::OnStatusChange(nsIWebProgress  *aWebProgress,
				      nsIRequest      *aRequest,
				      nsresult         aStatus,
				      const PRUnichar *aMessage)
{
	return NS_OK;
}

NS_IMETHODIMP
KzMozProgressListener::OnSecurityChange(nsIWebProgress *aWebProgress,
					nsIRequest     *aRequest,
					PRUint32         aState)
{
	return NS_OK;
}

