set(setuptools tar xcursorgen)
foreach(tool ${setuptools})
    string(TOUPPER ${tool} uppertool)
    find_program(${uppertool} ${tool})
    if(NOT ${uppertool})
        message(SEND_ERROR "${tool} was not found")
    endif()
endforeach()

# For a given cursor, this macro defines a variable ${cursor}_inputs that contains
# a list of the necessary png files.
macro(set_dependencies cursor)
    file(READ ${CONFIGDIR}/${cursor}.in config_contents)
    string(REPLACE "\n" ";" config_contents ${config_contents})
    set(${cursor}_inputs)
    foreach(png ${config_contents})
        string(REGEX REPLACE "[0-9]* [0-9]* [0-9]* " "" png ${png})
        string(REGEX REPLACE "[.]png [0-9]*$" ".png" png ${png})
        list(APPEND ${cursor}_inputs ${png})
    endforeach(png)
endmacro(set_dependencies)

set(CURSORS)
foreach(config ${CONFIGS})
    string(REGEX REPLACE ".*/" "" cursor ${config})
    string(REGEX REPLACE "[.]in" "" cursor ${cursor})
    list(APPEND CURSORS ${cursor})
    set_dependencies(${cursor})
endforeach(config)