/*
 * This file was generated by dbusxml2cpp version 0.6
 * Command line was: dbusxml2cpp -m -p kdirnotify -- org.kde.KDirNotify.xml
 *
 * dbusxml2cpp is Copyright (C) 2006 Trolltech AS. All rights reserved.
 *
 * This is an auto-generated file.
 * Do not edit! All changes made to it will be lost.
 */

#ifndef KDIRNOTIFY_H_268161151672021
#define KDIRNOTIFY_H_268161151672021

#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusAbstractInterface>
#include <kio/kio_export.h>

/**
 * \class OrgKdeKDirNotifyInterface kdirnotify.h KDirNotify
 *
 * \brief Proxy class for interface org.kde.KDirNotify.
 *
 * KDirNotify can be used to inform KIO about changes in real or virtual file systems.
 * Classes like KDirModel connect to the signals as in the following example to
 * be able to keep caches up-to-date.
 *
 * \code
 * kdirnotify = new org::kde::KDirNotify(QString(), QString(), QDBusConnection::sessionBus(), this);
 * connect(kdirnotify, SIGNAL(FileRenamed(QString,QString)), SLOT(slotFileRenamed(QString,QString)));
 * connect(kdirnotify, SIGNAL(FilesAdded(QString)), SLOT(slotFilesAdded(QString)));
 * connect(kdirnotify, SIGNAL(FilesChanged(QStringList)), SLOT(slotFilesChanged(QStringList)));
 * connect(kdirnotify, SIGNAL(FilesRemoved(QStringList)), SLOT(slotFilesRemoved(QStringList)));
 * \endcode
 *
 * Especially noteworthy are the empty strings for both \p service and \p path. That
 * way the client will connect to signals emitted by any application.
 *
 * The second usage is to actually emit the signals. For that emitFileRenamed() and friends are
 * to be used.
 */
class KIO_EXPORT OrgKdeKDirNotifyInterface: public QDBusAbstractInterface
{
    Q_OBJECT
public:
    static inline const char *staticInterfaceName()
    { return "org.kde.KDirNotify"; }

public:
    /**
     * Create a new KDirNotify interface.
     *
     * \param service The service whose signals one wants to listed to. Use an empty
     * string to connect to all services/applications.
     * \param path The path to the D-Bus object whose signals one wants to listed to.
     * Use an empty string to connect to signals from all objects.
     * \param connection Typically QDBusConnection::sessionBus(), or
     * KDBusConnectionPool::threadConnection() in multithreaded apps.
     * \param parent The parent QObject.
     */
    OrgKdeKDirNotifyInterface(const QString &service, const QString &path, const QDBusConnection &connection, QObject *parent = 0);

    /**
     * Destructor.
     */
    ~OrgKdeKDirNotifyInterface();

public Q_SLOTS: // METHODS
Q_SIGNALS: // SIGNALS
    void FileRenamed(const QString &src, const QString &dst);
    void FileMoved(const QString &src, const QString &dst);
    void FilesAdded(const QString &directory);
    void FilesChanged(const QStringList &fileList);
    void FilesRemoved(const QStringList &fileList);
    void enteredDirectory(const QString &url);
    void leftDirectory(const QString &url);

public:
    static void emitFileRenamed(const QString &src, const QString &dst);
    static void emitFileMoved(const QString &src, const QString &dst);
    static void emitFilesAdded(const QString &directory);
    static void emitFilesChanged(const QStringList &fileList);
    static void emitFilesRemoved(const QStringList &fileList);
    static void emitEnteredDirectory(const QString &url);
    static void emitLeftDirectory(const QString &url);
};

namespace org {
  namespace kde {
    typedef ::OrgKdeKDirNotifyInterface KDirNotify;
  }
}
#endif
