/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.analysis;

import java.lang.reflect.Array;
import org.kikaineko.mock.framework.Import;
import org.kikaineko.source.util.JavaToken;

public class ClassNameResolver {
    private Import[] ims;
    private String packageName;

    public ClassNameResolver(String pack, Import[] ims) {
        this.packageName = pack;
        this.ims = ims;
    }

    private Class load(String pack, String clazz) {
        ClassLoader cl = this.getClass().getClassLoader();
        Class<?> cz = null;
        try {
            cz = pack.length() == 0 || pack.endsWith(".") ? cl.loadClass(String.valueOf(pack) + clazz) : cl.loadClass(String.valueOf(pack) + "." + clazz);
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        return cz;
    }

    public static Class getArrayClass(Class clazz) {
        Object o = Array.newInstance(clazz, 0);
        return o.getClass();
    }

    public Class getClazz(String name) {
        Class c = this.resolve(name);
        return c;
    }

    private Class resolve(String name) {
        try {
            Class<?> c = Class.forName(name);
            return c;
        }
        catch (Exception c) {
            if (JavaToken.isPremit(name)) {
                return JavaToken.getPremitClass(name);
            }
            try {
                Class c2 = null;
                int i = 0;
                while (i < this.ims.length) {
                    String tn = this.ims[i].getClassNmae();
                    if (tn.equals(name)) {
                        return this.getClass().getClassLoader().loadClass(String.valueOf(this.ims[i].getPackageName()) + name);
                    }
                    if (tn.equals("*") && (c2 = this.load(this.ims[i].getPackageName(), name)) != null) {
                        return c2;
                    }
                    ++i;
                }
                c2 = this.load(String.valueOf(this.packageName) + ".", name);
                if (c2 != null) {
                    return c2;
                }
                c2 = this.load("java.lang.", name);
                if (c2 != null) {
                    return c2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

