/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.analysis;

import org.kikaineko.mock.analysis.Variable;

class VariableTable {
    private Variable[] vars = new Variable[this.addLength];
    private int length = 0;
    private int addLength = 20;

    public void setLevel(String key, int level) {
        this.vars[this.indexOfVar(key)].setLevel(level);
    }

    public int getLevle(String key) {
        return this.vars[this.indexOfVar(key)].getLevel();
    }

    public boolean include(String key) {
        return this.indexOfVar(key) != -1;
    }

    private int indexOfVar(String key) {
        int i = 0;
        while (i < this.length()) {
            if (this.vars[i].getName().equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setType(String key, Class type) {
        this.vars[this.indexOfVar(key)].setType(type);
    }

    public Class getType(String key) {
        return this.vars[this.indexOfVar(key)].getType();
    }

    public void addByName(String key) {
        if (this.length() >= this.vars.length) {
            Variable[] v2 = new Variable[this.length() + this.addLength];
            System.arraycopy(this.vars, 0, v2, 0, this.length());
            this.vars = v2;
        }
        if (this.indexOfVar(key) == -1) {
            this.vars[this.length++] = new Variable(key);
        }
    }

    public void addVariable(String key, Class type) {
        this.addByName(key);
        this.setType(key, type);
    }

    public void addVariable(String key, Class type, int level) {
        this.addByName(key);
        this.setType(key, type);
        this.setLevel(key, level);
    }

    public int length() {
        return this.length;
    }

    public void setValAndLevel(String key, String val, int level) {
        int i = this.indexOfVar(key);
        this.vars[i].setValue(val);
        this.vars[i].setLevel(level);
    }

    public void setValAndLevel(String key, Object val, int level) {
        int i = this.indexOfVar(key);
        this.vars[i].setValue(val);
        this.vars[i].setLevel(level);
    }

    public void setVal(String key, String val) {
        this.vars[this.indexOfVar(key)].setValue(val);
    }

    public void setVal(String key, Object val) {
        this.vars[this.indexOfVar(key)].setValue(val);
    }

    public String getValToString(String key) {
        return this.vars[this.indexOfVar(key)].getValue().toString();
    }

    public Object getVal(String key) {
        return this.vars[this.indexOfVar(key)].getValue();
    }

    public boolean includeType(Class type) {
        int i = 0;
        while (i < this.length()) {
            if (this.vars[i].getType() == type) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Object clone() {
        VariableTable vt = new VariableTable();
        vt.vars = this.vars;
        vt.length = this.length;
        vt.addLength = this.addLength;
        return vt;
    }
}

