/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.runner;

import java.io.File;
import org.kikaineko.mock.analysis.Analyst;
import org.kikaineko.mock.analysis.SmallCompiler;
import org.kikaineko.mock.analysis.TestAnalyst;
import org.kikaineko.mock.framework.Filter;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.runner.Implementer;
import org.kikaineko.mock.runner.Runner;
import org.kikaineko.sourcescan.CodeReader;
import org.kikaineko.util.FileIO;

public class BaseRunner
implements Runner {
    private File target;

    public File targetFile() {
        return this.target;
    }

    protected void stetUp(File test) {
    }

    protected void tearDown() {
    }

    protected StringBuffer overWrite(StringBuffer sb) {
        if (this.target.exists()) {
            sb.append(System.getProperty("line.separator"));
            sb.append(System.getProperty("line.separator"));
            String[] codes = FileIO.getFileDatas(this.target);
            int i = 0;
            while (i < codes.length) {
                sb.append("//");
                sb.append(codes[i]);
                sb.append(System.getProperty("line.separator"));
                ++i;
            }
        }
        return sb;
    }

    protected Analyst analystFactory(Object input) {
        if (input instanceof File) {
            return new TestAnalyst(new CodeReader((File)input).getTokenArrayWithoutComment());
        }
        if (input instanceof TestAnalyst) {
            return new SmallCompiler(((Analyst)input).getTestClass(), ((Analyst)input).getTargetClass());
        }
        return null;
    }

    protected TargetClass filter(TargetClass tc) {
        return Filter.execute(tc);
    }

    public final StringBuffer doRun(File test) throws Exception {
        this.stetUp(test);
        StringBuffer dame = new StringBuffer();
        Analyst preAnalyst = this.analystFactory(test);
        preAnalyst.analyze();
        this.target = new File(test.getParentFile(), String.valueOf(preAnalyst.getTargetClass().getClassName()) + ".java");
        Analyst scom = this.analystFactory(preAnalyst);
        scom.analyze();
        TargetClass tc = this.filter(scom.getTargetClass());
        Implementer im = new Implementer(tc);
        File parent = test.getParentFile();
        this.target = new File(parent, im.getTargetFile().getName());
        this.tearDown();
        return this.overWrite(new StringBuffer(im.getCode()));
    }
}

