/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.runner;

import java.io.File;
import java.util.StringTokenizer;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.util.Version;
import org.kikaineko.source.util.JavaToken;

public class Implementer {
    private TargetClass tc;
    private String historyMethodName = "kikainekoHistoryAdd";
    private String historyFieldName = "kikainekoHistory";
    private String returnMethodName = "kikainekoReturn";
    private String usedClassesFieldName = "kikainekoUsedConcreteClasses";
    private String message1 = "//TODO To change.Mock Part Start ...";
    private String message2 = "//TODO To change.Mock Part End.";
    private StringBuffer code;

    public Implementer(TargetClass tc) {
        this.tc = tc;
        this.code = new StringBuffer();
        this.make();
    }

    public File getTargetFile() {
        String targetFileName = String.valueOf(this.tc.getPack().replace('.', '\\')) + "\\" + this.tc.getClassName() + ".java";
        return new File(targetFileName);
    }

    private void make() {
        this.head();
        this.body();
        this.historyAdd();
        this.returnMethod();
        this.usedClasses();
        this.footer();
    }

    public String getCode() {
        return this.code.toString();
    }

    private void usedClasses() {
        this.code.append("private static final Class[] ");
        this.code.append(this.usedClassesFieldName);
        this.code.append(" ={");
        Class[] cs = this.tc.getUsedConcreteClasses();
        int i = 0;
        while (i < cs.length) {
            this.code.append(JavaToken.getClassName(cs[i]));
            this.code.append(".class");
            if (i != cs.length - 1) {
                this.code.append(",");
            }
            ++i;
        }
        this.code.append(" };\n\n");
    }

    private void historyAdd() {
        this.code.append("private String ");
        this.code.append(this.historyMethodName);
        this.code.append("(String name, String[] args,boolean isNoChangeFlag) {\n");
        this.code.append("String tempHis=kikainekoHistory;\n");
        this.code.append("String temp = name;\n");
        this.code.append("if (args.length != 0) {\n");
        this.code.append("temp += \"(\";\n");
        this.code.append("for (int i = 0; i < args.length; i++) {\n");
        this.code.append("temp += args[i] + \" \";\n");
        this.code.append("}\n temp += \")\";\n}\n");
        this.code.append("temp += \";\";\n");
        this.code.append("String res=kikainekoHistory+temp;\n");
        this.code.append("if(!isNoChangeFlag){\n");
        this.code.append("kikainekoHistory=res;}\n");
        this.code.append("return res;\n}\n");
    }

    private void body() {
        int i = 0;
        while (i < this.tc.howManyMethods()) {
            int numOfArgs = 0;
            String methodSig = this.tc.getMethodName(i);
            int indexOfOpenKakko = methodSig.indexOf(40);
            String name = methodSig.substring(0, indexOfOpenKakko);
            String reType = "";
            if (!name.equals(this.tc.getClassName()) && (reType = this.tc.getReturnType(i)).equals(" ")) {
                reType = "void";
            }
            this.code.append(this.tc.getMethodVisible(i));
            this.code.append(" ");
            this.code.append(reType);
            this.code.append(" ");
            this.code.append(name);
            this.code.append("(");
            if (methodSig.length() - indexOfOpenKakko > 2) {
                StringTokenizer st = new StringTokenizer(methodSig.substring(indexOfOpenKakko + 1, methodSig.length() - 2));
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    if (s.startsWith("[")) {
                        this.code.append(JavaToken.arrayType(s));
                    } else {
                        this.code.append(s);
                    }
                    this.code.append(" arg");
                    this.code.append(numOfArgs++);
                    if (!st.hasMoreTokens()) continue;
                    this.code.append(",");
                }
            }
            this.code.append("){\n");
            this.code.append(this.message1);
            this.code.append("\n");
            if (reType.length() == 0) {
                this.code.append(this.historyFieldName);
                this.code.append("=\"\";\n\n");
            }
            this.code.append("String[] args={\n");
            if (numOfArgs != 0) {
                int j = 0;
                while (j < numOfArgs - 1) {
                    this.code.append("org.kikaineko.mock.util.ToStringer.get(");
                    this.code.append("arg");
                    this.code.append(j);
                    this.code.append(")");
                    this.code.append(",");
                    ++j;
                }
                this.code.append("org.kikaineko.mock.util.ToStringer.get(");
                this.code.append("arg");
                this.code.append(numOfArgs - 1);
                this.code.append(")");
            }
            this.code.append("};\n");
            this.code.append("String cond=");
            this.code.append(this.historyMethodName);
            this.code.append("(\"");
            this.code.append(this.tc.getMethodName(i));
            this.code.append("\",args,");
            this.code.append(this.tc.isNoChangeMethod(methodSig));
            this.code.append(");\n");
            this.code.append("String res=kikainekoReturn(cond);\n");
            this.code.append(this.message2);
            this.code.append("\n\n");
            String s = this.funcReturn(reType);
            this.code.append(s);
            this.code.append("\n}\n");
            ++i;
        }
    }

    private String funcReturn(String reType) {
        if (reType.length() == 0 || reType.equals("void")) {
            return "";
        }
        if (reType.equals("int")) {
            return "return org.kikaineko.mock.util.ReturnValue.intValue(res);";
        }
        if (reType.equals("float")) {
            return "return org.kikaineko.mock.util.ReturnValue.floatValue(res);";
        }
        if (reType.equals("long")) {
            return "return org.kikaineko.mock.util.ReturnValue.longValue(res);";
        }
        if (reType.equals("double")) {
            return "return org.kikaineko.mock.util.ReturnValue.doubleValue(res);";
        }
        if (reType.equals("char")) {
            return "return org.kikaineko.mock.util.ReturnValue.charValue(res);";
        }
        if (reType.equals("boolean")) {
            return "return org.kikaineko.mock.util.ReturnValue.booleanValue(res);";
        }
        if (reType.equals("java.lang.String")) {
            return "return org.kikaineko.mock.util.ReturnValue.stringValue(res);";
        }
        return "return (" + reType + ")org.kikaineko.mock.util.ReturnValue.getObject(" + reType + ".class,res," + this.usedClassesFieldName + ");";
    }

    private void footer() {
        this.code.append("}");
    }

    private void head() {
        this.code.append("package ");
        this.code.append(this.tc.getPack());
        this.code.append(";\n\n");
        this.code.append("/**\n");
        this.code.append("*\n");
        this.code.append("* @author KikainekoMocker v");
        this.code.append(Version.version);
        this.code.append(" \n");
        this.code.append("*\n");
        this.code.append("* TODO To change.This is mock.\n");
        this.code.append("*/\n");
        this.code.append("public class ");
        this.code.append(this.tc.getClassName());
        if (this.tc.hasSuperClass()) {
            if (this.tc.getSuperClass().isInterface()) {
                this.code.append(" implements ");
                this.code.append(this.tc.getSuperClass().getName());
            } else {
                this.code.append(" extends ");
                this.code.append(this.tc.getSuperClass().getName());
            }
        }
        this.code.append(" {\n");
        this.code.append("private String ");
        this.code.append(this.historyFieldName);
        this.code.append("=\"\";\n\n");
    }

    private void returnMethod() {
        this.code.append("private final String[] kikainekoHis={\n");
        int i = 0;
        while (i < this.tc.howManyHistories() - 1) {
            this.code.append("\"");
            this.code.append(this.tc.getHistory(i));
            this.code.append("\",");
            ++i;
        }
        this.code.append("\"");
        this.code.append(this.tc.getHistory(this.tc.howManyHistories() - 1));
        this.code.append("\"};\n\n");
        this.code.append("private final String[] kikainekoRes={\n");
        i = 0;
        while (i < this.tc.howManyHistories() - 1) {
            this.code.append("\"");
            this.code.append(this.tc.getValueAtHistory(i));
            this.code.append("\",");
            ++i;
        }
        this.code.append("\"");
        this.code.append(this.tc.getValueAtHistory(this.tc.howManyHistories() - 1));
        this.code.append("\"};\n\n");
        this.code.append("private String kikainekoReturn(String arg){ \n");
        this.code.append("for(int i=0;i<kikainekoHis.length;i++){\n");
        this.code.append("if(kikainekoHis[i].equals(arg)) return kikainekoRes[i];\n");
        this.code.append("}\n");
        this.code.append("return \"0\";\n");
        this.code.append("}\n");
    }
}

