/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.sourcescan;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.sourcescan.CommentAutomaton;
import org.kikaineko.sourcescan.Tokenizer;

public class CodeReader {
    private BufferedReader sourceReader;
    private CommentAutomaton ca = new CommentAutomaton();
    private TokenArray ta = new TokenArray();

    public CodeReader(File file) {
        try {
            this.sourceReader = new BufferedReader(new FileReader(file));
        }
        catch (IOException e) {
            System.out.println("Cannot Open file:" + file.getName());
            System.out.println(e);
        }
    }

    Token[] getTokensWithoutComment(String s) {
        Tokenizer tkn = new Tokenizer(s);
        Token[] ts = tkn.getTokens();
        Vector<Token> vec = new Vector<Token>();
        int i = 0;
        while (i < ts.length) {
            int state = this.ca.state(ts[i]);
            if (state == 0) break;
            if (!this.ca.isStateComment()) {
                ts[i].isLiteral = this.ca.isLiteral();
                vec.add(ts[i]);
            }
            ++i;
        }
        ts = new Token[vec.size()];
        i = 0;
        while (i < ts.length) {
            ts[i] = (Token)vec.get(i);
            ++i;
        }
        return ts;
    }

    public TokenArray getTokenArrayWithoutComment() {
        try {
            String s;
            while ((s = this.sourceReader.readLine()) != null) {
                if (s.trim().length() == 0) continue;
                Token[] ts = this.getTokensWithoutComment(s);
                this.ta.addArray(ts);
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return this.ta;
    }
}

