/*
 * 쐬F 2005/03/08
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.analysis;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Stack;
import java.util.Vector;

import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.TestClass;
import org.kikaineko.mock.util.KikainekoChar;
import org.kikaineko.mock.util.Operator;
import org.kikaineko.mock.util.ToStringer;
import org.kikaineko.source.util.JavaToken;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;

/**
 * @author Masayuki Ioki
 * 
 * @BLbJ[̐SB ۂɉ͂sAbÑRA𐶐B
 */
public class SmallCompiler implements Analyst {

    private int index;

    private TestClass tc;

    private VariableTable vt;

    private TokenArray ta;

    private Stack stackVal;

    private TypeOwner stackType;

    private int currentLevel = 0;

    private String targetName;

    private TargetClass target;

    protected StringBuffer history;

    protected StringBuffer setUpHistory;

    private VariableTable setUpVt;

    private ClassNameResolver cnr;

    public SmallCompiler(TestClass tc, TargetClass tar) {
        this.target = tar;
        this.tc = tc;
        targetName = target.getInstanceName();
        cnr = new ClassNameResolver(tc.packageName(), tc.getImports());
    }

    public void analyze() throws Exception{
        try {
            setUpanalyze();
            for (int i = 0; i < tc.howManyTestMethods(); i++) {
                analyze(i);
            }
            target.setUsedConcreteClasses(stackType.pushedConcreteClasses());
        } catch (Throwable t) {
            String message="";
            if(index>=2)
                message=ta.getVal(index-2)+" "+ta.getVal(index-1)+" "+ta.getVal(index);
            else if(index>=1)
                message=ta.getVal(index-1)+" "+ta.getVal(index);
            else
                message=ta.getVal(index);
            throw new Exception("\""+message+"\" has a bad word.");
        }
    }

    protected void setUpanalyze() {
        if (setUpHistory == null) {
            vt = new VariableTable();
            stackVal = new Stack();
            stackType = new TypeOwner();
            history = new StringBuffer();

            ta = tc.getSetUp().getTokenArray();
            index = ta.indexOfVal("{");
            index++;
            block();

            setUpHistory = history;
            setUpVt = vt;
        }
    }

    protected void analyze(int i) {
        stackVal = new Stack();
        stackType = new TypeOwner(stackType.getPushedVec());
        //̃tB[hꍇɁAɕύX
        //vt = (VariableTable) setUpVt.clone();
        vt = new VariableTable();
        history = new StringBuffer(setUpHistory.toString());
        ta = tc.getTestMethod(i).getTokenArray();
        index = ta.indexOfVal("{");
        index++;
        block();
    }

    private void block() {
        currentLevel++;
        blockBody();
        currentLevel--;
    }

    private void blockBody() {
        while (true) {
            String s = ta.getVal(index++);
            if (!s.equals(targetName) && isVariable(s)) {
                Class c = cnr.getClazz(s);
                variable(c);
            } else if (!s.equals("}")) {
                statement(s);
            } else {
                break;
            }
        }
    }

    private int setArray() {
        index++;//{
        int depth = 0;
        while (true) {
            Token t = ta.getToken(index);
            if (t.getKind() == TokenKind.BlockClose)
                break;
            else if (t.getKind() == TokenKind.Kanme)
                index++;
            else {
                depth++;
                expression();
            }
        }
        index++;//}
        return depth;
    }

    private void setVariableArray(String name) {
        if (ta.getVal(index).equals("new")) {
            expression();
            Object o = stackVal.pop();
            stackType.pop();
            vt.setValAndLevel(name, o, currentLevel);
        } else if (ta.getVal(index).equals("{")) {
            int leng = setArray();
            Object[] os = new Object[leng];
            for (int i = leng - 1; i >= 0; i--) {
                os[i] = stackVal.pop();
                stackType.pop();
            }
            vt.setValAndLevel(name, os, currentLevel);
        }
    }

    private void variable(Class type) {
        Token t = ta.getToken(index++);
        if (t.getKind() != TokenKind.ArrayOpen) {
            String name = t.getVal();
            Token t2 = ta.getToken(index++);

            if (t2.getKind() != TokenKind.ArrayOpen) {
                String s = t2.getVal();
                vt.addVariable(name, type, currentLevel);
                if (s.equals("=")) {
                    expression();
                    Object o = stackVal.pop();
                    stackType.pop();
                    vt.setValAndLevel(name, o, currentLevel);
                }
            } else {
                index++;// ]i܂
                vt.addVariable(name, ClassNameResolver.getArrayClass(type),
                        currentLevel);
                String s = ta.getVal(index++);
                if (s.equals("=")) {
                    setVariableArray(name);
                }
            }
        } else {
            index++;// ]i܂
            String name = ta.getVal(index++);
            if (name.equals("[")) {
                index--;
                variable(ClassNameResolver.getArrayClass(type));
            } else {
                //TODO
                vt.addVariable(name, ClassNameResolver.getArrayClass(type),
                        currentLevel);
            }
            String s = ta.getVal(index++);
            if (s.equals("=")) {
                setVariableArray(name);

            }

        }

        if (ta.getVal(index).equals(",")) {
            index++;
            variable(type);
        }
    }

    private void expression() {
        term();
        while (true) {
            Token t = ta.getToken(index);

            if (t.getKind() == TokenKind.Plus) {
                index++;
                term();
                stackVal.push(Operator.operate(stackVal.pop(), stackVal.pop(),
                        "+"));
                stackType.push(Operator.strongType(stackType.pop(), stackType
                        .pop()));
            } else if (t.getKind() == TokenKind.Minus) {
                index++;
                term();
                stackVal.push(Operator.operate(stackVal.pop(), stackVal.pop(),
                        "-"));
                stackType.push(Operator.strongType(stackType.pop(), stackType
                        .pop()));
            } else {
                break;
            }
        }
    }

    private void term() {
        factor();
        while (true) {
            Token t = ta.getToken(index);
            if (t.getKind() == TokenKind.Star) {
                index++;
                factor();
                stackVal.push(Operator.operate(stackVal.pop(), stackVal.pop(),
                        "*"));
                stackType.push(Operator.strongType(stackType.pop(), stackType
                        .pop()));
            } else if (t.getKind() == TokenKind.Slash) {
                index++;
                factor();
                stackVal.push(Operator.operate(stackVal.pop(), stackVal.pop(),
                        "/"));
                stackType.push(Operator.strongType(stackType.pop(), stackType
                        .pop()));
            } else {
                break;
            }
        }
    }

    private void numberPush(Token t) {
        String s = ta.getVal(index);
        if (s.equals("l") || s.equals("L")) {
            index++;
            stackVal.push(new Long(t.getVal()));
            stackType.push(long.class);
        } else if (s.equals("d") || s.equals("D")) {
            index++;
            stackVal.push(new Double(t.getVal()));
            stackType.push(double.class);
        } else if (s.equals("f") || s.equals("F")) {
            index++;
            stackVal.push(new Float(t.getVal()));
            stackType.push(float.class);
        } else if (s.equals(".")) {
            afterPiriodPush(t);
        } else {
            stackVal.push(new Integer(t.getVal()));
            stackType.push(int.class);
        }
    }

    private void afterPiriodPush(Token t) {
        index++;
        Token tt = ta.getToken(index);
        Token tt2 = ta.getToken(index + 1);
        if (tt.getKind() == TokenKind.Number) {
            if (tt2.getVal().equals("f") || tt2.getVal().equals("F")) {
                index = index + 2;
                stackVal.push(new Float(t.getVal() + "." + tt.getVal()));
                stackType.push(float.class);
            } else if (tt2.getVal().equals("d") || tt2.getVal().equals("D")) {
                index = index + 2;
                stackVal.push(new Double(t.getVal() + "." + tt.getVal()));
                stackType.push(double.class);
            } else {
                index++;
                stackVal.push(new Double(t.getVal() + "." + tt.getVal()));
                stackType.push(double.class);
            }
        } else if (tt.getVal().equals("f") || tt.getVal().equals("F")) {
            stackVal.push(new Float(t.getVal() + "." + tt.getVal()));
            stackType.push(float.class);
        } else {
            stackVal.push(new Double(t.getVal()));
            stackType.push(double.class);
        }
    }

    private void method(String type) {

        String name = ta.getVal(index++);
        Object[] argsO = null;
        Class[] cs = null;
        if (ta.getVal(index).equals("(")) {
            Object[] oss = arg();
            if (oss != null) {
                argsO = (Object[]) oss[0];
                cs = (Class[]) oss[1];
            }
        }
        try {
            Object ro = null;
            if (type.equals("method")) {
                Object o = stackVal.pop();
                stackType.pop();

                Class clazz = o.getClass();
                Method m = clazz.getMethod(name, cs);
                ro = m.invoke(o, argsO);
                stackType.push(m.getReturnType());
            } else {
                Class clazz = cnr.getClazz(name);
                Constructor csr = clazz.getConstructor(cs);
                ro = csr.newInstance(argsO);
                stackType.push(ro.getClass());
            }
            stackVal.push(ro);
        } catch (Exception e) {
            System.out.println(e);
        }
        index++;
        if (ta.getVal(index).equals(".")) {
            index++;
            method("method");
        }
    }

    private Object[] arg() {
        Vector vec = new Vector();
        Vector cvec = new Vector();
        index++;
        if (ta.getVal(index).equals(")")) {
            Object[] oss = { null, null };
            return oss;
        }

        while (true) {
            expression();

            vec.add(stackVal.pop());
            cvec.add(stackType.pop());
            String s = ta.getVal(index);
            if (s.equals(")"))
                break;
            else if (s.equals(","))
                index++;
        }
        Object[] os = new Object[vec.size()];
        Class[] cs = new Class[cvec.size()];
        for (int i = 0; i < os.length; i++) {
            os[i] = vec.get(i);
            cs[i] = (Class) cvec.get(i);
        }
        Object[] oss = { os, cs };
        return oss;

    }

    private void constructor() {
        method("const");
    }

    private void arrayGenerate() {
        String type = ta.getVal(index++);
        index++;
        expression();
        Object o = stackVal.pop();
        stackType.pop();

        Object os = Array.newInstance(cnr.getClazz(type), ((Number) o)
                .intValue());
        stackVal.push(os);
        stackType.push(os.getClass());
    }

    private void variablePush(Token t) {
        stackType.push(vt.getType(t.getVal()));
        stackVal.push(vt.getVal(t.getVal()));
    }

    private void factor() {
        Token t = ta.getToken(index++);

        if (t.getKind() == TokenKind.Number) {
            numberPush(t);
        } else if (t.getKind() == TokenKind.Word) {
            if (vt.include(t.getVal())) {
                variablePush(t);

                if (ta.getVal(index).equals(".")) {
                    index++;
                    method("method");
                } else if (ta.getVal(index).equals("[")) {
                    index++;
                    expression();
                    int i = ((Number) stackVal.pop()).intValue();
                    stackType.pop();

                    stackVal.push(Array.get(vt.getVal(t.getVal()), i));
                    stackType.push(JavaToken.unitTypeInArray(vt.getType(t
                            .getVal())));

                } else if (ta.getVal(index).equals("++")) {
                    index++;
                    Object ro = Operator.operate(new Integer(1), stackVal
                            .peek(), "+");
                    vt.setVal(t.getVal(), ro);
                } else if (ta.getVal(index).equals("--")) {
                    index++;
                    Object ro = Operator.operate(new Integer(1), stackVal
                            .peek(), "-");
                    vt.setVal(t.getVal(), ro);
                }

            } else if (t.getVal().equals("true")) {
                stackVal.push(new Boolean(true));
                stackType.push(boolean.class);
            } else if (t.getVal().equals("false")) {
                stackVal.push(new Boolean(false));
                stackType.push(boolean.class);
            } else if (t.getVal().equals("new")) {
                if (ta.getVal(index + 1).equals("[")) {
                    arrayGenerate();
                } else {
                    constructor();
                }
            } else if (t.getVal().equals("null")) {
                stackVal.push(null);
                stackType.push(null);
            }
        } else if (t.getKind() == TokenKind.Minus) {
            factor();
            Object o = stackVal.pop();
            //type is not changed
            negatePush(o);
        } else if (t.getKind() == TokenKind.OpenKakko) {
            expression();
            index++;
        } else if (t.getKind() == TokenKind.DoubleQ) {
            stackVal.push(ta.getVal(index++));
            stackType.push(String.class);
            index++;
        } else if (t.getKind() == TokenKind.SingleQ) {
            stackVal.push(new Character(ta.getVal(index++).charAt(0)));
            stackType.push(char.class);
            index++;
        } else if (t.getKind() == TokenKind.Bikkuri) {
            factor();
            Object o = stackVal.pop();
            negatePush(o);
            //type is not changed
        } else if (t.getKind() == TokenKind.PP) {
            Token tt = ta.getToken(index++);
            variablePush(tt);

            Object ro = Operator.operate(new Integer(1), stackVal.pop(), "+");
            vt.setVal(tt.getVal(), ro);
            stackVal.push(ro);
        } else if (t.getKind() == TokenKind.MM) {
            Token tt = ta.getToken(index++);
            variablePush(tt);

            Object ro = Operator.operate(new Integer(1), stackVal.pop(), "-");
            vt.setVal(tt.getVal(), ro);
            stackVal.push(ro);
        }
    }

    private void negatePush(Object o) {
        if (o instanceof Integer)
            stackVal.push(new Integer(-((Integer) o).intValue()));
        else if (o instanceof Long)
            stackVal.push(new Long(-((Long) o).longValue()));
        else if (o instanceof Float)
            stackVal.push(new Float(-((Float) o).floatValue()));
        else if (o instanceof Double)
            stackVal.push(new Double(-((Double) o).doubleValue()));
        else if (o instanceof Boolean)
            stackVal.push(new Boolean(!((Boolean) o).booleanValue()));
    }

    private void statement(String s) {
        if (vt.include(s)) {
            Token t = ta.getToken(index++);
            if (t.getKind() == TokenKind.Eq) {
                expression();
                vt.setVal(s, stackVal.pop());
            } else if (t.getKind() == TokenKind.Piriod) {
                stackVal.push(vt.getVal(s));
                stackType.push(vt.getType(s));
                method("method");
            } else if (t.getKind() == TokenKind.ArrayOpen) {
                expression();
                int i = ((Number) stackVal.pop()).intValue();
                stackType.pop();
                index++;//]
                index++;//=
                expression();
                Object o = stackVal.pop();
                stackType.pop();
                Array.set(vt.getVal(s), i, o);
            } else if (t.getKind() == TokenKind.PP) {
                Object o = vt.getVal(s);
                stackVal.push(o);
                stackType.push(vt.getType(s));
                Object ro = Operator.operate(new Integer(1), o, "+");
                //type is not changed
                vt.setVal(s, ro);
            } else if (t.getKind() == TokenKind.MM) {
                Object o = vt.getVal(s);
                stackVal.push(o);
                stackType.push(vt.getType(s));
                Object ro = Operator.operate(new Integer(1), o, "-");
                //type is not changed
                vt.setVal(s, ro);
            }

        } else if (s.equals("{")) {
            block();
        } else if (s.equals("++")) {
            Token t = ta.getToken(index++);
            variablePush(t);

            Object ro = Operator.operate(new Integer(1), stackVal.pop(), "+");
            vt.setVal(t.getVal(), ro);
            stackVal.push(ro);
        } else if (s.equals("--")) {
            Token t = ta.getToken(index++);
            variablePush(t);

            Object ro = Operator.operate(new Integer(1), stackVal.pop(), "-");
            vt.setVal(t.getVal(), ro);
            stackVal.push(ro);
        } else if (s.equals("assertEquals")) {
            assertEq();
        } else if (s.equals(targetName)) {
            targetInvoke();
        }
    }

    private void assertEq() {
        expression();
        Object o = stackVal.pop();
        Class c = (Class) stackType.pop();
        if (ta.getVal(index).equals(targetName)) {
            index++;
            String name = targetInvoke();
            target.addHistory(history.toString(), ToStringer.get(o));
            target.overWriteMethodReType(name, JavaToken.getClassName(c));
        } else {
            expression();
            boolean noChangeStateFlag = KikainekoChar.NOCHAGESTATE
                    .equals((String) o);
            o = stackVal.pop();
            c = (Class) stackType.pop();
            index++;
            if (ta.getVal(index++).equals(targetName)) {

                String tempHistory = history.toString();
                String name = targetInvoke();
                target.addHistory(history.toString(), ToStringer.get(o));
                target.overWriteMethodReType(name, JavaToken.getClassName(c));

                if (noChangeStateFlag) {
                    target.addNoChange(name);
                    history = new StringBuffer(tempHistory);
                }

            }
        }
    }

    private String targetInvoke() {
        Token t = ta.getToken(index++);
        String name = null;
        if (t.getKind() == TokenKind.Piriod) {
            name = targetMethod();
        } else if (t.getKind() == TokenKind.Eq) {
            if (ta.getVal(index).equals("new")) {
                index++;
                name = targetMethod();
                target.setMethodReType(name, "");
                String className = name.substring(0, name.indexOf('('));
                if (!target.getClassName().equals(className)) {
                    //eNX݂ꍇ
                    //RXgN^̖ONXɃZbgB
                    target.setClassName(className);

                    //eNX擾A^[QbgɃZbgB
                    Class c = cnr.getClazz(target.getSuperName());
                    target.setSuperClass(c);
                }
            }
        }
        return name;
    }

    private String targetMethod() {
        String name = ta.getVal(index++);
        Object[] o2 = arg();
        Object[] os = (Object[]) o2[0];
        Class[] cs = (Class[]) o2[1];
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append("(");
        if (cs != null) {
            for (int i = 0; i < cs.length; i++) {
                sb.append(cs[i].getName());
                sb.append(" ");
            }
        }
        sb.append(")");
        String methodSign = sb.toString();
        target.addMethod(methodSign, "void");

        history.append(methodSign);
        if (os != null) {
            history.append("(");
            for (int i = 0; i < os.length; i++) {
                history.append(ToStringer.get(os[i]));
                history.append(" ");
            }
            history.append(")");
        }
        history.append(";");

        return methodSign;
    }

    protected boolean isVariable(String s) {
        if (JavaToken.isPremit(s)) {
            return true;
        }
        Class c = cnr.getClazz(s);

        return c != null;
    }

    public TargetClass getTargetClass() {
        return target;
    }

    public TestClass getTestClass() {
        return tc;
    }

    protected VariableTable getVariableTable() {
        return vt;
    }
}