/*
 * 쐬F 2005/03/14
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.analysis;

import java.io.File;

import junit.framework.TestCase;


import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.sourcescan.CodeReader;


/**
 * eXg͂Ă邩̃eXgB
 * ɃCv^[͂łԂɂȂĂ邩mFB
 * @author Masayuki Ioki
 *
 */
public class SmallCompiler1Test extends TestCase {
	TargetClass target;
	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}
	
	public void testArrayUser() throws Exception {
		Analyst ta = new TestAnalyst(new CodeReader(new File(
		"fortest\\tc\\ArrayUserTest.java")).getTokenArrayWithoutComment());
		ta.analyze();
		Analyst mi=new SmallCompiler(ta.getTestClass(),ta.getTargetClass());
		mi.analyze();
		target=mi.getTargetClass();
		assertEquals(6,target.howManyMethods());
		
		assertEquals("ArrayUser()",target.getMethodName(0));
		assertEquals("set([I )",target.getMethodName(1));
		assertEquals("set(int )",target.getMethodName(2));
		assertEquals("length()",target.getMethodName(3));
		assertEquals("set([Lorg.kikaineko.source.util.Token; )",target.getMethodName(4));
		assertEquals("getToken(org.kikaineko.source.util.Token )",target.getMethodName(5));
		
		assertEquals(true,target.isNoChangeMethod("length()"));
	}
	
	public void testIntUser() throws Exception {
		Analyst ta = new TestAnalyst(new CodeReader(new File(
		"fortest\\tc\\IntUserTest.java")).getTokenArrayWithoutComment());
		ta.analyze();
		Analyst mi=new SmallCompiler(ta.getTestClass(),ta.getTargetClass());
		mi.analyze();
		target=mi.getTargetClass();
		assertEquals("IntUser()",target.getMethodName(0));
		assertEquals("get()",target.getMethodName(1));
		assertEquals("int",target.getReturnType(1));
		assertEquals("10",target.getValueAtHistory(0));
		
	}
	
	public void testTestReaderTest0Test()throws Exception {
		Analyst ta = new TestAnalyst(new CodeReader(new File(
		"fortest\\tc\\TestReaderTest0Test.java")).getTokenArrayWithoutComment());
		ta.analyze();
		Analyst mi=new SmallCompiler(ta.getTestClass(),ta.getTargetClass());
		mi.analyze();
		target=mi.getTargetClass();
		assertEquals(10,target.howManyMethods());
		assertEquals("Tasu()",target.getMethodName(0));
		assertEquals("add(int int )",target.getMethodName(1));
		assertEquals("add(double double )",target.getMethodName(2));
		
		assertEquals("add(float float )",target.getMethodName(3));
		assertEquals("int",target.getReturnType(3));
		
		assertEquals("add(long long )",target.getMethodName(4));
		assertEquals("long",target.getReturnType(4));
		
		assertEquals("add(java.lang.String java.lang.String )",target.getMethodName(5));
		assertEquals("java.lang.String",target.getReturnType(5));
		
		assertEquals("add(char char )",target.getMethodName(6));
		assertEquals("char",target.getReturnType(6));
		
		assertEquals("add(int java.lang.String )",target.getMethodName(7));
		
		assertEquals("ok()",target.getMethodName(8));
		assertEquals("boolean",target.getReturnType(8));
		
		assertEquals(13,target.howManyHistories());
		java.lang.String s=target.getHistory(0);
		assertEquals("Tasu();add(int int )(1 1 );",s);
		assertEquals("2",target.getValueAtHistory(0));
		
		s=target.getHistory(1);
		assertEquals("Tasu();add(int int )(2 1 );",s);
		assertEquals("3",target.getValueAtHistory(1));
		
		s=target.getHistory(2);
		assertEquals("Tasu();add(double double )(2.0 1.0 );",s);
		
		s=target.getHistory(3);
		assertEquals("Tasu();add(float float )(2.0 1.0 );",s);
		assertEquals("3",target.getValueAtHistory(3));
		
		s=target.getHistory(4);
		assertEquals("Tasu();add(long long )(2 1 );",s);
		
		s=target.getHistory(5);
		assertEquals("Tasu();add(double double )(3.0 0.0 );",s);
		
		
		s=target.getHistory(6);
		assertEquals("Tasu();add(java.lang.String java.lang.String )(1 2 );",s);
		assertEquals("3",target.getValueAtHistory(5));
		
		s=target.getHistory(7);
		assertEquals("Tasu();add(char char )(49 50 );",s);
		assertEquals("3",target.getValueAtHistory(6));
		
		s=target.getHistory(8);
		assertEquals("Tasu();add(int java.lang.String )(1 1 );",s);
		
		s=target.getHistory(9);
		assertEquals("Tasu();add(double double )(1.0 2.0 );",s);
		
		s=target.getHistory(10);
		assertEquals("Tasu();add(int int )(4 -1 );",s);
		
		s=target.getHistory(11);
		assertEquals("Tasu();ok();",s);
		assertEquals("true",target.getValueAtHistory(11));
		
		s=target.getHistory(12);
		assertEquals("Tasu();ok(boolean )(false );",s);
		assertEquals("false",target.getValueAtHistory(12));
	}

}
