/*
 * 쐬F 2005/03/09
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.analysis;

import java.io.File;
import java.lang.reflect.Array;

import junit.framework.TestCase;


import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.util.ToStringer;
import org.kikaineko.sourcescan.CodeReader;



/**
 * TasuTest.java͂eXg
 * ɕϐ\̊mFB
 * 
 * @author Masayuki Ioki
 *
 */
public class SmallCompilerTest extends TestCase {
	SmallCompiler mi;

	VariableTable vt;

	TargetClass target;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		
		TestAnalyst ta = new TestAnalyst(new CodeReader(new File(
				"fortest\\tc\\TasuTest.java")).getTokenArrayWithoutComment());
		ta.analyze();
		
		
		mi = new SmallCompiler(ta.getTestClass(), ta.getTargetClass());
		mi.setUpanalyze();
		mi.analyze(0);
		vt = mi.getVariableTable();
		target = mi.getTargetClass();
	}
	
	/**
	 * Nulll擾łĂ邩̃eXg
	 *
	 */
	public void testNull(){
		assertEquals(null,vt.getVal("s2"));
		assertEquals(String.class,vt.getType("s2"));
		assertEquals("ho",vt.getValToString("s3"));
		assertEquals(String.class,vt.getType("s3"));
		assertEquals(null,vt.getVal("s4"));
		assertEquals(String.class,vt.getType("s4"));
	}
	
	/**
	 * \bhĂ΂Ă邩̃eXg
	 *
	 */
	public void testMethodInvoke(){
		assertEquals("10",vt.getValToString("iii7"));
		assertEquals(int.class,vt.getType("iii7"));
	}
	
	/**
	 * ++A--̃eXg
	 *
	 */
	public void testIncreDecre(){
		assertEquals("2", vt.getValToString("iii2"));
		assertEquals("1", vt.getValToString("iii3"));
		assertEquals("1", vt.getValToString("iii4"));
		assertEquals("2", vt.getValToString("iii5"));
		
		assertEquals("11", vt.getValToString("iii10"));
		assertEquals("8", vt.getValToString("iii11"));
		assertEquals("8", vt.getValToString("iii12"));
	}
	
	/**
	 * z̃eXg
	 *
	 */
	public void testArray(){
		assertEquals(true,vt.include("iis"));
		assertEquals(int[].class,vt.getType("iis"));
		assertEquals("1",Array.get(vt.getVal("iis"),0).toString());
		assertEquals("aho",Array.get(vt.getVal("sss1"),0).toString());
		assertEquals(int.class, vt.getType("iii1"));
		assertEquals("1", vt.getValToString("iii1"));
		assertEquals("3",Array.get(vt.getVal("iis2"),2).toString());
		assertEquals("s3",Array.get(vt.getVal("sss2"),2).toString());
		assertEquals("[s1 s2 s3 ]", ToStringer.get(vt.getVal("sss2")));
		
		assertEquals("101", ToStringer.get(vt.getVal("iii13")));
		
	}
	
	
	public void testTarget() {
		assertEquals("hoge(int )", target.getMethodName(0));
		assertEquals("hoge()", target.getMethodName(1));
		assertEquals("hoge(int int )", target.getMethodName(2));
		assertEquals("Tasu()", target.getMethodName(3));
		assertEquals("add(int int )", target.getMethodName(4));
		assertEquals(5,target.howManyMethods());
		assertEquals("hoge(int )(1 );hoge();hoge(int int )(2 3 );Tasu();add(int int )(1 100 );",
				mi.history.toString());
		assertEquals(1,target.howManyHistories());
		assertEquals("hoge(int )(1 );hoge();hoge(int int )(2 3 );Tasu();add(int int )(1 100 );",target.getHistory(0));
		assertEquals("101",target.getValueAtHistory(0));
		assertEquals("int",target.getReturnType(4));
	}
	
	
	public void testMethod() {
		assertEquals("123", vt.getValToString("ss2"));
		assertEquals("3", vt.getValToString("i7"));
		assertEquals("2", vt.getValToString("i8"));
		assertEquals("2", vt.getValToString("i9"));
		assertEquals("56", vt.getValToString("ss4"));
		assertEquals("10", vt.getValToString("in"));
		assertEquals(Integer.class, vt.getType("in"));
		assertEquals(new Integer(10), vt.getVal("in"));
		assertEquals("0", vt.getValToString("i10"));
		assertEquals("0", vt.getValToString("in3"));
		assertEquals(Integer.class, vt.getType("in3"));
		assertEquals("234", vt.getValToString("ss6"));
	}

	public void testConst() {
		assertEquals("1", vt.getValToString("sb"));
		assertEquals("ab", vt.getValToString("sb2"));
	}
	
	/**
	 * ϐ\̃eXg
	 *
	 */
	public void testVtable() {
		assertEquals(true, vt.include("i"));
		assertEquals("1", vt.getValToString("i"));
		assertEquals(int.class, vt.getType("i"));
		assertEquals("100", vt.getValToString("j"));
		assertEquals("20", vt.getValToString("hoge"));
		assertEquals("5", vt.getValToString("a"));
		assertEquals("8", vt.getValToString("k"));
		assertEquals("12", vt.getValToString("l"));
		assertEquals("25", vt.getValToString("m"));
		assertEquals("61", vt.getValToString("n"));
		assertEquals("2", vt.getValToString("o"));
		assertEquals("-1", vt.getValToString("p"));
		assertEquals("-19", vt.getValToString("q"));
		assertEquals("800", vt.getValToString("r"));
		assertEquals("12", vt.getValToString("s"));
		assertEquals("16", vt.getValToString("t"));
		assertEquals("20", vt.getValToString("u"));
		assertEquals("aho", vt.getValToString("ss"));
		assertEquals("ahohoge", vt.getValToString("s1"));
		assertEquals("10", vt.getValToString("v"));
		assertEquals("-1", vt.getValToString("w"));
		assertEquals("100", vt.getValToString("x"));
		assertEquals("1", vt.getValToString("la"));
		assertEquals(long.class, vt.getType("la"));
		assertEquals("100000000000000000", vt.getValToString("lb"));
		assertEquals("100000000000000001", vt.getValToString("lc"));
		assertEquals("1.0", vt.getValToString("da"));
		assertEquals("2.0", vt.getValToString("db"));
		assertEquals("3.0", vt.getValToString("dc"));
		assertEquals("3.0", vt.getValToString("dd"));
		assertEquals("3.0", vt.getValToString("de"));
		assertEquals("1", vt.getValToString("f1"));
		assertEquals(float.class,vt.getType("f1"));
		//assertTrue(vt.getVal("f1") instanceof Float);
		assertEquals("2.0", vt.getValToString("f2"));
		assertEquals("2.0", vt.getValToString("f3"));
		assertEquals("2.0", vt.getValToString("f4"));
		assertEquals("3.0", vt.getValToString("f5"));

		assertEquals("a", vt.getValToString("c1"));
		assertEquals("2", vt.getValToString("c2"));

		assertEquals("ahoge", vt.getValToString("ss1"));

		assertEquals("true", vt.getValToString("b1"));
		assertEquals("false", vt.getValToString("b2"));
		assertEquals("false", vt.getValToString("b3"));

		assertEquals("10", vt.getValToString("i5"));

		assertEquals("10", vt.getValToString("fff"));
		
		
		assertEquals(int[][].class, vt.getType("ia2"));
		assertEquals(int[][][].class, vt.getType("ia3"));
		
		assertEquals("-1000.0", vt.getValToString("ddd"));
		assertEquals("1000.0", vt.getValToString("dddd"));
		assertEquals("aho100", vt.getValToString("sss"));
		assertEquals("0", vt.getValToString("iii"));
		
		assertEquals("0", vt.getValToString("xx"));
	}
	
	/**
	 * ubÑx̃eXg
	 *
	 */
	public void testLevel() {
		assertEquals(2, vt.getLevle("i5"));
		assertEquals(1, vt.getLevle("sss"));
		assertEquals(3, vt.getLevle("i6"));
	}
	
	/**
	 * ϐĂ邩̃eXg
	 *
	 */
	public void testIsVariable() {
		assertEquals(true, mi.isVariable("int"));
		assertEquals(true, mi.isVariable("String"));
		assertEquals(true, mi.isVariable("TestCase"));
		assertEquals(false, mi.isVariable("Calc"));
		assertEquals(false, mi.isVariable("dorararara"));
	}

}