/*
 * Created on 2005/02/19
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.kikaineko.mock.analysis;


import org.kikaineko.mock.framework.Import;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.TestClass;
import org.kikaineko.source.util.JavaToken;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;

/**
 * @author masayuki
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class TestAnalyst implements Analyst{
	private TokenArray ta;

	private TestClass tc;

	private TargetClass target;

	/**
	 * @param tokeArrayWithoutComment
	 */
	public TestAnalyst(TokenArray inTa){
		this.ta = inTa;
	}
	
	public void analyze()throws Exception{
		setTestClass();
		setTargetClass();
		setSetUp();
		setTestMethod();
	}

	/**
	 *  
	 */
	private void setSetUp() {
		int start = ta.indexOfVal("protected", "void", "setUp");
		if (start != -1) {
			int end = getIndexOfClosed(ta, start, "{", "}");
			tc.setSetUp(ta.takeSubArray(start, end + 1));
		}
	}

	private void setTestMethod() {
		int start = getIndexOfTestMethod();
		while (start != -1) {
			int end = getIndexOfClosed(ta, start, "{", "}");
			tc.addTestMethod(ta.takeSubArray(start, end + 1));
			start = getIndexOfTestMethod();
		}
	}

	private int getIndexOfTestMethod() {
		int start = -1;
		do {
			start = ta.indexOfVal("public", "void", start + 1);
			if (start != -1 && ta.getVal(start + 2).startsWith("test"))
				return start;
		} while (start != -1);
		return -1;
	}

	private static int getIndexOfClosed(TokenArray arr, int start, String op,
			String cl) {
		int count = 0;
		for (int i = start; i < arr.length(); i++) {
			if (arr.getVal(i).equals(op))
				count++;
			else if (arr.getVal(i).equals(cl)) {
				count--;
				if (count == 0)
					return i;
			}
		}
		return -1;
	}

	/**
	 * @return
	 */
	private void setTestClass() throws Exception{
		int index = ta.indexOfVal("package");
		int endindex = ta.indexOfVal(";", index);
		StringBuffer sb = new StringBuffer();
		for (int i = index + 1; i < endindex; i++) {
			sb.append(ta.getVal(i));
		}
		String pack = sb.toString();
		
		Import[] im=getImports();
		
		index = ta.indexOfVal("class");
		String name = ta.getVal(index + 1);

		index = ta.indexOfVal("extends");
		if (ta.getVal(index + 1).indexOf("TestCase")==-1) {
			throw new NotTestCaseException("This class is not TestCase : " + name);
		}
		tc = new TestClass(pack, name);
		tc.setImports(im);
		
		ta = ta.takeSubArray(ta.indexOfVal("{", index) + 1, getIndexOfClosed(
				ta, index, "{", "}"));
	}
	
	private Import[] getImports(){
		int num=ta.howManyOfVal("import");
		Import[] im=new Import[num];
		for(int i=0;i<im.length;i++){
			int from =ta.indexOfVal("import");
			int end=ta.indexOfVal(";",from);
			im[i]=new Import(ta.takeSubArray(from,end+1));
		}
		return im;
		
	}

	/**
	 * @return
	 */
	private void setTargetClass() {
		int index = ta.indexOfKind(TokenKind.Word);
		while (JavaToken.isYoyakugo(ta.getVal(index))) {
			index++;
		}
		target = new TargetClass(ta.getVal(index), ta.getVal(index + 1));
		target.setPack(tc.packageName());
		if (ta.getVal(index + 2).equals(";")) {
			ta = ta.takeSubArray(index + 3);
		}
	}

	public TargetClass getTargetClass() {
		return target;
	}

	/**
	 * @return
	 */
	public TestClass getTestClass() {
		return tc;
	}

}