/*
 * 쐬F 2005/04/22
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.analysis;

import java.util.AbstractList;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;

import junit.framework.TestCase;


/**
 * @author Masayuki Ioki
 *
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
public class TypeOwnerTest extends TestCase {
    TypeOwner to;
    int size;
    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
        to=new TypeOwner();
        Class[] pushed=to.pushedConcreteClasses();
        size=pushed.length;
    }
        
    public void testArray(){
        to.push(int[].class);
        assertEquals(1,to.size());
        Class[] pushed=to.pushedConcreteClasses();
        assertEquals(size+1,pushed.length);
    }
    
    public void testPush_Simple(){
        to.push(int.class);
        to.push(StringBuffer.class);
        assertEquals(2,to.size());
    }
    
    public void testPushedConcreteClasses(){
        to.push(Integer.class);
        to.push(Vector.class);
        Class[] pushed=to.pushedConcreteClasses();
        assertEquals(size+2,pushed.length);
    }
    
    public void testNotHaveSameClass(){
        to.push(String.class);
        to.push(String.class);
        Class[] pushed=to.pushedConcreteClasses();
        assertEquals(size+1,pushed.length);
    }
    
    public void testNotHaveInterface(){
        to.push(List.class);//interface
        to.push(Character.class);
        Class[] pushed=to.pushedConcreteClasses();
        assertEquals(size+1,pushed.length);
    }
    
    public void testNotHaveAbstract(){
        to.push(AbstractList.class);//abstract
        to.push(Calendar.class);//abstract
        to.push(Object.class);
        Class[] pushed=to.pushedConcreteClasses();
        assertEquals(size+1,pushed.length);
    }

}
