/*
 * 쐬F 2005/03/14
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.runner;

import java.io.File;
import org.kikaineko.mock.analysis.Analyst;
import org.kikaineko.mock.analysis.SmallCompiler;
import org.kikaineko.mock.analysis.TestAnalyst;
import org.kikaineko.mock.framework.Filter;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.sourcescan.CodeReader;
import org.kikaineko.util.FileIO;


/**
 * @BLbJ[̃RȀsRunner<br>
 * 
 * @author masayuki
 */
public class BaseRunner implements Runner {
    private File target;

    //private CustomClassLoader ccl;

    public File targetFile() {
        return target;
    }

    protected void stetUp(File test) {
        //NX[h邽߂ɃNX[_testZbg
       // ccl = CustomClassLoader.getInstance();
        //ccl.setSourceFile(test);
    }

    protected void tearDown() {
        //ccl.destroy();
    }
    
    protected StringBuffer overWrite(StringBuffer sb){
        if (target.exists()) {
            sb.append(System.getProperty("line.separator"));
            sb.append(System.getProperty("line.separator"));
            String[] codes = FileIO.getFileDatas(target);
            for (int i = 0; i < codes.length; i++) {
                sb.append("//");
                sb.append(codes[i]);
                sb.append(System.getProperty("line.separator"));
            }
        }
        return sb;
    }
    
    protected Analyst analystFactory(Object input){
        if(input instanceof File)
            return new TestAnalyst(new CodeReader((File)input)
                    .getTokenArrayWithoutComment());
        else if(input instanceof TestAnalyst)
            return new SmallCompiler(((Analyst)input).getTestClass(), (((Analyst)input)).getTargetClass());
        return null;
    }
    
    protected TargetClass filter(TargetClass tc){
        return Filter.execute(tc);
    }

    public final StringBuffer doRun(File test) throws Exception {
        
        stetUp(test);
        
        StringBuffer dame = new StringBuffer();

        Analyst preAnalyst = analystFactory(test);
        preAnalyst.analyze();

        target = new File(test.getParentFile(), preAnalyst.getTargetClass()
                .getClassName()
                + ".java");
        
        Analyst scom = analystFactory(preAnalyst);
        scom.analyze();
        
        TargetClass tc=filter(scom.getTargetClass());
        
        
        Implementer im = new Implementer(tc);
        File parent = test.getParentFile();
        target = new File(parent, im.getTargetFile().getName());
        
        tearDown();
        
        return overWrite(new StringBuffer(im.getCode()));
        
    }
}