/*
 * Created on 2005/02/22
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.kikaineko.mock.runner;

import java.io.File;
import java.util.StringTokenizer;

import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.util.Version;
import org.kikaineko.source.util.JavaToken;

/**
 * @author masayuki
 */
public class Implementer {
	private TargetClass tc;

	private String historyMethodName = "kikainekoHistoryAdd";

	private String historyFieldName = "kikainekoHistory";

	private String returnMethodName = "kikainekoReturn";
	
	private String usedClassesFieldName = "kikainekoUsedConcreteClasses";

	private String message1 = "//TODO To change.Mock Part Start ...";
	private String message2 = "//TODO To change.Mock Part End.";

	private StringBuffer code;

	public Implementer(TargetClass tc) {
		this.tc = tc;
		code = new StringBuffer();
		make();
	}

	public File getTargetFile() {
		String targetFileName = tc.getPack().replace('.', '\\') + "\\"
				+ tc.getClassName() + ".java";
		return new File(targetFileName);
	}

	private void make() {
		head();
		body();
		historyAdd();
		returnMethod();
		usedClasses();
		footer();
	}

	public String getCode() {
		return code.toString();
	}
	
	private void usedClasses(){
	    code.append("private static final Class[] ");
	    code.append(usedClassesFieldName);
	    code.append(" ={");
	    Class[] cs =tc.getUsedConcreteClasses();
	    for(int i=0;i<cs.length;i++){
	        code.append(JavaToken.getClassName(cs[i]));
	        code.append(".class");
	        if(i!=cs.length-1)
	            code.append(",");
	    }
	    code.append(" };\n\n");
	}

	private void historyAdd() {
		code.append("private String ");
		code.append(historyMethodName);
		code.append("(String name, String[] args,boolean isNoChangeFlag) {\n");
		code.append("String tempHis=kikainekoHistory;\n");
		code.append("String temp = name;\n");
		code.append("if (args.length != 0) {\n");
		code.append("temp += \"(\";\n");
		code.append("for (int i = 0; i < args.length; i++) {\n");
		code.append("temp += args[i] + \" \";\n");
		code.append("}\n temp += \")\";\n}\n");
		code.append("temp += \";\";\n");
		code.append("String res=kikainekoHistory+temp;\n");
		code.append("if(!isNoChangeFlag){\n");
		code.append("kikainekoHistory=res;}\n");
		code.append("return res;\n}\n");
	}

	/**
	 *  
	 */
	private void body() {
		for (int i = 0; i < tc.howManyMethods(); i++) {
			int numOfArgs = 0;
			String methodSig=tc.getMethodName(i);
			int indexOfOpenKakko=methodSig.indexOf('(');
			String name=methodSig.substring(0,indexOfOpenKakko);
			String reType = "";
			if (!name.equals(tc.getClassName())) {
				reType = tc.getReturnType(i);
				if (reType.equals(" ")) {
					reType = "void";
				}
			}
			code.append(tc.getMethodVisible(i));
			code.append(" ");
			code.append(reType);
			code.append(" ");
			code.append(name);
			code.append("(");
			if (methodSig.length()-indexOfOpenKakko > 2) {
				StringTokenizer st=new StringTokenizer(methodSig.substring(indexOfOpenKakko+1,methodSig.length()-2));
				while(st.hasMoreTokens()){
					String s=st.nextToken();
					if(s.startsWith("[")){
						code.append(JavaToken.arrayType(s));
					}else{
						code.append(s);
					}
					code.append(" arg");
					code.append(numOfArgs++);
					
					if(st.hasMoreTokens()){
						code.append(",");
					}
				}
			}
			code.append("){\n");

			code.append(message1);
			code.append("\n");

			if (reType.length() == 0) {
				code.append(historyFieldName);
				code.append("=\"\";\n\n");
			}

			code.append("String[] args={\n");
			if (numOfArgs != 0) {
				for (int j = 0; j < numOfArgs - 1; j++) {
					code.append("org.kikaineko.mock.util.ToStringer.get(");
					code.append("arg");
					code.append(j);
					code.append(")");
					code.append(",");
				}
				code.append("org.kikaineko.mock.util.ToStringer.get(");
				code.append("arg");
				code.append(numOfArgs - 1);
				code.append(")");
			}
			code.append("};\n");

			code.append("String cond=");
			code.append(historyMethodName);
			code.append("(\"");
			code.append(tc.getMethodName(i));
			code.append("\",args,");
			code.append(tc.isNoChangeMethod(methodSig));
			code.append(");\n");

			code.append("String res=kikainekoReturn(cond);\n");
			
			code.append(message2);
			code.append("\n\n");
			
			String s = funcReturn(reType);
			code.append(s);
			code.append("\n}\n");
		}
	}

	private String funcReturn(String reType) {
		if (reType.length() == 0 || reType.equals("void"))
			return "";
		else if (reType.equals("int"))
			return "return org.kikaineko.mock.util.ReturnValue.intValue(res);";
		else if (reType.equals("float"))
			return "return org.kikaineko.mock.util.ReturnValue.floatValue(res);";
		else if (reType.equals("long"))
			return "return org.kikaineko.mock.util.ReturnValue.longValue(res);";
		else if (reType.equals("double"))
			return "return org.kikaineko.mock.util.ReturnValue.doubleValue(res);";
		else if (reType.equals("char"))
			return "return org.kikaineko.mock.util.ReturnValue.charValue(res);";
		else if (reType.equals("boolean"))
			return "return org.kikaineko.mock.util.ReturnValue.booleanValue(res);";
		else if (reType.equals("java.lang.String"))
			return "return org.kikaineko.mock.util.ReturnValue.stringValue(res);";
		else
		    return "return ("+reType+")org.kikaineko.mock.util.ReturnValue.getObject("+reType+".class,res,"+usedClassesFieldName+");";
	}

	/**
	 *  
	 */
	private void footer() {
		code.append("}");
	}

	private void head() {
		code.append("package ");
		code.append(tc.getPack());
		code.append(";\n\n");
		code.append("/**\n");
		code.append("*\n");
		code.append("* @author KikainekoMocker v");
		code.append(Version.version);
		code.append(" \n");
		code.append("*\n");
		code.append("* TODO To change.This is mock.\n");
		code.append("*/\n");
		code.append("public class ");
		code.append(tc.getClassName());
		
		if(tc.hasSuperClass()){
		    if(tc.getSuperClass().isInterface()){
		        code.append(" implements ");
		        code.append(tc.getSuperClass().getName());
		    }else{
		        code.append(" extends ");
		        code.append(tc.getSuperClass().getName());
		    }
		}
		
		code.append(" {\n");
		code.append("private String ");
		code.append(historyFieldName);
		code.append("=\"\";\n\n");
	}

	private void returnMethod() {
		code.append("private final String[] kikainekoHis={\n");
		for (int i = 0; i < tc.howManyHistories() - 1; i++) {
			code.append("\"");
			code.append(tc.getHistory(i));
			code.append("\",");
		}
		code.append("\"");
		code.append(tc.getHistory(tc.howManyHistories() - 1));
		code.append("\"};\n\n");

		code.append("private final String[] kikainekoRes={\n");
		for (int i = 0; i < tc.howManyHistories() - 1; i++) {
			code.append("\"");
			code.append(tc.getValueAtHistory(i));
			code.append("\",");
		}
		code.append("\"");
		code.append(tc.getValueAtHistory(tc.howManyHistories() - 1));
		code.append("\"};\n\n");

		code.append("private String kikainekoReturn(String arg){ \n");

		code.append("for(int i=0;i<kikainekoHis.length;i++){\n");
		code.append("if(kikainekoHis[i].equals(arg)) return kikainekoRes[i];\n");
		code.append("}\n");
		code.append("return \"0\";\n");
		code.append("}\n");
	}
}