/*
 * 쐬F 2005/03/14
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.util;

import junit.framework.TestCase;

/**
 * @author masayuki
 *
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
public class ArgTokenTest extends TestCase {
	ArgToken at;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}
	
	public void testNULL(){
	    at=new ArgToken("@0");
	    Object[] os=at.gets();
	    assertEquals(1,os.length);
	    assertEquals(null,os[0]);
	}
	
	public void testKara(){
	    at=new ArgToken("");
	    Object[] os=at.gets();
	    assertEquals(0,os.length);
	}
	
	public void testNext(){
		at=new ArgToken("a b c ");
		assertEquals("a",at.token());
		assertEquals("b",at.token());
		assertEquals(true,at.hasMore());
		assertEquals("c",at.token());
		assertEquals(false,at.hasMore());
	}
	
	public void testToStringer(){
		int[] is={1,2};
		at=new ArgToken(ToStringer.get(is));
		Object[] os=at.gets();
		assertEquals(1,os.length);
		Object[] os1=(Object[])os[0];
		assertEquals("1",os1[0]);
		assertEquals("2",os1[1]);
		
		String[][] ss={{"10","20"},{"11","22"}};
		at=new ArgToken(ToStringer.get(ss));
		os=at.gets();
		assertEquals(1,os.length);
		os1=(Object[])os[0];
		assertEquals(2,os1.length);
		Object[] os2_1=(Object[])os1[0];
		Object[] os2_2=(Object[])os1[1];
		assertEquals(2,os2_1.length);
		assertEquals(2,os2_2.length);
		assertEquals("10",os2_1[0]);
		assertEquals("20",os2_1[1]);
		assertEquals("11",os2_2[0]);
		assertEquals("22",os2_2[1]);
	}
	
	public void testNextWithAT(){
		at=new ArgToken("a@ b cc ");
		assertEquals("a b",at.token());
		assertEquals("cc",at.token());
		at=new ArgToken("@ a@@b cc ");
		assertEquals(" a@b",at.token());
		assertEquals("cc",at.token());
	}
	
	public void testGets(){
		Object[] ss=new ArgToken("a@ b cc @@ ").gets();
		assertEquals(3,ss.length);
		assertEquals("a b",ss[0]);
		assertEquals("cc",ss[1]);
		assertEquals("@",ss[2]);
		ss=new ArgToken("aa ").gets();
		assertEquals(1,ss.length);
		assertEquals("aa",ss[0]);
		
		ss=new ArgToken("aa @[").gets();
		assertEquals(2,ss.length);
		assertEquals("aa",ss[0]);
		assertEquals("[",ss[1]);
	}
	
	public void testArray(){
		Object[] os=new ArgToken("[a 1 2c ]").gets();
		assertEquals(1,os.length);
		Object[] ss=(Object[])os[0];
		assertEquals(3,ss.length);
		assertEquals("a",ss[0]);
		assertEquals("1",ss[1]);
		assertEquals("2c",ss[2]);
		
		os=new ArgToken("[a 1 2c ] ooo 1@ fd ").gets();
		assertEquals(3,os.length);
		assertEquals("ooo",os[1]);
		assertEquals("1 fd",os[2]);
	}
	
	public void testArrayDouble(){
		Object[] os=new ArgToken("[1 2 ] [3 4 5 6 ]").gets();
		assertEquals(2,os.length);
		Object[] ss1=(Object[])os[0];
		assertEquals(2,ss1.length);
		assertEquals("1",ss1[0]);
		assertEquals("2",ss1[1]);
		
		Object[] ss2=(Object[])os[1];
		assertEquals(4,ss2.length);
		assertEquals("3",ss2[0]);
		assertEquals("4",ss2[1]);
		assertEquals("5",ss2[2]);
		assertEquals("6",ss2[3]);
	}
	
	public void testArray2Dim(){
		Object[] bottom=new ArgToken("[[1 2 ] [3 4 5 6 ] ]").gets();
		assertEquals(1,bottom.length);
		Object[] level1=(Object[])bottom[0];
		assertEquals(2,level1.length);
		Object[] level2_1=(Object[])level1[0];
		assertEquals(2,level2_1.length);
		assertEquals("1",level2_1[0]);
		assertEquals("2",level2_1[1]);
		Object[] level2_2=(Object[])level1[1];
		assertEquals(4,level2_2.length);
		assertEquals("3",level2_2[0]);
		assertEquals("4",level2_2[1]);
		assertEquals("5",level2_2[2]);
		assertEquals("6",level2_2[3]);
	}
	
	public void testArray3Dim(){
		Object[] bottom=new ArgToken("[[[111 112 ] [121 122 ] ] [[211 212 ] [221 222 ] ] ]").gets();
		assertEquals(1,bottom.length);
		Object[] level1=(Object[])bottom[0];
		assertEquals(2,level1.length);
		
		Object[] level2_1=(Object[])level1[0];
		assertEquals(2,level2_1.length);
		Object[] level3_1=(Object[])level2_1[0];
		assertEquals(2,level3_1.length);
		assertEquals("111",level3_1[0]);
		assertEquals("112",level3_1[1]);
		Object[] level3_2=(Object[])level2_1[1];
		assertEquals(2,level3_2.length);
		assertEquals("121",level3_2[0]);
		assertEquals("122",level3_2[1]);	
		
		
		Object[] level2_2=(Object[])level1[1];
		assertEquals(2,level2_2.length);
		Object[] level3_3=(Object[])level2_2[1];
		assertEquals(2,level3_3.length);
		assertEquals("221",level3_3[0]);
		assertEquals("222",level3_3[1]);
	}
}
