/*
 * 쐬F 2005/03/15
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.util;

import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.GregorianCalendar;

import org.kikaineko.source.util.Token;

import fortest.tc.Kara;

import junit.framework.TestCase;

/**
 * @author masayuki
 *
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
public class ReturnValueTest extends TestCase {

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}
	
	public void testSanitStr(){
	    assertEquals("1 1",ReturnValue.stringValue("1@ 1"));
	    assertEquals(null,ReturnValue.stringValue(KikainekoChar.NULL));
	    assertEquals(null,ReturnValue.getObject(StringBuffer.class,KikainekoChar.NULL));
	}
	
	public void testKara(){
	    String s=ToStringer.get(new Kara());
	    Object o=ReturnValue.getObject(Kara.class,s);
	    assertEquals(Kara.class,o.getClass());
	}
	
	public void testArrayByGetObject(){
	    String[] ss={"a","b"};
	    String s=ToStringer.get(ss);
	    String[] o=(String[])ReturnValue.getObject(String[].class,s);
	    assertEquals("a",o[0]);
	    assertEquals("b",o[1]);
	}
	
	public void testClass(){
	    Class c=int.class;
	    Class c2=(Class)ReturnValue.getObject(Class.class,ToStringer.get(c));
	    assertEquals(c.getName(),c2.getName());
	    
	    Class c3=String.class;
	    Class c4=(Class)ReturnValue.getObject(Class.class,ToStringer.get(c3));
	    assertEquals(c3.getName(),c4.getName());
	    
	    c3=StringBuffer[][].class;
	    c4=(Class)ReturnValue.getObject(Class.class,ToStringer.get(c3));
	    assertEquals(c3.getName(),c4.getName());
	}
	
	public void testPremit(){
		assertEquals(1,ReturnValue.intValue("1"));
		assertEquals(2l,ReturnValue.longValue("2"));
		assertEquals(2f,ReturnValue.floatValue("2"),0);
		assertEquals(2d,ReturnValue.doubleValue("2"),0);
		assertEquals("2",ReturnValue.stringValue("2"));
		assertEquals('d',ReturnValue.charValue("100"));
		assertEquals(true,ReturnValue.booleanValue("true"));
		assertEquals("2",ReturnValue.getRupperObject(String.class,"2"));
		assertEquals("2",ReturnValue.getObject(String.class,"2"));
	}
	
	public void testArray()throws Exception{
		int[] i={1,2};
		Object o1=Array.newInstance(int[].class,1);
		
		int[] is={1,2,3};
		String s=ToStringer.get(is);
		Object[] os=(new ArgToken(s).gets());
		Object o=ReturnValue.getArray(int[].class,os[0]);
		int[] is2=(int[])o;
		assertEquals(is[0],is2[0]);
		assertEquals(is[1],is2[1]);
		assertEquals(is[2],is2[2]);
		assertEquals(is.length,is2.length);
		
		int[][] is2dim={{1,2},{3,4}};
		s=ToStringer.get(is2dim);
		os=(new ArgToken(s).gets());
		o=ReturnValue.getArray(int[][].class,os[0]);
		int[][] is2dim2=(int[][])o;
		assertEquals(is2dim[0][0],is2dim2[0][0]);
		
		
		String[][] ss={{"1","2"},{"3","4","5"}};
		s=ToStringer.get(ss);
		os=(new ArgToken(s).gets());
		o=ReturnValue.getArray(String[][].class,os[0]);
		String[][] ss2=(String[][])o;
		assertEquals(ss[0][0],ss2[0][0]);
		assertEquals(ss[0][1],ss2[0][1]);
		assertEquals(ss[1][0],ss2[1][0]);
		assertEquals(ss[1][1],ss2[1][1]);
		assertEquals(ss[1][2],ss2[1][2]);
		
		String[][][] sss={{{"1","2"},{"3","4"}},{{"1"}}};
		s=ToStringer.get(sss);
		os=(new ArgToken(s).gets());
		o=ReturnValue.getArray(String[][][].class,os[0]);
		String[][][] sss2=(String[][][])o;
		assertEquals(sss[0][0][0],sss2[0][0][0]);
	}
	
	public void testObject(){
		Token t=new Token(1,"1");
		Token t2=(Token)ReturnValue.getObject(org.kikaineko.source.util.Token.class,ToStringer.get(t));
		assertEquals(t.getVal(),t2.getVal());
		
		Integer i1=new Integer(1);
		Integer i2=(Integer)ReturnValue.getObject(java.lang.Integer.class,ToStringer.get(i1));
		assertEquals(i1,i2);
		
		StringBuffer sb1=new StringBuffer("hoge");
		StringBuffer sb2=(StringBuffer)ReturnValue.getObject(java.lang.StringBuffer.class,ToStringer.get(sb1));
		assertEquals(sb1.toString(),sb2.toString());
		
		Calendar cal=Calendar.getInstance();
		Class[] cs={GregorianCalendar.class};
		Calendar cal2=(Calendar)ReturnValue.getObject(Calendar.class,ToStringer.get(cal),cs);
		assertNotNull(cal2);
		assertEquals(cal.toString(),cal2.toString());
	}

}
