/*
 * 쐬F 2005/03/12
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.util;

import junit.framework.TestCase;

import org.kikaineko.source.util.Token;

import temp.HogeToken;

import fortest.tc.Kara;

import fortest.tc.Hara;


/**
 * @author masayuki
 * 
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎QƁB EBhE  ݒ  Java  R[hEX^C 
 * R[hEev[g
 */
public class ToStringerTest extends TestCase {

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }
    
    public void testKara(){
        assertEquals("", ToStringer.get(new Kara()));
        String s=null;
        assertEquals(KikainekoChar.NULL, ToStringer.get(s));
    }

    public void testClass() {
        assertEquals("int", ToStringer.get(int.class));
        assertEquals("[I", ToStringer.get(int[].class));
        assertEquals("[[Ljava.lang.String;", ToStringer.get(String[][].class));
    }

    public void testArray2dimOver() {
        int[][] ii = { { 1, 2 }, { 3, 4, 5, 6 } };
        assertEquals("[[1 2 ] [3 4 5 6 ] ]", ToStringer.get(ii));

        String[][][] sss = { { { "111", "112" }, { "121", "122" } },
                { { "211", "212" }, { "221", "222" } } };
        assertEquals("[[[111 112 ] [121 122 ] ] [[211 212 ] [221 222 ] ] ]",
                ToStringer.get(sss));
    }

    public void testSanit() {
        String s = " ";
        assertEquals("@ ", ToStringer.get(s));
        s = " ab ";
        assertEquals("@ ab@ ", ToStringer.get(s));
        s = " ab@";
        assertEquals("@ ab@@", ToStringer.get(s));
        s = "[]";
        assertEquals("@[@]", ToStringer.get(s));
    }

    public void testStringBuffer() {
        StringBuffer sb = new StringBuffer(10);
        assertEquals("0 false [0 0 0 0 0 0 0 0 0 0 ] ", ToStringer.get(sb));
        sb = new StringBuffer("aho");
        assertEquals("3 false [97 104 111 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ] ",
                ToStringer.get(sb));
    }

    public void testArray() {
        int[] ii = { 1, 2 };
        assertEquals("[1 2 ]", ToStringer.get(ii));
        ii[0] = -100;
        ii[1] = 1000;
        assertEquals("[-100 1000 ]", ToStringer.get(ii));
        String[] ss = { "1", "2", "3" };
        assertEquals("[1 2 3 ]", ToStringer.get(ss));
        Token[] ts = { new Token(1, "1"), new Token(2, "2") };
        assertEquals("[false 1 1  false 2 2  ]", ToStringer.get(ts));
    }

    public void testPremit() {
        assertEquals("1", ToStringer.get(1));
        assertEquals("1.0", ToStringer.get(1.0));
        assertEquals("1", ToStringer.get(1l));
        assertEquals("1.0", ToStringer.get(1f));
        assertEquals("true", ToStringer.get(true));
        assertEquals("false", ToStringer.get(false));
        assertEquals("test", ToStringer.get("test"));
        assertEquals(String.valueOf((int) 'c'), ToStringer.get('c'));

        assertEquals("0", ToStringer.get((char) 0));
    }

    public void testObjectwithToString() {
        Integer i = new Integer(1);
        assertEquals("1", ToStringer.get(i));
    }

    public void testObjectwithoutToString() {
        Token t = new Token(1, "2");
        assertEquals("false 1 2 ", ToStringer.get(t));
        assertEquals("false 0 false 1 2  ", ToStringer.get(new HogeToken(t)));
        t = new Token(1, "2 3");
        assertEquals("false 1 2@ 3 ", ToStringer.get(t));
    }
    
    public void testHara(){
        Hara h=new Hara();
        h.add(1);
        h.add(2);
        assertEquals("Hara();add(int@ )(1@ );add(int@ )(2@ ); ",ToStringer.get(h));
    }
}